#!/usr/local/bin/python
"""
    gopher_parse.py - a library for parsing files needed by a gopher server.
    Copyright (C) 2001  Adam Gurno [adam@gurno.com] [GPG key in AUTHORS]

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

import string
import gopher_format

def parsedotcap (caplocation):
	__doc__ = "This function accepts a location and returns a dictionary containing all the entries that were in the indicated .cap file, indexed by filename. " 
	return_dict = {} #This is what gets returned
	cap_file = open (caplocation, 'r')
	cap_lines = cap_file.readlines()
	cap_file.close()
	for each_line in cap_lines:
		each_line = string.strip(string.lower(each_line))
		if each_line.startswith("name="):
			return_dict["Name"] = each_line[5:]
		elif each_line.startswith("numb="):
			return_dict["Number"] = each_line[5:]
	return return_dict

def parsedotnames (nameslocation):
	__doc__ = "This function accepts a location and returns a dictionary containing all the entries that were in the indicated .names file, indexed by filename.  Each entry contains another dictionary containing the relevant information."
	namesdict = {"temp":{}}
	currentname = "temp"
	dotnamesfile = open (nameslocation, 'r')
	dotnameslist = dotnamesfile.readlines()
	dotnamesfile.close()  #keep this open as little as possible.
	for line in dotnameslist:
		line = string.strip(line)
		line_data = line[5:]
		line_type = string.lower(line[:5])
				
		if line[:1] == "#":
			continue
		elif string.strip(line) == "":
			currentname = "temp"
		elif line_type == "name=": 
			namesdict[currentname]["Name"] = line_data
			continue
		elif line_type == "numb=": 
			namesdict[currentname]["Number"] = line_data
			continue
		elif line_type == "type=":
			namesdict[currentname]["Type"] = line_data
			continue
		elif line_type == "port=": 
			namesdict[currentname]["Port"] = line_data
			continue
		elif line_type == "host=": 
			namesdict[currentname]["Host"] = line_data
			continue
		elif line_type == "path=": 
			namesdict[line_data] = namesdict["temp"].copy()
			namesdict["temp"] = {}
			currentname = line_data
	del(namesdict["temp"])
	return namesdict

def parsedotinfo (infolocation):
	__doc__ = "This function accepts a location and returns a list of formatted strings from a .info file."
	ret_list = []
	info_file = open (infolocation, 'r')
	info_lines = info_file.readlines()
	info_file.close()
	for info_line in info_lines:
		info_line = string.strip(info_line)
		info_field = string.lower(info_line[:4])
		info_data = info_line[5:]
		if info_field == "name":
			ret_list.append (gopher_format.get_info_line(info_data))
		else:
			continue
	return ret_list

def parsedotlinks (linkslocation):
	__doc__ = "This function accepts a location and returns a list of strings, formatted as if files and directories from the given .links file."
	linksdict = {"temp":{}}
	currentname = "temp"
	dotlinksfile = open (linkslocation, 'r')
	dotlinkslist = dotlinksfile.readlines()
	dotlinksfile.close()  #keep this open as little as possible.
	for line in dotlinkslist:
		line = string.strip(line)
		line_data = line[5:]
		line_type = string.lower(line[:5])
				
		if line[:1] == "#":
			continue
		elif string.strip(line) == "":
			currentname = "temp"
		elif line_type == "name=": 
			linksdict[line_data] = linksdict["temp"].copy()
			linksdict["temp"] = {}
			currentname = line_data
		elif line_type == "numb=": 
			linksdict[currentname]["Number"] = line_data
			continue
		elif line_type == "type=":
			linksdict[currentname]["Type"] = line_data
			continue
		elif line_type == "port=": 
			linksdict[currentname]["Port"] = line_data
			continue
		elif line_type == "host=": 
			linksdict[currentname]["Host"] = line_data
			continue
		elif line_type == "path=": 
			linksdict[currentname]["Path"] = line_data
			continue
	del(linksdict["temp"])
	linkslist = []
	for link_key in linksdict.keys():
		linkslist.append ("%s%s\t%s\t%s\t%s\r\n" % (
			linksdict[link_key]["Type"],
			link_key,
			linksdict[link_key]["Path"],
			linksdict[link_key]["Host"],
			linksdict[link_key]["Port"]))
	return linkslist

if __name__ == '__main__':
	print parsedotnames(".names")
