#!/usr/local/bin/python
"""
    gopher_handle.py - A lib for handling gopher requests
    Copyright (C) 2001  Adam Gurno [adam@gurno.com] [GPG key in AUTHORS]

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

# This will contain all the handle_foo subroutines.

import os, string
import gopher_parse
import gopher_format

# HADNLE FILE ###########################################################
def handle_file(file_location, goph_conn):
	__doc__ = "This sub will handle all requests for files.  Currently treats everything like a regular text file.  D'oh!"
	temp_file = open (file_location, 'r')
	goph_conn.push (temp_file.read())
	temp_file.close() #open for as little as possible.

# HADNLE DIR ###########################################################
def handle_dir(dir_location, goph_conn):
	__doc__ = "If the file requested is a directory, it comes here."

	file_list = []
	links_list = []
	about_list = []
	info_list = []
	dir_names_dict = {}
	about_location = os.path.join (dir_location, ".about") #.about file
	info_location = os.path.join (dir_location, ".info") #.info file.
	links_location = os.path.join (dir_location, ".links") #.links file?
	names_location = os.path.join (dir_location, ".names") #.name file 
	cap_location = os.path.join (dir_location, ".cap") #.cap files?

	if os.path.exists(about_location):
		about_file = open (about_location, 'r')
		about_lines = about_file.readlines()
		about_file.close()
		for comment in about_lines:
			comment = string.rstrip(comment)
			file_list.append (gopher_format.get_info_line(comment))
	elif os.path.exists (info_location):
		file_list = file_list + gopher_parse.parsedotinfo(info_location)

	if os.path.exists(links_location):
		links_list = gopher_parse.parsedotlinks(links_location)
	if os.path.exists(names_location):
		dir_names_dict = gopher_parse.parsedotnames(names_location)
	if (not(os.path.exists(cap_location) and os.path.isdir(cap_location))):
		cap_location = None
		
	ls = os.listdir(dir_location)
	for thing in ls:

		if thing[0] == ".":
			continue #skip .files
		else:
			full_thing = os.path.join (dir_location, thing)
			relative_thing = full_thing[len(goph_conn.cwd):]

		desc_name = thing  #The name of this is the filename unless...
		if dir_names_dict.has_key(thing):
			desc_name = dir_names_dict[thing]["Name"]
		elif cap_location:
			cap_file = os.path.join (cap_location, thing)
			if os.path.exists (cap_file) and os.path.isfile (cap_file):
				cap_dict = gopher_parse.parsedotcap(cap_file)
				desc_name = cap_dict.setdefault("Name", thing)

		if os.path.isdir(full_thing):
			file_list.append(gopher_format.get_dir_line(desc_name, relative_thing, "abg.sytes.net", goph_conn.server.port))
		elif os.path.isfile(full_thing):
			if (thing == desc_name): 
				# no one to tell us file type - we'll do it ourselves.
				file_name, file_extension = os.path.splitext(thing)
				if (file_extension in goph_conn.server.options["text_extensions"]):
					file_list.append(gopher_format.get_file_line(desc_name, relative_thing, "abg.sytes.net", goph_conn.server.port))
				else:
					file_list.append(gopher_format.get_binary_line(desc_name, relative_thing, "abg.sytes.net", goph_conn.server.port))			
			else:
				file_list.append(gopher_format.get_file_line(desc_name, relative_thing, "abg.sytes.net", goph_conn.server.port))
		else:
			print 'neither file nor dir'

	if links_list:
		file_list = file_list + links_list
	file_list.append("\r\n.\r\n")    #don't forget the period!
	for line in file_list:
		goph_conn.push (line)

