#!/usr/local/bin/python
"""
    gopher_format.py - a library for formatting gopher-acceptible strings.
    Copyright (C) 2001  Adam Gurno [adam@gurno.com] [GPG key in AUTHORS]

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
"""

# various output formatting routines for pygs and general gopher use.

# GET INFO LINE ###########################################################
def get_info_line (name):
	if name=="": name = " " # fix the i\t... problem.
	return ("i%s\tfoo\t\t70\r\n" % name)

# GET FILE LINE ###########################################################
def get_file_line (name, location, host, port):
	return ("0%s\t%s\t%s\t%s\r\n" % (name, location, host, port))

# GET DIR LINE ###########################################################
def get_dir_line (name, location, host, port):
	return ("1%s\t%s\t%s\t%s\r\n" % (name, location, host, port))

# GET BINARY LINE ###########################################################
def get_binary_line (name, location, host, port):
	return ("9%s\t%s\t%s\t%s\r\n" % (name, location, host, port))
