REM
REM    * * * * * * * * * * * * * * * * * * * * * * * * * * *
REM    *  Grumpy, the most grouchy http server out there!  *
REM    *  Copyright (C) Mateusz Viste 2008                 *
REM    * * * * * * * * * * * * * * * * * * * * * * * * * * *
REM
REM  Written in FreeBASIC v0.20.0 by Mateusz Viste <mateusz@viste-family.net>
REM
REM   ----------------------------------------------------------------------
REM    This program is free software: you can redistribute it and/or modify
REM    it under the terms of the GNU General Public License as published by
REM    the Free Software Foundation, either version 3 of the License, or
REM    (at your option) any later version.
REM
REM    This program is distributed in the hope that it will be useful,
REM    but WITHOUT ANY WARRANTY; without even the implied warranty of
REM    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
REM    GNU General Public License for more details.
REM
REM    You should have received a copy of the GNU General Public License
REM    along with this program.  If not, see <http://www.gnu.org/licenses/>.
REM   ----------------------------------------------------------------------
REM

#INCLUDE ONCE "vbcompat.bi"         ' Required for use of FileExists(), FORMAT() and FileDateTime() functions
#INCLUDE ONCE "crt.bi"              ' Needed by GetSrvTime
#INCLUDE ONCE "base64.bi"           ' Allows to use the EncBase64() function
#INCLUDE ONCE "percencoding.bi"     ' Required for the TranslatePercentEnc function
#INCLUDE ONCE "sortstr.bi"          ' Sorting lib
#INCLUDE ONCE "crt/linux/unistd.bi" ' Required for GetPID()

DECLARE SUB ReturnFile(FileToReturn AS STRING, HeadQuery AS BYTE = 0)
DECLARE SUB Return301(RedirectTo AS STRING, HeadQuery AS BYTE = 0)
DECLARE SUB Return304(ETag AS STRING)
DECLARE SUB Return400(HeadQuery AS BYTE = 0)
DECLARE SUB Return401(HeadQuery AS BYTE = 0, AuthRealm AS STRING)
DECLARE SUB Return403(HeadQuery AS BYTE = 0)
DECLARE SUB Return404(MissingFile AS STRING, HeadQuery AS BYTE = 0)
DECLARE SUB Return500(HeadQuery AS BYTE = 0)
DECLARE SUB Return501(HeadQuery AS BYTE = 0)
DECLARE SUB Return505(HeadQuery AS BYTE = 0)
DECLARE SUB ListDir(DirectoryToList AS STRING, HeadQuery AS BYTE = 0)
DECLARE SUB About()
DECLARE SUB LogLine(TextToLog AS STRING = "")
DECLARE SUB ExecCgi(CgiProgram AS STRING, HeadQuery AS BYTE = 0)
DECLARE SUB SetEnv(EnvString AS STRING)
DECLARE FUNCTION RemoveDoubleSlash(StringToRemove AS STRING) AS STRING
DECLARE FUNCTION ReadCFG(CFGfile AS STRING, CFGField AS STRING) AS STRING
DECLARE FUNCTION CheckForEvasion(JailPath AS STRING, EvadingFile AS STRING) AS BYTE
DECLARE FUNCTION HttpSecurityChecks(Query AS STRING) AS STRING
DECLARE FUNCTION IsDirectory(ElementToCheck AS STRING) AS BYTE
DECLARE FUNCTION CheckForAuth(PathToCheckFor AS STRING) AS STRING
DECLARE FUNCTION LineInput(SocketToListenTo AS INTEGER = 0) AS STRING
DECLARE FUNCTION GetFileSize(FileToCheck AS STRING) AS STRING
DECLARE FUNCTION GetFileDate(FileToCheck AS STRING) AS STRING
DECLARE FUNCTION GetFileDescription(FileToCheck AS STRING, DescrPath AS STRING) AS STRING
DECLARE FUNCTION HtmlizeText(QueryString AS STRING) AS STRING
DECLARE FUNCTION GetRFC1123time(SerializedGmtDate AS DOUBLE) AS STRING
DECLARE FUNCTION NowGMT() AS DOUBLE
DECLARE FUNCTION GetGMT(SerializedLocalDate AS DOUBLE) AS DOUBLE

CONST pVer AS STRING = "0.15"
CONST pDate AS STRING = "2008 - 2009"
CONST homepage AS STRING = "http://www.viste-family.net/mateusz/grumpy/"

CONST CRLF AS STRING = CHR(13) + CHR(10)

' Initializing buffers:
DIM SHARED AS STRING LineBuff, OperationBuff, HostBuff, UserAgentBuff, AcceptBuff, AcceptLanguageBuff,_
              AcceptEncodingBuff, AcceptCharsetBuff, KeepAliveBuff, ConnectionBuff, CookieBuff,_
              RefererBuff, IfModifiedSinceBuff, IfUnmodifiedSinceBuff, AuthorizationBuff, RangeBuff,_
              IfNoneMatchBuff
DIM SHARED AS STRING GetQuery, GetParam1, GetParam2
' Other variables:
DIM SHARED AS BYTE VerboseMode, AllowDirListing, CgiSupport
DIM SHARED AS STRING Token, Value, RootPath, LocalFile, SecurityComment, TempString, VirtualHost, SrvSideParams
DIM SHARED AS INTEGER QoSlimit, LogEntries
DIM SHARED EnvVariables(1 TO 30) AS STRING
DIM SHARED ShortMonths(1 TO 12) AS STRING*3 => {"Jan", "Feb", "Mar", "Apr",_
                                                "May", "Jun", "Jul", "Aug",_
                                                "Sep", "Oct", "Nov", "Dec"}
DIM HeadFlag AS BYTE
DIM TempDouble AS DOUBLE
DIM TempInteger AS INTEGER

VerboseMode = VAL(ReadCFG("/etc/grumpy.cfg", "Verbose"))
AllowDirListing = VAL(ReadCFG("/etc/grumpy.cfg", "AllowDirListing"))
RootPath = ReadCFG("/etc/grumpy.cfg", "RootDir")
QoSlimit = VAL(ReadCFG("/etc/grumpy.cfg", "QoS"))
CgiSupport = VAL(ReadCFG("/etc/grumpy.cfg", "CgiSupport"))
IF RootPath = "" THEN
  RootPath = "/var/www/"
  VerboseMode = 1
  AllowDirListing = 0
  QoSlimit = 0
  CgiSupport = 0
END IF

IF RIGHT(RootPath, 1) <> "/" THEN RootPath += "/"

IF LCASE(COMMAND(1)) = "-h" OR LCASE(COMMAND(1)) = "--help" THEN About()

OPEN CONS FOR INPUT AS #4
OPEN CONS FOR OUTPUT AS #5
IF VerboseMode > 0 THEN
  LogLine()
  TempDouble = NowGMT()
  TempString = ""
  IF LEN(ENVIRON("REMOTE_ADDR")) > 0 THEN TempString = "REMOTE_ADDR=" + ENVIRON("REMOTE_ADDR")
  IF LEN(ENVIRON("REMOTE_HOST")) > 0 THEN TempString = "REMOTE_HOST=" + ENVIRON("REMOTE_HOST") + " " + TempString
  IF LEN(TempString) > 0 THEN TempString = " / " + TRIM(TempString)
  LogLine("---[ " & FORMAT(DAY(TempDouble), "0#") & " " & ShortMonths(MONTH(TempDouble)) & " " & YEAR(TempDouble) & ", " & FORMAT(HOUR(TempDouble), "0#") & ":" & FORMAT(MINUTE(TempDouble), "0#") & ":" & FORMAT(SECOND(TempDouble), "0#") & " (GMT)" & TempString & " ]---")
END IF


#INCLUDE ONCE "gopher.bi"
IF LCASE(COMMAND(1)) = "--gopher" THEN
  GopherProcess()
  END
END IF


DO
  LineBuff = LineInput(4)
  IF VerboseMode = 2 THEN LogLine(LineBuff)

  REM * Perform sanity checks on the request...
  SecurityComment = HttpSecurityChecks(LineBuff)
  IF SecurityComment <> "" THEN
    IF MID(SecurityComment, 1, 1) = "!" THEN
        IF VerboseMode > 0 THEN
          LogLine("***** SECURITY CHECKS *****")
          LogLine(" The security module has detected a problem with the following request:")
          LogLine(" """ + LineBuff + """")
          LogLine(" The request has been processed anyway. You will find a short explanation below.")
          LogLine(" " + CHR(34) + MID(SecurityComment, 2) + CHR(34))
          LogLine("***************************")
        END IF
      ELSE
        IF VerboseMode > 0 THEN
          LogLine("***** SECURITY CHECKS *****")
          LogLine(" The security module has detected a problem with the following request:")
          LogLine(" """ + LineBuff + """")
          LogLine(" The request has been killed. You will find a short explanation below.")
          LogLine(" " + CHR(34) + SecurityComment + CHR(34))
          LogLine("***************************")
        END IF
        CLOSE #4
        CLOSE #5
        END
    END IF
  END IF
  REM * Sanity checks done

  Token = UCASE(LEFT(LineBuff, INSTR(LineBuff, " ") - 1))
  Value = TRIM(MID(LineBuff, INSTR(LineBuff, " ") + 1))
  SELECT CASE Token
    CASE "GET", "HEAD", "POST", "PUT", "DELETE", "CONNECT", "TRACE", "OPTIONS"
      OperationBuff = LineBuff
      GetQuery = TRIM(MID(OperationBuff, 1, INSTR(OperationBuff, " ") - 1))
      GetParam1 = TRIM(MID(MID(OperationBuff, LEN(GetQuery) + 2), 1, INSTR(MID(OperationBuff, LEN(GetQuery) + 2), " ") - 1))
      GetParam2 = TRIM(MID(OperationBuff, LEN(GetQuery) + 3 + LEN(GetParam1)))
    CASE "HOST:"
      HostBuff = Value
      IF INSTR(HostBuff, ":") > 0 THEN HostBuff = MID(HostBuff, 1, INSTR(HostBuff, ":") - 1)
    CASE "USER-AGENT:"
      UserAgentBuff = Value
    CASE "ACCEPT:"
      AcceptBuff = Value
    CASE "ACCEPT-LANGUAGE:"
      AcceptLanguageBuff = Value
    CASE "ACCEPT-ENCODING:"
      AcceptEncodingBuff = Value
    CASE "ACCEPT-CHARSET:"
      AcceptCharsetBuff = Value
    CASE "RANGE:"
      RangeBuff = Value
    CASE "KEEP-ALIVE:"
      KeepAliveBuff = Value
    CASE "CONNECTION:"
      ConnectionBuff = Value
    CASE "REFERER:"
      RefererBuff = Value
    CASE "COOKIE:"
      CookieBuff = Value
    CASE "IF-MODIFIED-SINCE:"
      IfModifiedSinceBuff = Value
    CASE "IF-UNMODIFIED-SINCE:"
      IfUnmodifiedSinceBuff = Value
    CASE "IF-NONE-MATCH:"
      IfNoneMatchBuff = Value
    CASE "AUTHORIZATION:"
      AuthorizationBuff = Value
  END SELECT
LOOP UNTIL LEN(LineBuff) = 0 OR (LEN(GetParam1) > 0 AND LEN(GetParam2) = 0)

REM * Check for virtual hosts
VirtualHost = ReadCFG("/etc/grumpy.cfg", "vhost:" + TRIM(HostBuff))
IF LEN(VirtualHost) > 0 THEN RootPath = VirtualHost
IF RIGHT(RootPath, 1) <> "/" THEN RootPath += "/"

REM * Process the request...

TempInteger = INSTR(GetParam1, "?")                 '
IF TempInteger > 0 THEN                             '
    SrvSideParams = MID(GetParam1, TempInteger + 1) ' Check for server-side parameters
    GetParam1 = MID(GetParam1, 1, TempInteger - 1)  '
  ELSE                                              '
    SrvSideParams = ""                              '
END IF                                              '

GetQuery = TranslatePercentEnc(GetQuery)            '
GetParam1 = TranslatePercentEnc(GetParam1)          ' Decode % encoding before further treatement
GetParam2 = TranslatePercentEnc(GetParam2)          '


IF VerboseMode > 0 THEN
  TempString = "Query=" + GetQuery + " Param1=" + GetParam1
'  IF LEN(ENVIRON("REMOTE_ADDR")) > 0 THEN TempString = "Remote_Addr=" + ENVIRON("REMOTE_ADDR") + " " + TempString
'  IF LEN(ENVIRON("REMOTE_HOST")) > 0 THEN TempString = "Remote_Host=" + ENVIRON("REMOTE_HOST") + " " + TempString
  IF LEN(SrvSideParams) > 0 THEN TempString += "?" + SrvSideParams
  IF LEN(GetParam2) > 0 THEN TempString += " Param2=" + GetParam2
  IF LEN(VirtualHost) > 0 THEN TempString += " [vhost: " + HostBuff + "]"
  LogLine(TempString)
END IF

SELECT CASE GetQuery
  CASE "GET", "HEAD"
    IF GetQuery = "HEAD" THEN HeadFlag = 1 ELSE HeadFlag = 0
    SELECT CASE GetParam2
      CASE "HTTP/1.0", "HTTP/1.1"
        LocalFile = RemoveDoubleSlash(RootPath + "/" + GetParam1)
        IF CheckForEvasion(RootPath, LocalFile) = 1 THEN
            Return403(HeadFlag)
          ELSE
            IF LEN(HostBuff) > 0 OR UCASE(GetParam2) = "HTTP/1.0" THEN
                TempString = ReadCFG("/etc/grumpy.cfg", "RedirectDomain:" + HostBuff)
                IF LEN(TempString) > 0 THEN
                    IF RIGHT(TempString, 1) = "/" THEN TempString = LEFT(TempString, LEN(TempString) - 1)
                    IF NOT UCASE(LEFT(TempString, 7)) = "HTTP://" THEN TempString = "http://" + TempString
                    Return301(TempString + GetParam1, HeadFlag)
                  ELSE
                    IF IsDirectory(LocalFile) = 1 THEN
                        IF RIGHT(LocalFile, 1) = "/" THEN
                            TempString = CheckForAuth(LocalFile)
                            IF TempString <> "" THEN
                                Return401(HeadFlag, TempString)
                              ELSE
                                IF FileExists(LocalFile + "index.htm") <> 0 THEN
                                    LocalFile += "index.htm"
                                    ReturnFile(LocalFile, HeadFlag)
                                  ELSEIF FileExists(LocalFile + "index.html") <> 0 THEN
                                    LocalFile += "index.html"
                                    ReturnFile(LocalFile, HeadFlag)
                                  ELSEIF AllowDirListing = 1 THEN
                                    ListDir(LocalFile, HeadFlag)
                                  ELSE
                                    Return403(HeadFlag)
                                END IF
                            END IF
                          ELSE
                            Return301(GetParam1 + "/", HeadFlag)
                        END IF
                      ELSE
                        TempString = CheckForAuth(LocalFile)
                        IF TempString <> "" THEN
                            Return401(HeadFlag, TempString)
                          ELSE
                            IF FileExists(LocalFile) <> 0 AND RIGHT(LocalFile, 13) <> "/.grumpy.auth" THEN
                                IF (UCASE(RIGHT(LocalFile, 4)) = ".CGI" AND CgiSupport = 2) OR (MID(LocalFile, 1, LEN(RootPath) + 8) = RootPath + "cgi-bin/" AND UCASE(RIGHT(LocalFile, 4)) = ".CGI" AND CgiSupport > 0) THEN
                                    ExecCgi(LocalFile, HeadFlag)
                                  ELSE
                                    ReturnFile(LocalFile, HeadFlag)
                                END IF
                              ELSE
                                Return404(GetParam1, HeadFlag)
                            END IF
                        END IF
                    END IF
                END IF
              ELSE
                Return400(HeadFlag)
            END IF
        END IF
      CASE ELSE
        Return505(HeadFlag)
    END SELECT
  CASE "POST", "PUT", "DELETE", "CONNECT", "TRACE", "OPTIONS"
    Return501()
  CASE ELSE
    Return400()
END SELECT

CLOSE #4
CLOSE #5
END


REM ***  END OF THE MAIN PROGRAM  ***


SUB ReturnFile(FileToReturn AS STRING, HeadFlag AS BYTE = 0)
  DIM AS INTEGER x, FileLength, QoScounter, FirstByte, LastByte, QoSdelay, SleepTime
  DIM AS STRING*1 ByteBuff
  DIM AS STRING*1024 KByteBuff
  DIM AS DOUBLE QoStimer, TempDouble
  DIM AS STRING TmpVar, TimeStamp, ETag

  TempDouble = FileDateTime(FileToReturn)
  TimeStamp = "" & YEAR(TempDouble) & "-" & MONTH(TempDouble) & "-" & DAY(TempDouble) & "-" & HOUR(TempDouble) & "-" & MINUTE(TempDouble) & "-" & SECOND(TempDouble)
  OPEN FileToReturn FOR BINARY AS #20
  ETag = CHR(34) & TimeStamp & "-" & LOF(20) & CHR(34)

  IF IfNoneMatchBuff = ETag THEN
      Return304(ETag)
    ELSE
      IF LEN(RangeBuff) > 0 THEN
        TmpVar = MID(RangeBuff, INSTR(RangeBuff, "=") + 1)
        FirstByte = VAL(MID(TmpVar, 1, INSTR(TmpVar, "-") - 1)) + 1
        TmpVar = MID(TmpVar, INSTR(TmpVar, "-") + 1)
        x = 0
        DO: x += 1
        LOOP UNTIL MID(TmpVar, x, 1) = "/" OR MID(TmpVar, x, 1) = "," OR x >= LEN(TmpVar)
        IF LEN(MID(TmpVar, 1, x)) > 0 THEN
            LastByte = VAL(MID(TmpVar, 1, x)) + 1
          ELSE
            LastByte = LOF(20)
        END IF
        IF LastByte < FirstByte THEN LastByte = LOF(20)
      END IF

      IF LEN(RangeBuff) = 0 THEN
          IF VerboseMode > 0 THEN LogLine("Response: 200 OK (" + FileToReturn + ")")
          PRINT #5, GetParam2; " 200 OK"; CRLF;
        ELSE
          IF VerboseMode > 0 THEN LogLine("Response: 206 Partial Content (" + FileToReturn + " " + "[" & FirstByte & "-" & LastByte & "])")
          PRINT #5, GetParam2; " 206 Partial Content"; CRLF;
      END IF

      IF LastByte = 0 THEN LastByte = LOF(20)
      IF FirstByte = 0 THEN FirstByte = 1

      PRINT #5, "Date: "; GetRFC1123time(NowGMT()); CRLF;
      PRINT #5, "Server: Grumpy/"; pVer; CRLF;
      PRINT #5, "Connection: close"; CRLF;
      PRINT #5, "Allow: GET, HEAD"; CRLF;
      PRINT #5, "Accept-Ranges: bytes"; CRLF;
      PRINT #5, "Content-Length: " & (LastByte - FirstByte + 1); CRLF;
      IF LEN(RangeBuff) > 0 THEN PRINT #5, "Content-Range: bytes " & FirstByte - 1 & "-" & LastByte - 1 & "/" & LOF(20); CRLF;
      PRINT #5, "ETag: "; ETag; CRLF;
      'PRINT #5, "Content-Type: text/html; charset=UTF-8"; CRLF;
      PRINT #5, CRLF;

      IF HeadFlag = 0 THEN   ' Don't return the file content for HEAD queries
        x = FirstByte
        QoScounter = 0
        QoSdelay = 0
        QoStimer = TIMER
        WHILE LastByte - x > 1024        '
           x += 1024                     ' Caching the file
           GET #20, x - 1024, KByteBuff  ' into 1K blocks
           PRINT #5, KByteBuff;          '
           IF QoSlimit > 0 THEN     ' Apply QoS rule, if any
             QoScounter += 1
            'IF ABS(TIMER - QoStimer) > 1 THEN QoStimer = TIMER: QoScounter = 0: QoSdelay = 0
             IF QoScounter >= QoSlimit THEN
               SleepTime = 1000 * (1 - ABS(TIMER - QoSTimer))
               IF SleepTime > 0 THEN SLEEP SleepTime, 1
               IF SleepTime > 100 AND QoSdelay = 0 THEN QoSdelay = 1
               SELECT CASE SleepTime
                 CASE IS > 750
                   QoSdelay *= 3
                 CASE IS > 500
                   QoSdelay *= 1.7
                 CASE IS > 250
                   QoSdelay *= 1.1
                 CASE IS > 200
                   QoSdelay += 1
                 CASE IS < 150
                  QoSdelay -= 1
               END SELECT
               IF QoSdelay < 0 THEN QoSdelay = 0
               QoScounter = 0
               QoStimer = TIMER
             END IF
             IF QoSdelay > 0 THEN SLEEP QoSdelay, 1
           END IF
        WEND
        FOR x = x TO LastByte
          GET #20, x, ByteBuff
          PRINT #5, ByteBuff;
        NEXT x
      END IF
  END IF
  CLOSE #20
END SUB


SUB Return301(RedirectTo AS STRING, HeadFlag AS BYTE = 0)
  IF VerboseMode > 0 THEN LogLine("Response: 301 (" + RedirectTo + ")")
  PRINT #5, GetParam2; " 301"; CRLF;
  PRINT #5, "Date: "; GetRFC1123time(NowGMT()); CRLF;
  PRINT #5, "Server: Grumpy/"; pVer; CRLF;
  PRINT #5, "Location: "; RedirectTo; CRLF;
  PRINT #5, "Connection: close"; CRLF;
  PRINT #5, "Allow: GET, HEAD"; CRLF;
  PRINT #5, "Accept-Ranges: bytes"; CRLF;
  'PRINT #5, "Content-Length: 8700"; CRLF;
  PRINT #5, "Content-Type: text/html; charset=UTF-8"; CRLF;
  PRINT #5, CRLF;
  IF HeadFlag = 0 THEN PRINT #5, "<html><head><title>301</title></head><body><h1>301 - Moved Permanently</h1><br>The document has been moved <a href="""; RedirectTo; """>here</a>.</body></html>"; CRLF;
END SUB


SUB Return304(ETag AS STRING)
  IF VerboseMode > 0 THEN LogLine("Response: 304 Not Modified (ETag: " + Etag + ")")
  PRINT #5, GetParam2; " 304 Not Modified"; CRLF;
  PRINT #5, "Date: "; GetRFC1123time(NowGMT()); CRLF;
  PRINT #5, "Server: Grumpy/"; pVer; CRLF;
  PRINT #5, "Connection: close"; CRLF;
  PRINT #5, "ETag: "; ETag; CRLF;
  PRINT #5, "Allow: GET, HEAD"; CRLF;
  PRINT #5, "Accept-Ranges: bytes"; CRLF;
  'PRINT #5, "Content-Length: 8700"; CRLF;
  'PRINT #5, "Content-Type: text/html; charset=UTF-8"; CRLF;
  PRINT #5, CRLF;
END SUB


SUB Return400(HeadFlag AS BYTE = 0)
  IF VerboseMode > 0 THEN LogLine("Response: 400 Bad request")
  PRINT #5, GetParam2; " 400 Bad request"; CRLF;
  PRINT #5, "Date: "; GetRFC1123time(NowGMT()); CRLF;
  PRINT #5, "Server: Grumpy/"; pVer; CRLF;
  PRINT #5, "Connection: close"; CRLF;
  PRINT #5, "Allow: GET, HEAD"; CRLF;
  PRINT #5, "Accept-Ranges: bytes"; CRLF;
  'PRINT #5, "Content-Length: 8700"; CRLF;
  PRINT #5, "Content-Type: text/html; charset=UTF-8"; CRLF;
  PRINT #5, CRLF;
  IF HeadFlag = 0 THEN
    IF FileExists(RootPath + ".errors/400.htm") <> 0 THEN
        OPEN RootPath + ".errors/400.htm" FOR INPUT AS #20
        WHILE NOT EOF(20)
          LINE INPUT #20, LineBuff
          PRINT #5, LineBuff; CRLF;
        WEND
        CLOSE #20
      ELSE
        PRINT #5, "<html><head><title>400</title></head><body><h1>400 - Bad request</h1></body></html>"; CRLF;
    END IF
  END IF
END SUB


SUB Return401(HeadFlag AS BYTE = 0, AuthRealm AS STRING)
  IF VerboseMode > 0 THEN LogLine("Response: 401 Unauthorized")
  PRINT #5, GetParam2; " 401 Unauthorized"; CRLF;
  PRINT #5, "Date: "; GetRFC1123time(NowGMT()); CRLF;
  PRINT #5, "Server: Grumpy/"; pVer; CRLF;
  PRINT #5, "Connection: close"; CRLF;
  PRINT #5, "Allow: GET, HEAD"; CRLF;
  PRINT #5, "Accept-Ranges: bytes"; CRLF;
  'PRINT #5, "Content-Length: 8700"; CRLF;
  PRINT #5, "Content-Type: text/html; charset=UTF-8"; CRLF;
  PRINT #5, "WWW-Authenticate: Basic realm="; CHR(34); AuthRealm; CHR(34); CRLF;
  PRINT #5, CRLF;
  IF HeadFlag = 0 THEN
    IF FileExists(RootPath + ".errors/401.htm") <> 0 THEN
        OPEN RootPath + ".errors/401.htm" FOR INPUT AS #20
        WHILE NOT EOF(20)
          LINE INPUT #20, LineBuff
          PRINT #5, LineBuff; CRLF;
        WEND
        CLOSE #20
      ELSE
        PRINT #5, "<html><head><title>401</title></head><body><h1>401 - Unauthorized</h1></body></html>"; CRLF;
    END IF
  END IF
END SUB


SUB Return403(HeadFlag AS BYTE = 0)
  IF VerboseMode > 0 THEN LogLine("Response: 403 Forbidden")
  PRINT #5, GetParam2; " 403 Forbidden"; CRLF;
  PRINT #5, "Date: "; GetRFC1123time(NowGMT()); CRLF;
  PRINT #5, "Server: Grumpy/"; pVer; CRLF;
  PRINT #5, "Connection: close"; CRLF;
  PRINT #5, "Allow: GET, HEAD"; CRLF;
  PRINT #5, "Accept-Ranges: bytes"; CRLF;
  'PRINT #5, "Content-Length: 8700"; CRLF;
  PRINT #5, "Content-Type: text/html; charset=UTF-8"; CRLF;
  PRINT #5, CRLF;
  IF HeadFlag = 0 THEN
    IF FileExists(RootPath + ".errors/403.htm") <> 0 THEN
        OPEN RootPath + ".errors/403.htm" FOR INPUT AS #20
        WHILE NOT EOF(20)
          LINE INPUT #20, LineBuff
          PRINT #5, LineBuff; CRLF;
        WEND
        CLOSE #20
      ELSE
        PRINT #5, "<html><head><title>403</title></head><body><h1>403 - Forbidden</h1></body></html>"; CRLF;
    END IF
  END IF
END SUB


SUB Return404(MissingFile AS STRING, HeadFlag AS BYTE = 0)
  DIM AS STRING LineBuff
  IF VerboseMode > 0 THEN LogLine("Response: 404 Not found (" + MissingFile + ")")
  PRINT #5, GetParam2; " 404 Not found"; CRLF;
  PRINT #5, "Date: "; GetRFC1123time(NowGMT()); CRLF;
  PRINT #5, "Server: Grumpy/"; pVer; CRLF;
  PRINT #5, "Connection: close"; CRLF;
  PRINT #5, "Allow: GET, HEAD"; CRLF;
  PRINT #5, "Accept-Ranges: bytes"; CRLF;
  'PRINT #5, "Content-Length: 1030"; CRLF;
  PRINT #5, "Content-Type: text/html;charset=utf-8"; CRLF;
  PRINT #5, CRLF;
  IF HeadFlag = 0 THEN
    IF FileExists(RootPath + ".errors/404.htm") <> 0 THEN
        OPEN RootPath + ".errors/404.htm" FOR INPUT AS #20
        WHILE NOT EOF(20)
          LINE INPUT #20, LineBuff
          PRINT #5, LineBuff; CRLF;
        WEND
        CLOSE #20
      ELSE
        PRINT #5, "<html><head><title>404</title></head><body><h1>404 - Not found</h1></body></html>"; CRLF;
    END IF
  END IF
END SUB


SUB Return500(HeadFlag AS BYTE = 0)
  IF VerboseMode > 0 THEN LogLine("Response: 500 Internal server error")
  PRINT #5, GetParam2; " 500 Internal server error"; CRLF;
  PRINT #5, "Date: "; GetRFC1123time(NowGMT()); CRLF;
  PRINT #5, "Server: Grumpy/"; pVer; CRLF;
  PRINT #5, "Connection: close"; CRLF;
  PRINT #5, "Allow: GET, HEAD"; CRLF;
  PRINT #5, "Accept-Ranges: bytes"; CRLF;
  'PRINT #5, "Content-Length: 8700"; CRLF;
  PRINT #5, "Content-Type: text/html; charset=UTF-8"; CRLF;
  PRINT #5, CRLF;
  IF HeadFlag = 0 THEN PRINT #5, "<html><head><title>500</title></head><body><h1>500 - Internal server error</h1></body></html>"; CRLF;
END SUB


SUB Return501(HeadFlag AS BYTE = 0)
  IF VerboseMode > 0 THEN LogLine("Response: 501 Not implemented")
  PRINT #5, GetParam2; " 501 Not implemented"; CRLF;
  PRINT #5, "Date: "; GetRFC1123time(NowGMT()); CRLF;
  PRINT #5, "Server: Grumpy/"; pVer; CRLF;
  PRINT #5, "Connection: close"; CRLF;
  PRINT #5, "Allow: GET, HEAD"; CRLF;
  PRINT #5, "Accept-Ranges: bytes"; CRLF;
  'PRINT #5, "Content-Length: 8700"; CRLF;
  PRINT #5, "Content-Type: text/html; charset=UTF-8"; CRLF;
  PRINT #5, CRLF;
  IF HeadFlag = 0 THEN PRINT #5, "<html><head><title>501</title></head><body><h1>501 - Not implemented</h1></body></html>"; CRLF;
END SUB


SUB Return505(HeadFlag AS BYTE = 0)
  IF VerboseMode > 0 THEN LogLine("Response: 505 HTTP version not supported")
  PRINT #5, "HTTP/1.1 505 HTTP version not supported"; CRLF;
  PRINT #5, "Date: "; GetRFC1123time(NowGMT()); CRLF;
  PRINT #5, "Server: Grumpy/"; pVer; CRLF;
  PRINT #5, "Connection: close"; CRLF;
  PRINT #5, "Allow: GET, HEAD"; CRLF;
  PRINT #5, "Accept-Ranges: bytes"; CRLF;
  'PRINT #5, "Content-Length: 8700"; CRLF;
  PRINT #5, "Content-Type: text/html; charset=UTF-8"; CRLF;
  PRINT #5, CRLF;
  IF HeadFlag = 0 THEN PRINT #5, "<html><head><title>505</title></head><body><h1>505 - HTTP version not supported</h1></body></html>"; CRLF;
END SUB


SUB ListDir(DirectoryToList AS STRING, HeadFlag AS BYTE = 0)
  DIM AS STRING FileName, ListTitle, EntryColor, EntrySize, EntryDescription
  DIM AS UINTEGER FileAttrib
  DIM AS INTEGER DirIndex, x, y, SmallestEntry
  DIM AS DOUBLE StartTime
  DIM DirList(1 TO 20000) AS STRING
  IF VerboseMode > 0 THEN LogLine("Response: 200 OK (list directory """ + DirectoryToList + """)")
  ListTitle = MID(DirectoryToList, LEN(RootPath))
  StartTime = TIMER
  PRINT #5, GetParam2; " 200 OK"; CRLF;
  PRINT #5, "Date: "; GetRFC1123time(NowGMT()); CRLF;
  PRINT #5, "Server: Grumpy/"; pVer; CRLF;
  PRINT #5, "Connection: close"; CRLF;
  PRINT #5, "Allow: GET, HEAD"; CRLF;
  PRINT #5, "Accept-Ranges: bytes"; CRLF;
  'PRINT #5, "Content-Length: 8700"; CRLF;
  PRINT #5, "Content-Type: text/html; charset=UTF-8"; CRLF;
  PRINT #5, CRLF;
  IF HeadFlag = 0 THEN
    PRINT #5, "<!DOCTYPE HTML PUBLIC ""-//W3C//DTD HTML 4.01 Transitional//EN"" ""http://www.w3.org/TR/html4/loose.dtd"">"
    PRINT #5, "<html>"
    PRINT #5, "  <head>"
    PRINT #5, "    <title>Index of "; ListTitle; "</title>"
    PRINT #5, "    <meta name=""Generator"" content=""Grumpy web server v"; pVer; """>"
    PRINT #5, "    <meta http-equiv=""Content-Type"" content=""text/html; charset=utf-8"">"
    PRINT #5, "  </head>"
    PRINT #5, "  <body bgcolor=""#DADAFF"">"
    PRINT #5, "    <br>"
    PRINT #5, "    <table cellpadding=""0"" cellspacing=""0"" width=""100%"" bgcolor=""#EAEAFF"" style=""border: 1px solid #000000"">"
    PRINT #5, "      <tr>"
    PRINT #5, "        <td>"
    PRINT #5, "          <b><big>&nbsp;http://"; HostBuff; ListTitle; "</big></b><br>&nbsp;";
    EntryDescription = GetFileDescription(".", DirectoryToList)
    IF LEN(EntryDescription) > 0 THEN PRINT #5, "<i>"; HtmlizeText(EntryDescription); "</i>" ELSE PRINT #5, ""
    PRINT #5, "        </td>"
    PRINT #5, "      </tr>"
    PRINT #5, "      <tr>"
    PRINT #5, "        <td>"
    PRINT #5, "          <table cellpadding=""2"" cellspacing=""0"" width=""100%"" border=""0"">"

    FileName = DIR(DirectoryToList + "*", &h37, FileAttrib)
    DirIndex = 0
    WHILE FileName <> "" AND DirIndex < 20000
      IF FileName <> "." AND (FileName <> ".." OR DirectoryToList <> RootPath) AND (LEFT(FileName, 1) <> "." OR FileName = "..") AND Filename <> "descript.ion" THEN
        DirIndex += 1
        DirList(DirIndex) = FileName
        IF FileAttrib AND &h10 THEN DirList(DirIndex) = CHR(9) + DirList(DirIndex)
      END IF
      FileName = DIR(FileAttrib)
    WEND

  REM  ***  Here I am sorting the directory's entries ***
    IF DirIndex > 1 THEN strQsort(DirList(), DirIndex)  ' (included in sortstr.bi)

    ' Now, we will display all entries
    EntryColor = """#C2C2EF"""
    PRINT #5, "            <tr>"
    PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;<b>Name</b></td>"
    PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;<b>Size</b></td>"
    PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;<b>Date / Time</b></td>"
    PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;<b>Description</b></td>"
    PRINT #5, "            </tr>"
    IF LEN(FileName) > 0 THEN
      PRINT #5, "            <tr>"
      PRINT #5, "              <td bgcolor=""#D00000"" colspan=""4"" align=""center""><font color=""#FFFF20""><b>Warning: Too much entries, only 20'000 are displayed!</b></font></td>"
      PRINT #5, "            </tr>"
    END IF

    IF DirIndex > 0 THEN
        FOR x = 1 TO DirIndex
          IF x MOD 2 = 0 THEN EntryColor = """#E1E1FA""" ELSE EntryColor = """#EAEAFF"""
          IF MID(DirList(x), 1, 1) = CHR(9) THEN
              DirList(x) = MID(DirList(x), 2)
              PRINT #5, "            <tr>"
              PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;<a href="""; TranslatePercentEnc(DirList(x), 1); "/"">"; HtmlizeText(DirList(x)); "</a></td>"
              PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;[DIR]</td>"
              PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;"; GetFileDate(DirectoryToList + DirList(x)); "</td>"
              PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;"; HtmlizeText(GetFileDescription(DirList(x), DirectoryToList)); "</td>"
              PRINT #5, "            </tr>"
            ELSE
              PRINT #5, "            <tr>"
              PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;<a href="""; TranslatePercentEnc(DirList(x), 1); """ target=""_blank"">"; HtmlizeText(DirList(x)); "</a></td>"
              PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;"; GetFileSize(DirectoryToList + DirList(x)); "</td>"
              PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;"; GetFileDate(DirectoryToList + DirList(x)); "</td>"
              PRINT #5, "              <td bgcolor="; EntryColor; ">&nbsp;"; HtmlizeText(GetFileDescription(DirList(x), DirectoryToList)); "</td>"
              PRINT #5, "            </tr>"
          END IF
        NEXT x
      ELSE
        PRINT #5, "            <tr>"
        PRINT #5, "              <td bgcolor=""#E1E1FA"" colspan=""4"" align=""center""><b>This directory is empty.</b></td>"
        PRINT #5, "            </tr>"
    END IF

    PRINT #5, "          </table>"
    PRINT #5, "        </td>"
    PRINT #5, "      </tr>"
    PRINT #5, "    </table>"
    PRINT #5, "    <table width=""100%"" border=""0"" cellpadding=""0"">"
    PRINT #5, "      <tr>"
    PRINT #5, "        <td align=""left"" style=""color:#404040;""><small><small>Page generated in " & FORMAT(TIMER - StartTime, "#0.000") & "s</small></small></td>"
    PRINT #5, "        <td align=""right"" style=""color:#404040;""><small><small><a href="; homepage; " style=""color: #404040; text-decoration: none;"">Grumpy web server v"; pVer; " Copyright &copy; Mateusz Viste "; pDate; "</a></small></small></td>"
    PRINT #5, "      </tr>"
    PRINT #5, "    </table>"
    PRINT #5, "  </body>"
    PRINT #5, "</html>"
  END IF
END SUB


FUNCTION RemoveDoubleSlash(StringToCheck AS STRING) AS STRING
  DIM AS STRING Wynik
  DIM AS INTEGER x
  Wynik = StringToCheck
  DO
    x = INSTR(Wynik, "//")
    IF x > 0 THEN Wynik = MID(Wynik, 1, x) + MID(Wynik, x + 2)
  LOOP UNTIL INSTR(Wynik, "//") = 0
  RETURN Wynik
END FUNCTION


FUNCTION ReadCFG(CFGfile AS STRING, CFGField AS STRING) AS STRING
 STATIC CfgTable(1 TO 2, 0 TO 255) AS STRING
 DIM AS STRING CfgReturnString, CfgTmpBuffer
 DIM AS INTEGER Counter

 IF CfgTable(1, 0) <> "init ok" THEN
   DIM AS INTEGER CfgFileHandler, CfgColonPos, Counter
   CfgFileHandler = FREEFILE
   CfgReturnString = ""
   Counter = 0
   CfgTable(1, 0) = "init ok"
   IF DIR(CFGfile) <> "" THEN
      OPEN CFGfile FOR INPUT AS #CfgFileHandler
      DO
         Counter += 1
         LINE INPUT #CfgFileHandler, CfgTmpBuffer
         IF MID(TRIM(CfgTmpBuffer), 1, 1) <> "#" THEN
           CfgColonPos = INSTR(CfgTmpBuffer, "=")
           CfgTable(1, Counter) = TRIM(MID(CfgTmpBuffer, 1, CfgColonPos - 1))
           CfgTable(2, Counter) = TRIM(MID(CfgTmpBuffer, CfgColonPos + 1))
         END IF
      LOOP UNTIL EOF(CfgFileHandler) OR Counter = 255
      CLOSE #CfgFileHandler
   END IF
   CfgTable(2, 0) = STR(Counter)
 END IF

 Counter = 0
 DO
   Counter += 1
   IF UCASE(CfgTable(1, Counter)) = UCASE(CFGField) THEN CfgReturnString = CfgTable(2, Counter)
 LOOP UNTIL CfgReturnString <> "" OR Counter >= VAL(CfgTable(2, 0))

 RETURN CfgReturnString
END FUNCTION


FUNCTION CheckForEvasion(JailPath AS STRING, EvadingFile AS STRING) AS BYTE
  DIM AS BYTE Wynik
  IF INSTR(EvadingFile, "..") > 0 THEN Wynik = 1 ELSE Wynik = 0
  RETURN Wynik
END FUNCTION


FUNCTION IsDirectory(ElementToCheck AS STRING) AS BYTE
  DIM AS BYTE Wynik
  DIM AS UINTEGER GetAttribs
  DIM AS STRING TempString
  TempString = DIR(ElementToCheck, &h37, GetAttribs)
  IF GetAttribs AND &h10 THEN Wynik = 1 ELSE Wynik = 0
  Return Wynik
END FUNCTION


FUNCTION GetRFC1123time(SerializedGmtDate AS DOUBLE) AS STRING
  REM  Eg: "Sun, 06 Nov 1994 08:49:37 GMT"
  DIM ShortWeekday(1 TO 7) AS STRING => {"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"}
  DIM Wynik AS STRING
  Wynik = ShortWeekday(WEEKDAY(SerializedGmtDate, 2)) & ", " & FORMAT(DAY(SerializedGmtDate), "0#") & " " & ShortMonths(MONTH(SerializedGmtDate)) & " " & YEAR(SerializedGmtDate) & " " & FORMAT(HOUR(SerializedGmtDate), "0#") & ":" & FORMAT(MINUTE(SerializedGmtDate), "0#") & ":" & FORMAT(SECOND(SerializedGmtDate), "0#") & " GMT"
  RETURN Wynik
END FUNCTION


FUNCTION NowGMT() AS DOUBLE
  DIM AS DOUBLE Wynik
  DIM AS INTEGER res, YearGMT, MonthGMT, DayGMT, HourGMT, MinuteGMT, SecondGMT
  DIM AS STRING timestr
  DIM AS time_t rawtime
  DIM AS tm Ptr timeptr
  time_(@rawtime)
  timeptr=gmtime(@rawtime)
  timestr=Space(128)
'  res=strftime(Strptr(timestr),128,"%a, %d %b %Y %H:%M:%S GMT",timeptr)
  res = strftime(Strptr(timestr),128,"%Y",timeptr)
  YearGMT = VAL(LEFT(timestr, res))
  res = strftime(Strptr(timestr),128,"%m",timeptr)
  MonthGMT = VAL(LEFT(timestr, res))
  res = strftime(Strptr(timestr),128,"%d",timeptr)
  DayGMT = VAL(LEFT(timestr, res))
  res = strftime(Strptr(timestr),128,"%H",timeptr)
  HourGMT = VAL(LEFT(timestr, res))
  res = strftime(Strptr(timestr),128,"%M",timeptr)
  MinuteGMT = VAL(LEFT(timestr, res))
  res = strftime(Strptr(timestr),128,"%S",timeptr)
  SecondGMT = VAL(LEFT(timestr, res))
  Wynik = DATESERIAL(YearGMT, MonthGMT, DayGMT) + TIMESERIAL(HourGMT, MinuteGMT, SecondGMT)
  RETURN Wynik
END FUNCTION


FUNCTION GetGMT(SerializedLocalDate AS DOUBLE) AS DOUBLE
  DIM AS DOUBLE DiffGMT, Wynik
  DiffGMT = NowGMT() - NOW
  Wynik = SerializedLocalDate + DiffGMT
  RETURN Wynik
END FUNCTION


FUNCTION HttpSecurityChecks(Query AS STRING) AS STRING
  REM  This function performs various sanity checks on the given query.
  REM  It returns an empty string if checks are Ok. Otherwise, a string
  REM  containing a human description of the problem will be returned.
  DIM AS STRING Wynik
  DIM AS INTEGER x, WarnOnly
  IF UCASE(MID(Query, 1, 7)) = "REFERER" THEN WarnOnly = 1
  IF INSTR(UCASE(Query), "%2E") > 0 THEN Wynik = "Evasion attempt using twice-encoded '.' character (%2E)."
  IF INSTR(LCASE(Query), "%1u") > 0 THEN Wynik = "Evasion attempt using %1u encoding of the '.' character. Some very old versions of IIS web server understand %1u as '.' character."
  IF INSTR(LCASE(Query), "%u") > 0 THEN Wynik = "The request contains a %u encoding, which is a specific (not standard) Microsoft format used to encode wide characters. This encoding may be used by an attacker to trick systems based on character string recognition."
  IF INSTR(TranslatePercentEnc(Query), "%") > 0 THEN Wynik = "A specific (not supported) %-encoded character has been found, Grumpy doesn't know how to decode it, therefore it could lead to some evasion attempts."
  IF LEN(Query) > 4096 THEN Wynik = "Possible buffer overflow. The request is longer than 4096 bytes. It may be an attempt to insert fraudulent executable code."
  REM Check for non-ASCII characters
  FOR x = 0 TO LEN(Query) - 1
    IF Query[x] > 127 THEN Wynik = "The HTTP request does not contain only 7-bit ASCII characters (the only characters expected in this type of use). Some attackers seek to exploit implementation flaws in certain browsers and web servers by creating specially-crafted HTTP messages to enable executing arbitrary code on the targeted host."
  NEXT x
  REM Check for control characters
  FOR x = 0 TO LEN(Query) - 1
    IF Query[x] < 32 AND Query[x] <> 10 AND Query[x] <> 13 THEN Wynik = "The HTTP request contains some suspect control characters (less than #32 and other than #10 and #13). Some attackers seek to exploit implementation flaws in certain browsers and web servers by creating specially-crafted HTTP messages to enable executing arbitrary code on the targeted host. The detected character is: #" & Query[x] & "."
  NEXT x

  IF INSTR(Query, "./") > 0 THEN Wynik = "An URL containing a dot-slash (""./"") has been detected."
  IF INSTR(Query, "../") > 0 THEN Wynik = "Directory traversal attempt. An URL containing two dots ("".."") has been detected."
  IF INSTR(Query, "\") > 0 THEN Wynik = "A backslash has been detected in the query. There is no reason for that character to appear in a http request."
  IF WarnOnly = 1 AND LEN(Wynik) > 0 THEN Wynik = "!" + Wynik
  RETURN Wynik
END FUNCTION


SUB About()
  PRINT "Grumpy v"; pVer; " Copyright (C) Mateusz Viste "; pDate
  PRINT
  PRINT "This program is free software: you can redistribute it and/or modify it under"
  PRINT "the terms of the GNU General Public License as published by the Free Software"
  PRINT "Foundation, either version 3 of the License, or (at your option) any later"
  PRINT "version."
  PRINT "This program is distributed in the hope that it will be useful, but WITHOUT ANY"
  PRINT "WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A"
  PRINT "PARTICULAR PURPOSE. See the GNU General Public License for more details."
  PRINT
  PRINT "Grumpy is a simple open-source web server for Linux. Grumpy is not a standalone"
  PRINT "daemon - it requires an inetd-compatible superserver to work. Why one would"
  PRINT "prefer Grumpy over any other Linux web server, like Apache, Lighttp, Jigsaw...?"
  PRINT "Well, there is no reason - I wrote Grumpy for fun. Grumpy doesn't support any"
  PRINT "bells and twistles: the only HTTP commands it knows are ""GET"" and ""HEAD"" (one"
  PRINT "could say it makes it very secure). Grumpy is entirely written in FreeBASIC."
  PRINT
  PRINT "homepage: "; homepage
  PRINT
  END
END SUB


FUNCTION CheckForAuth(PathToCheckFor AS STRING) AS STRING
  DIM AS STRING AuthFile, Realm = "", LineBuff, AuthUser
  DIM AS BYTE CharBuff
  DIM AS INTEGER FileHook
  AuthFile = PathToCheckFor
  DO
    DO
      CharBuff = AuthFile[LEN(AuthFile) - 1]
      IF CharBuff <> ASC("/") THEN AuthFile = MID(AuthFile, 1, LEN(AuthFile) - 1)
    LOOP UNTIL CharBuff = ASC("/")

    AuthFile += ".grumpy.auth"
    IF FileExists(AuthFile) <> 0 THEN
        IF VerboseMode > 0 THEN LogLine("Auth: The location requires some credentials")
        FileHook = FREEFILE
        OPEN AuthFile FOR INPUT AS FileHook
        IF LOF(FileHook) > 0 THEN
          DO
            LINE INPUT #FileHook, TempString
          LOOP UNTIL EOF(FileHook) OR UCASE(MID(TRIM(TempString), 1, 6)) = "REALM="
          IF UCASE(MID(TRIM(TempString), 1, 6)) = "REALM=" THEN Realm = TRIM(MID(TRIM(TempString), 7))
        END IF
        CLOSE FileHook
        IF Realm = "" THEN Realm = "Authorization required"
      ELSE
        AuthFile = MID(AuthFile, 1, INSTRREV(AuthFile, "/") - 1)
    END IF
  LOOP UNTIL LEN(AuthFile) <= LEN(RootPath) OR LEN(Realm) > 0
  IF LEN(Realm) > 0 AND LEN(AuthorizationBuff) > 0 THEN
    AuthUser = MID(AuthorizationBuff, INSTRREV(AuthorizationBuff, " ") + 1)
    FileHook = FREEFILE
    OPEN AuthFile FOR INPUT AS FileHook
    DO
      LINE INPUT #FileHook, LineBuff
      IF LEFT(LCASE(LineBuff), 6) <> "realm=" AND EncBase64(LineBuff) = AuthUser THEN
        Realm = ""
        IF VerboseMode > 0 THEN LogLine("Auth: Access granted (" + AuthUser + ")")
      END IF
    LOOP UNTIL Realm = "" OR EOF(FileHook)
    CLOSE #FileHook
  END IF
  IF Realm <> "" AND VerboseMode > 0 THEN
    IF LEN(AuthUser) > 0 THEN
        LogLine("Auth: Access denied (" + AuthUser + ")")
      ELSE
        LogLine("Auth: Access denied (no credentials provided)")
    END IF
  END IF
  RETURN Realm
END FUNCTION


FUNCTION LineInput(SocketToListenTo AS INTEGER = 0) AS STRING
  DIM AS STRING Wynik, CharBuff
  DIM AS DOUBLE LastData
  DIM AS BYTE TimeoutAbort = 0
  LastData = TIMER
  DO
    CharBuff = INPUT(1, SocketToListenTo)
    IF CharBuff <> CHR(13) AND CharBuff <> CHR(10) AND CharBuff <> "" THEN Wynik += CharBuff: LastData = TIMER
    IF TIMER - LastData > 10 THEN TimeoutAbort = 1
  LOOP UNTIL TimeoutAbort = 1 OR LEN(Wynik) > 1024 * 1024 OR CharBuff = CHR(10)
  IF LEN(Wynik) > 1024 * 1024 THEN
    IF VerboseMode > 0 THEN LogLine("I/O OVERFLOW - Treatement aborted. Dataline to long (>1 MB).")
    CLOSE
    END
  END IF
  IF TimeoutAbort = 1 THEN
    IF VerboseMode > 0 THEN LogLine("I/O TIMEOUT - Treatement aborted. Waiting period to long (>10s).")
    CLOSE
    END
  END IF
  RETURN Wynik
END FUNCTION


FUNCTION GetFileSize(FileToCheck AS STRING) AS STRING
  DIM AS UINTEGER FileSize
  DIM AS INTEGER FileHook
  DIM AS STRING SizeString
  FileHook = FREEFILE
  OPEN FileToCheck FOR BINARY AS FileHook
  FileSize = LOF(FileHook)
  CLOSE #FileHook
  IF FileSize >= 1024^3 THEN
      SizeString = FORMAT(FileSize / 1024^3, "#.0") & " GiB"
    ELSEIF FileSize >= 1024^2 THEN
      SizeString = FORMAT(FileSize / 1024^2, "#.0") & " MiB"
    ELSEIF FileSize >= 1024 THEN
      SizeString = FORMAT(FileSize / 1024, "#.0") & " KiB"
    ELSE
      SizeString = FileSize & " bytes"
  END IF
  RETURN SizeString
END FUNCTION


FUNCTION GetFileDate(FileToCheck AS STRING) AS STRING
  DIM MonthList(1 TO 12) AS STRING => {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}
  DIM AS INTEGER fDay, fMonth, fYear, fHour, fMinute
  DIM AS DOUBLE fTimeSerial
  DIM AS STRING Wynik
  fTimeSerial = FileDateTime(FileToCheck)
  fDay = DAY(fTimeSerial)
  fMonth = MONTH(fTimeSerial)
  fYear = YEAR(fTimeSerial)
  fHour = HOUR(fTimeSerial)
  fMinute = MINUTE(fTimeSerial)
  Wynik = "" & fDay & " " & MonthList(fMonth) & " " & fYear & ", " & fHour & ":" & RIGHT("0" & fMinute, 2)
  RETURN Wynik
END FUNCTION


FUNCTION GetFileDescription(FileToCheck AS STRING, DescrPath AS STRING) AS STRING
  DIM AS STRING Wynik, DescrFile, Token1, Token2, LineBuff
  DIM AS BYTE CharBuff
  DIM AS INTEGER FileHook
  DescrFile = DescrPath + "descript.ion"
  FileHook = FREEFILE
  IF FileExists(DescrFile) <> 0 THEN
    OPEN DescrFile FOR INPUT AS FileHook
    IF LOF(FileHook) > 0 THEN
      DO
        LINE INPUT #FileHook, LineBuff
        LineBuff = TRIM(LineBuff)
        Token1 = TRIM(MID(LineBuff, 1, INSTR(LineBuff, CHR(9)) - 1))
        Token2 = TRIM(MID(LineBuff, INSTR(LineBuff, CHR(9)) + 1))
        IF Token1 = FileToCheck THEN Wynik = Token2
      LOOP UNTIL EOF(FileHook) OR LEN(Wynik) > 0
    END IF
    CLOSE FileHook
  END IF
  RETURN Wynik
END FUNCTION


FUNCTION HtmlizeText(QueryString AS STRING) AS STRING
  DIM AS STRING Processing
  DIM AS INTEGER AmpPosition
  Processing = QueryString
  FOR AmpPosition = LEN(Processing) TO 1 STEP -1
    SELECT CASE MID(Processing, AmpPosition, 1)
      CASE "&"
        Processing = MID(Processing, 1, AmpPosition - 1) + "&amp;" + MID(Processing, AmpPosition + 1, LEN(Processing) - AmpPosition)
      CASE CHR(34)
        Processing = MID(Processing, 1, AmpPosition - 1) + "&quot;" + MID(Processing, AmpPosition + 1, LEN(Processing) - AmpPosition)
      CASE "<"
        Processing = MID(Processing, 1, AmpPosition - 1) + "&lt;" + MID(Processing, AmpPosition + 1, LEN(Processing) - AmpPosition)
      CASE ">"
        Processing = MID(Processing, 1, AmpPosition - 1) + "&gt;" + MID(Processing, AmpPosition + 1, LEN(Processing) - AmpPosition)
    END SELECT
  NEXT
  RETURN Processing
END FUNCTION


SUB LogLine(TextToLog AS STRING = "")
  DIM AS INTEGER FileSocket
  IF VerboseMode > 0 THEN
    FileSocket = FREEFILE
    IF LogEntries <= 100 THEN
        OPEN "/var/log/grumpy.log" FOR APPEND AS FileSocket
          PRINT #FileSocket, "[PID=" & GetPID() & "]"; "  "; TextToLog
        CLOSE FileSocket
      ELSE
        OPEN "/var/log/grumpy.log" FOR APPEND AS FileSocket
          PRINT #FileSocket, "[PID=" & GetPID() & "]"; "  "; "*** LOG OVERFLOW - PROCESS ABORTED ***"
        CLOSE FileSocket
        CLOSE
        END
    END IF
  END IF
END SUB


SUB ExecCgi(CgiProgram AS STRING, HeadQuery AS BYTE = 0)
  DIM AS STRING DateHeader, ServerHeader, LineBuff, Parameters, TempString
  DIM AS INTEGER CgiHandler, IntCounter, ResOk
  DIM AS UINTEGER bytesread
  DIM ByteBuff AS STRING*1
  DIM AS BYTE HeaderDone, NphScript
  DateHeader = "Date: " + GetRFC1123time(NowGMT())
  ServerHeader = "Server: Grumpy/" + pVer

  IF LEN(SrvSideParams) > 0 AND INSTR(SrvSideParams, "=") = 0 THEN
    Parameters = " "
    FOR IntCounter = 1 TO LEN(SrvSideParams)
      IF MID(SrvSideParams, IntCounter, 1) <> "&" AND MID(SrvSideParams, IntCounter, 1) <> ";" THEN
        Parameters += MID(SrvSideParams, IntCounter, 1)
       ELSE
        Parameters += " "
      END IF
    NEXT IntCounter
  END IF

  Parameters = TranslatePercentEnc(Parameters)        ' Decode % encoding for command-line params

  IntCounter = LEN(CgiProgram)                                             '
  DO                                                                       '  Check for
    IntCounter -= 1                                                        '  NPH script
  LOOP UNTIL MID(CgiProgram, IntCounter, 1) = "/" OR IntCounter = 1        '
  IF LCASE(MID(CgiProgram, IntCounter + 1, 4)) = "nph-" THEN NphScript = 1 '


  IF VerboseMode > 0 THEN
    IF NphScript = 1 THEN
        LogLine("Response: 200 OK (Exec NPH-CGI " + CHR(34) + CgiProgram + Parameters + CHR(34) + ")")
      ELSE
        LogLine("Response: 200 OK (Exec CGI " + CHR(34) + CgiProgram + Parameters + CHR(34) + ")")
    END IF
  END IF

  REM  ** Set all CGI environment variables **
  SetEnv("SERVER_SOFTWARE=Grumpy/" + pVer)                               ' The name and version of the server software. Format: name/version
  IF LEN(HostBuff) > 0 THEN SetEnv("SERVER_NAME=" + HostBuff)            ' The server's hostname, DNS alias, or IP address as it would appear in self-referencing URLs.
  SetEnv("GATEWAY_INTERFACE=CGI/1.0")                                    ' The revision of the CGI specification to which this server complies. Format: CGI/revision (typically CGI/1.0 or CGI/1.1)
  IF LEN(SrvSideParams) > 0 THEN SetEnv("QUERY_STRING=" + SrvSideParams) ' QUERY_STRING should not be decoded in any fashion!
  IF LEN(UserAgentBuff) > 0 THEN SetEnv("HTTP_USER_AGENT=" + UserAgentBuff)
  IF LEN(GetParam1) > 0 THEN SetEnv("SCRIPT_NAME=" + GetParam1)
  IF LEN(GetQuery) > 0 THEN SetEnv("REQUEST_METHOD=" + GetQuery)
  IF LEN(GetParam2) > 0 THEN
    SetEnv("HTTP_VERSION=" + GetParam2)
    SetEnv("SERVER_PROTOCOL=" + GetParam2)
  END IF
  IF LEN(CookieBuff) > 0 THEN SetEnv("HTTP_COOKIE=" + CookieBuff)
  IF LEN(RefererBuff) > 0 THEN SetEnv("HTTP_REFERER=" + RefererBuff)
  IF LEN(AuthorizationBuff) > 0 THEN
    IF UCASE(MID(AuthorizationBuff, 1, 5)) = "BASIC" THEN TempString = "BASIC"
    IF UCASE(MID(AuthorizationBuff, 1, 6)) = "DIGEST" THEN TempString = "DIGEST"
    'SetEnv("AUTH_USER=" + AuthUser)
    'SetEnv("REMOTE_USER=" + AuthUser)
    SetEnv("AUTH_TYPE=" + TempString)
  END IF
  REM  ** Environment variables set. **

  CgiHandler = FREEFILE
'  OPEN PIPE CgiProgram + Parameters FOR BINARY ACCESS READ AS #CgiHandler
  OPEN PIPE CgiProgram + Parameters FOR INPUT AS #CgiHandler

  IF NphScript = 0 THEN    ' If not NPH script, then parse the header
    PRINT #5, "HTTP/1.1 200 OK"; CRLF;
    HeaderDone = 0
    WHILE HeaderDone = 0 AND NOT EOF(CgiHandler)
      LINE INPUT #CgiHandler, LineBuff
      IF LineBuff = "" THEN
          HeaderDone = 1
        ELSE
          IF UCASE(LEFT(LineBuff, 7)) = "SERVER:" THEN ServerHeader = ""
          IF UCASE(LEFT(LineBuff, 5)) = "DATE:" THEN DateHeader = ""
          PRINT #5, LineBuff; CRLF;
      END IF
    WEND

'    WHILE HeaderDone = 0 AND NOT EOF(CgiHandler)
'      GET #CgiHandler,, ByteBuff
'      IF ByteBuff <> CHR(13) AND ByteBuff <> CHR(10) THEN LineBuff += ByteBuff
'      IF ByteBuff = CHR(10) THEN
'        IF LEN(LineBuff) > 0 THEN PRINT #5, LineBuff; CRLF;
'        IF UCASE(LEFT(LineBuff, 7)) = "SERVER:" THEN ServerHeader = ""
'        IF UCASE(LEFT(LineBuff, 5)) = "DATE:" THEN DateHeader = ""
'        IF LineBuff = "" THEN HeaderDone = 1 ELSE LineBuff = ""
'      END IF
'    WEND

    IF LEN(DateHeader) > 0 THEN PRINT #5, DateHeader; CRLF;
    IF LEN(ServerHeader) > 0 THEN PRINT #5, ServerHeader; CRLF;
    PRINT #5, "Connection: close"; CRLF;
    'PRINT #5, "Allow: GET, HEAD"; CRLF;
    'PRINT #5, "Accept-Ranges: bytes"; CRLF;
    'PRINT #5, "Content-Length: 8700"; CRLF;
    'PRINT #5, "Content-Type: text/html; charset=UTF-8"; CRLF;
    PRINT #5, CRLF;
  END IF

  WHILE NOT EOF(CgiHandler)
    LINE INPUT #CgiHandler, TempString
    PRINT #5, TempString
  WEND

'  bytesread = 1
'  IF HeadQuery = 0 THEN
'    WHILE bytesread > 0
'      PRINT #5, "-";
'      ResOk = GET(#CgiHandler,, ByteBuff,,bytesread)
'      PRINT #5, ByteBuff;
'    WEND
'  END IF
  CLOSE #CgiHandler
END SUB


SUB SetEnv(EnvString AS STRING)
  DIM AS BYTE x
  DO
    x += 1
  LOOP UNTIL LEN(EnvVariables(x)) = 0 OR x = UBOUND(EnvVariables)
  IF LEN(EnvVariables(x)) = 0 THEN
    EnvVariables(x) = EnvString
    SETENVIRON(EnvVariables(x))
  END IF
END SUB