REM
REM THIS FILE IS PART OF THE "GRUMPY WEB SERVER" PROJECT
REM http://www.viste-family.net/mateusz/grumpy/
REM
REM  Gopher server engine
REM  Author: Mateusz Viste <mateusz@viste-family.net>
REM  Last modified: 25 Jan 2009
REM


PRIVATE FUNCTION DetectGopherType(FilenameString AS STRING) AS STRING
  DIM GopherType AS STRING
  IF INSTR(FilenameString, ".") > 0 THEN
    SELECT CASE LCASE(MID(FilenameString, INSTRREV(FilenameString, ".")))
      CASE ".txt"
        GopherType = "0"
      CASE ".zip", ".rar", ".arj", ".tar", ".tgz", ".gz", ".bz2"
        GopherType = "5"
      CASE ".gif"
        GopherType = "g"
      CASE ".jpg", ".jpeg", ".png", ".bmp", ".pcx", ".ico", ".tif", ".tiff", ".svg", ".eps"
        GopherType = "I"
      CASE ".mp3", ".mp2", ".wav", ".mid"
        GopherType = "s"
      CASE ".htm", ".html"
        GopherType = "h"
      CASE ELSE
        GopherType = "9"
    END SELECT
  ELSE
    GopherType = "9"
  END IF
  RETURN GopherType
END FUNCTION


SUB GopherProcess()
  DIM AS STRING FileName, EntryDescription, GopherRoot, GopherHostname, GopherPort, GopherType, DirectoryToList
  DIM AS STRING*1 ByteBuff
  DIM AS STRING*1024 KByteBuff
  DIM AS UINTEGER FileAttrib
  DIM AS INTEGER DirIndex, x, y, SmallestEntry
  DIM DirList(1 TO 20000) AS STRING

  GopherRoot = ReadCFG("/etc/grumpy.cfg", "GopherRoot")
  GopherPort = ReadCFG("/etc/grumpy.cfg", "GopherPort")
  GopherHostname = ReadCFG("/etc/grumpy.cfg", "GopherHostname")
  IF TRIM(GopherRoot) = "" THEN GopherRoot = "/var/gopher/"
  IF TRIM(GopherPort) = "" THEN GopherPort = "70"

  DirectoryToList = LineInput(4)
  IF VerboseMode > 0 THEN LogLine("GopherQuery=" + CHR(34) + DirectoryToList + CHR(34))
  DirectoryToList = RemoveDoubleSlash("/" + DirectoryToList)
  LocalFile = RemoveDoubleSlash(GopherRoot + "/" + DirectoryToList)

  IF CheckForEvasion(GopherRoot, LocalFile) = 1 THEN
      IF VerboseMode > 0 THEN LogLine("Response=""Evasion attempt. Forbidden!""")
      PRINT "iForbidden!"; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "."; CRLF;
    ELSE
      IF IsDirectory(LocalFile) = 1 THEN
          IF RIGHT(LocalFile, 1) <> "/" THEN LocalFile += "/"
          IF RIGHT(DirectoryToList, 1) <> "/" THEN DirectoryToList += "/"
          TempString = CheckForAuth(LocalFile)
          IF TempString <> "" THEN
              PRINT "iThis ressource is protected by a password, and may be accessed via http only. Sorry."; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "."; CRLF;
              IF VerboseMode > 0 THEN LogLine("Response=""Password-protection. Access denied.""")
            ELSE
              ' LIST FILES & DIRECTORIES
              EntryDescription = GetFileDescription(".", LocalFile)
              IF LEN(EntryDescription) > 0 THEN PRINT #5, "i"; EntryDescription; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "i"; CHR(9); "fake"; CHR(9); "NULL"; CHR(9); "0"; CRLF;
              FileName = DIR(LocalFile + "*", &h37, FileAttrib)
              DirIndex = 0
              WHILE FileName <> "" AND DirIndex < 20000
                IF FileName <> "." AND FileName <> ".." AND LEFT(FileName, 1) <> "." AND Filename <> "descript.ion" THEN
                  DirIndex += 1
                  DirList(DirIndex) = FileName
                  IF FileAttrib AND &h10 THEN DirList(DirIndex) = CHR(9) + DirList(DirIndex)
                END IF
                FileName = DIR(FileAttrib)
              WEND
            REM  ***  Here I am sorting the directory's entries ***
              IF DirIndex > 1 THEN strQsort(DirList(), DirIndex)  ' (included in sortstr.bi)
              ' Now, we will display all entries
              IF LEN(FileName) > 0 THEN PRINT "iWarning: Too much entries, only 20'000 are displayed!"; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "i"; CHR(9); "fake"; CHR(9); "NULL"; CHR(9); "0"; CRLF;
              IF DirIndex > 0 THEN
                  FOR x = 1 TO DirIndex
                    IF MID(DirList(x), 1, 1) = CHR(9) THEN
                        GopherType = "1"
                        DirList(x) = MID(DirList(x), 2)
                      ELSE
                        GopherType = DetectGopherType(DirList(x))
                    END IF
                    EntryDescription = GetFileDescription(DirList(x), LocalFile)
                    IF TRIM(EntryDescription) = "" THEN EntryDescription = DirList(x)
                    PRINT GopherType; EntryDescription; CHR(9); DirectoryToList + DirList(x); CHR(9); GopherHostname; CHR(9); GopherPort; CRLF;
                  NEXT x
                  PRINT "."; CRLF;
                  IF VerboseMode > 0 THEN LogLine("Response=""Return directory listing. (" + LocalFile + ")""")
                ELSE
                  PRINT "iThis directory is empty."; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "."; CRLF;
                  IF VerboseMode > 0 THEN LogLine("Response=""Empty Directory""")
              END IF
          END IF
        ELSE
          TempString = CheckForAuth(LocalFile)
          IF TempString <> "" THEN
              PRINT "iThis ressource is protected by a password, and may be accessed via http only. Sorry."; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "."; CRLF;
              IF VerboseMode > 0 THEN LogLine("Response=""Password-protection. Access denied.""")
            ELSE
              IF FileExists(LocalFile) <> 0 AND RIGHT(LocalFile, 13) <> "/.grumpy.auth" THEN
                  IF VerboseMode > 0 THEN LogLine("Response=""Return file. (" + LocalFile + ")""")
                  GopherType = DetectGopherType(LocalFile)
                  SELECT CASE GopherType
                    CASE "0", "2", "6"
                      OPEN LocalFile FOR INPUT AS #20
                      WHILE NOT EOF(20)
                        LINE INPUT #20, LineBuff
                        PRINT #5, LineBuff; CRLF;
                      WEND
                      CLOSE(20)
                      PRINT "."; CRLF;
                   CASE ELSE
                      OPEN LocalFile FOR BINARY AS #20
                      x = 1
                      WHILE LOF(20) - x > 1024        '
                        x += 1024                     ' Caching the file
                        GET #20, x - 1024, KByteBuff  ' into 1K blocks
                        PRINT #5, KByteBuff;          '
                      WEND
                      FOR x = x TO LOF(20)
                        GET #20, x, ByteBuff
                        PRINT #5, ByteBuff;
                      NEXT x
                      CLOSE(20)
                  END SELECT
                ELSE
                  IF VerboseMode > 0 THEN LogLine("Response=""Ressource doesn't exist!""")
                  PRINT "3The selected ressource doesn't exist!"; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF;
                  PRINT "iThe selected ressource cannot be located."; CHR(9); "fake"; CHR(9); "(NULL)"; CHR(9); "0"; CRLF; "."; CRLF;
              END IF
          END IF
      END IF
  END IF
END SUB
