REM
REM  This file is part of the Grumpy project
REM
REM
REM  BASE64 encoding
REM  Usage: EncBase64(StringToEncode AS STRING) AS STRING
REM
REM  The function returns the encoded string.
REM

PRIVATE FUNCTION E0(v1 AS INTEGER) AS INTEGER
  RETURN v1 SHR 2
END FUNCTION

PRIVATE FUNCTION E1(v1 AS INTEGER, v2 AS INTEGER) AS INTEGER
  RETURN ((v1 AND 3) SHL 4) + (v2 SHR 4)
END FUNCTION

PRIVATE FUNCTION E2(v2 AS INTEGER, v3 As Integer) AS INTEGER
  RETURN ((v2 AND &H0F) SHL 2) + (v3 SHR 6)
END FUNCTION

PRIVATE FUNCTION E3(v3 AS INTEGER) AS INTEGER
  RETURN (v3 AND &H3F)
END FUNCTION

PUBLIC FUNCTION EncBase64(S AS STRING) AS STRING
  DIM AS STRING C = "ABCDEFGHIJKLMNOPQRSTUVWXYZ" & _
                    "abcdefghijklmnopqrstuvwxyz" & _
                    "0123456789+/"
  DIM AS INTEGER j, k, l = LEN(S)
  DIM AS STRING  t
  IF l = 0 THEN RETURN t

  t = STRING(((l+2)\3)*4,"=")
  FOR j = 0 TO l - ((l MOD 3) + 1) STEP 3
    t[k+0] = C[e0(S[j+0])]
    t[k+1] = C[e1(S[j+0],S[j+1])]
    t[k+2] = C[e2(S[j+1],S[j+2])]
    t[k+3] = C[e3(S[j+2])]:k+=4
  NEXT
  IF (l MOD 3) = 2 THEN
    t[k+0]=C[e0(S[j+0])]
    t[k+1]=C[e1(S[j+0],S[j+1])]
    t[k+2]=C[e2(S[j+1],S[j+2])]
    t[k+3]=61
  ELSEIF (l MOD 3) = 1 THEN
    t[k+0]=C[e0(S[j+0])]
    t[k+1]=C[e1(S[j+0],S[j+1])]
    t[k+2]=61
    t[k+3]=61
  END IF
  RETURN t
END FUNCTION