/*
 * Copy me if you can. 
 * by 20h
 */

#include <unistd.h>
#include <dirent.h>
#include <malloc.h>
#include <memory.h>
#include <netdb.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/types.h>
#include "ind.h"
#include "handlr.h"
#include "arg.h"

#define VERSION "Glenda/Gopherd R2"

typedef struct filefuncs filefunc;
struct filefuncs {
	void (* f)(int, char *, char *, char *);
	char *ext;
};

filefunc functions[] = {
	{handlebin, 	"default"},
	{handlegph,	"gph"},
	{handlebin,	"bin"},
	{handlebin,	"txt"},
	{handlebin,	"tgz"},
	{nil,		nil},
};

int debug;

char *argv0;
char *stdhtdocs = "/var/gopher";
char *stdport = "70";
char *indexf = "/index.gph";
char *err = "0Sorry, but the requested token could not be found\tErr"
	    "\tlocalhost\t70\r\n.\r\n\r\n";
char *htredir = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
		"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n"
		"	\"DTD/xhtml-transitional.dtd\">\n"
		"<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\">\n"
		"  <head>\n"
		"    <title>gopher redirect</title>\n"
		"\n"
		"    <meta http-equiv=\"Refresh\" content=\"1;url=%s\" />\n"
		"  </head>\n"
		"  <body>\n"
		"    This page is for redirecting you to: <a href=\"%s\">%s</a>.\n"
		"  </body>\n"
		"</html>\n";

char *
securepath(char *p, int len)
{
	int i;

	for(i = 1; i < strlen(p); i++)	
		if(p[i - 1] == '/' && p[i] == '.')
			p[i] = '/';

	return p;
}

void
handlerequest(int sock, char *htdocs, char *port)
{
	struct stat dir;
	char recvb[1024], path[1024];
	int len, fd;

	memset(&dir, 0, sizeof(dir));
	memset(recvb, 0, sizeof(recvb));

	len = recv(sock, recvb, sizeof(recvb), 0);
	if(len > 1) {
		if(recvb[len - 2] == '\r')
			recvb[len - 2] = '\0';
		if(recvb[len - 1] == '\n')
			recvb[len - 1] = '\0';
	}

	if(debug)	
		fprintf(stderr, "req: %s\n\n", recvb);

	if(!strncmp(recvb, "URL:", 4)) {
		len = snprintf(path, sizeof(path), htredir,
				recvb + 4, recvb + 4, recvb + 4);
		if(len > sizeof(path))
			len = sizeof(path);
		send(sock, path, len, 0); 
		return;
	}	

	securepath(recvb, len - 2);
	strncpy(path, htdocs, sizeof(path));
	strncat(path, recvb, sizeof(path) - strlen(path));
	if(stat(path, &dir) != -1 && S_ISDIR(dir.st_mode))
		strncat(path, indexf, sizeof(path) - strlen(path));

	fd = open(path, O_RDONLY);
	if(fd >= 0) {
		close(fd);
		for(len = 0; functions[len].ext != nil; len++) {
			if(!strncmp(functions[len].ext, path + strlen(path) - 3,
					3 )&& functions[len].f != nil) {
				(functions[len].f)(sock, path, port, htdocs);
				break;
			}
		}
		if(functions[len].ext == nil)
			(functions[0].f)(sock, path, port, htdocs);
	} else {
		if(S_ISDIR(dir.st_mode)) {
			handledir(sock, path, port, htdocs);
			return;
		}
			
		send(sock, err, strlen(err), 0);
		close(sock);
	}

	return;
}

void
usage(void)
{

	fprintf(stdout, "usage: %s [-d] [-b htdocs] [-p port]\n",
			argv0);

	exit(1);
} 

int
main(int argc, char *argv[])
{
	struct sockaddr_in conn, serv;
	socklen_t lens;
	int sock, list, opt;
	char *port, *htdocs;

	debug = 0;
	htdocs = stdhtdocs;
	port = stdport;

	ARGBEGIN {
	case 'b':
		htdocs = EARGF(usage());
		break;
	case 'p':
		port = EARGF(usage());
		break;
	case 'd':
		debug = 1;
		break;
	default:
		usage();
	} ARGEND;

	if(!debug && fork() != 0)
		return 0;

	list = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if(list < 0) {
		perror("announce");
		return 1;
	}

	serv.sin_family = AF_INET;
	serv.sin_addr.s_addr = INADDR_ANY;
	serv.sin_port = htons(atoi(port));
	if(bind(list, (struct sockaddr *)&serv, sizeof(serv)) < 0) {
		perror("bind");
		return -1;
	}

	if(listen(list, 10) < 0) {
		perror("listen");
		close(list);
		return 1;
	}

	lens = sizeof(conn);
	for(;;) {
		sock = accept(list, (struct sockaddr *)&conn, &lens);
		if(sock < 0) {
			perror("listen");
			close(list);
			return 1;
		}

		switch(fork()) {
		case -1:
			perror("forking");
			close(sock);
			break;
		case 0: 
			handlerequest(sock, htdocs, port);
			return 1;
		default:
			wait(&opt);
			close(sock);
			break;
		}
	}

	close(list);
	return 0;
}

