/*
 * Copy me if you can. 
 * by 20h
 */

#include <unistd.h>
#include <malloc.h>
#include <memory.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include "ind.h"

void *
gmallocz(int l, int d)
{
	char *ret;

	ret = malloc(l);
	if(ret == nil) {
		perror("malloc");
		exit(1);
	}

	if(d)
		memset(ret, 0, l);

	return (void *)ret;
}

char *
gstrdup(char *str)
{
	char *ret;

	ret = strdup(str);
	if(ret == nil) {
		perror("strdup");
		exit(1);
	}

	return ret;
}

char *
readln(int fd)
{
	char *ret;
	int len;

	len = 1;

	ret = malloc(2);
	while(read(fd, &ret[len - 1], 1) > 0 && ret[len - 1] != '\n')
		ret = realloc(ret, ++len + 1);
	if(ret[len - 1] != '\n') {
		free(ret);
		return nil;
	}
	ret[len - 1] = '\0';

	return ret;
}

void
freeelem(Elems *e)
{

	if(e != nil) {
		if(e->e != nil) {
			for(;e->num > 0; e->num--)
				if(e->e[e->num - 1] != nil)
					free(e->e[e->num - 1]);
			free(e->e);
		}
		free(e);
	}
	return;
}

void
freeindex(Indexs *i)
{

	if(i != nil) {
		if(i->n != nil) {
			for(;i->num > 0; i->num--)
				if(i->n[i->num - 1] != nil)
					freeelem(i->n[i->num - 1]);
			free(i->n);
		}
		free(i);
	}

	return;
}

void
addelem(Elems *e, char *s)
{

	e->num++;
	e->e = realloc(e->e, sizeof(char *) * e->num);
	e->e[e->num - 1] = gmallocz(strlen(s) + 1, 0);
	strcpy(e->e[e->num - 1], s);

	return;
}

Elems *
getadv(char *str)
{
	char *b, *e;
	Elems *ret;

	b = str;
	e = strchr(b, '[');
	if(e == nil)
		return nil;
	b = e + 1;
	e = nil;
	ret = gmallocz(sizeof(Elems), 2);

	while((e = strchr(b, '|')) != nil) {
		*e = '\0';
		e++;
		addelem(ret, b);
		b = e;
	}

	e = strchr(b, ']');
	if(e != nil) {
		*e = '\0';
		addelem(ret, b);
	}
	if(ret->e == nil) {
		free(ret);
		return nil;
	}

	return ret;
}

Indexs *
scanfile(char *fname)
{
	char *ln;
	int fd;
	Indexs *ret;
	Elems *el;

	fd = open(fname, O_RDONLY);
	if(fd < 0)
		return nil;

	ret = gmallocz(sizeof(Indexs), 2);

	while((ln = readln(fd)) != nil) {
		el = getadv(ln);
		free(ln);
		if(el == nil)
			continue;

		ret->num++;
		ret->n = realloc(ret->n, sizeof(Elems) * ret->num);
		ret->n[ret->num - 1] = el;
		el = nil;
	}
	close(fd);

	if(ret->n == nil) {
		free(ret);
		return nil;
	}

	return ret;
}

