/*
 * Copy me if you can. 
 * by 20h
 */

#include <unistd.h>
#include <malloc.h>
#include <memory.h>
#include <netdb.h>
#include <netinet/in.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include "ind.h"
#include "arg.h"

void
handledir(int sock, char *path, char *port, char *htdocs)
{
	char pa[512], file[512], *e, sendb[1024], addr[512], type;
	DIR *dir;
	struct dirent *dirent;
	int len;
	struct stat st;

	strncpy(pa, path, sizeof(pa));
	e = strrchr(pa, '/');
	if(e != nil) {
		*e = '\0';

                if(gethostname(addr, sizeof(addr)) == -1) {
                        perror("gethostname");
                        close(sock);
                        return;
                }

		dir = opendir(pa);
		if(dir == nil) {
			perror("opendir");
			close(sock);
			return;
		}

		for(dirent = readdir(dir); dirent != nil;
				dirent = readdir(dir)) {
			type = '9';
			snprintf(file, sizeof(file) - 1, "%s/%s",
					pa, dirent->d_name);
			if(stat(file, &st) >= 0 && S_ISDIR(st.st_mode))
				type = '1';
			e = file + strlen(htdocs);
			len = snprintf(sendb, sizeof(sendb) - 1,
				"%c%s\t%s\t%s\t%s\r\n",
				type, dirent->d_name, e, addr, port);
			send(sock, sendb, len, 0);
		}
		send(sock, ".\r\n", 3, 0);
	}

	close(sock);
	return;
} 

void
handlegph(int sock, char *file, char *port, char *htdocs)
{
	Indexs *act;
	int i, len;
	char sendb[1024], addr[512];

	USED(htdocs);

	act = scanfile(file);
	if(act != nil) {
		if(gethostname(addr, sizeof(addr)) == -1) {
			perror("gethostname");
			close(sock);
			return;
		}

		for(i = 0; i < act->num; i++) { 
			if(!strncmp(act->n[i]->e[3], "server", 6)) {
				free(act->n[i]->e[3]);
				act->n[i]->e[3] = gstrdup(addr);
			}
			if(!strncmp(act->n[i]->e[4], "port", 4)) {
				free(act->n[i]->e[4]);
				act->n[i]->e[4] = gstrdup(port);
			}
			len = snprintf(sendb, sizeof(sendb) - 1,
				"%.1s%s\t%s\t%s\t%s\r\n",
				act->n[i]->e[0],
				act->n[i]->e[1],
				act->n[i]->e[2],
				act->n[i]->e[3],
				act->n[i]->e[4]);

			freeelem(act->n[i]);
			act->n[i] = nil;
			send(sock, sendb, len, 0);
		}
		send(sock, "\r\n.\r\n\r\n", 7, 0);

		freeindex(act);
	}

	close(sock);
	return;
}

void
handlebin(int sock, char *file, char *port, char *htdocs)
{
	char sendb[1024];
	int len, fd;

	len = -1;
	USED(port);
	USED(htdocs);

	fd = open(file, O_RDONLY);
	if(fd >= 0) {
		while((len = read(fd, sendb, sizeof(sendb))) > 0)
			send(sock, sendb, len, 0);
		close(fd);
	}

	close(sock);
	return;
}

