/*
 *
 *
 *
 */
#include <jni.h>
#include <pwd.h>
#include <unistd.h>
#include <stdio.h>

#include "aftershock_util_UnixUtilities.h"

/*
 * Class:     aftershock_util_UnixUtilities
 * Method:    getUserDir
 * Signature: (Ljava/lang/String;)Ljava/lang/String;
 */
JNIEXPORT jstring JNICALL Java_aftershock_util_UnixUtilities_getUserDir
  (JNIEnv *env, jclass class, jstring userName)
{
  const char *user = (*env)->GetStringUTFChars(env, userName, 0);
  struct passwd *pwd;

  pwd = getpwnam( user );

  if( pwd == NULL ) {
    return (*env)->NewStringUTF( env, "" );
  }

  (*env)->ReleaseStringUTFChars(env, userName, user);
  return (*env)->NewStringUTF( env, pwd->pw_dir );
}

/*
 * Class:     aftershock_util_UnixUtilities
 * Method:    setUserId
 * Signature: (Ljava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_aftershock_util_UnixUtilities_setUserId
  (JNIEnv *env, jclass class, jstring userName)
{
  const char *user = (*env)->GetStringUTFChars( env, userName, 0 );
  struct passwd *pwd;
  int res;

  pwd = getpwnam( user );

  if( pwd == NULL ) {
    return 0;
  }

  res = setuid( pwd->pw_uid );
  if( res != 0 ) {
    return 0;
  }
    
/*   res = setgid( pwd->pw_gid ); */
/*   if( res != 0 ) { */
/*     return 0; */
/*   } */

  (*env)->ReleaseStringUTFChars( env, userName, user );
  return 1;  
}
