//
// UnixUtilities.java
// Part of the Aftershock Project, see README for details
// Copyright 2003 Rob Linwood (rob@linwood.us)
//

package aftershock.util;


public class UnixUtilities {

  /** Was the unixutils library loaded? */
  static boolean canUse = true;

  static {
    try {
      System.loadLibrary( "unixutils" );
    } catch( UnsatisfiedLinkError e ) {
      canUse = false;
    }
  }

  /**
   * Returns the path of the given user's home directory.
   *
   * @param userName the name of the user
   * @return the user's home directory
   */
  public static native String getUserDir( String userName );


  /**
   * Sets the userid of the process to that of the given user.
   *
   * @param userName the name of the user
   * @return true if the uid set, false otherwise.
   */
  public static native boolean setUserId( String userName );


  public static boolean isLoaded() {
    return canUse;
  }
}
