//
// RegexFileFilter.java
// Part of the Aftershock Project, see README for details
// Copyright 2003 Rob Linwood (rob@linwood.us)
//

package aftershock.util;

import java.io.FileFilter;
import java.io.File;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.regex.Matcher;
import java.util.Vector;
import java.util.Iterator;

public class RegexFileFilter implements FileFilter {

  Vector regexs = new Vector();

  public void addFilter( String regex ) {

    Pattern pattern = null;
    try {
      pattern = Pattern.compile( regex );
    } catch( PatternSyntaxException e ) {
      System.err.println( "Bad pattern syntax: " + regex );
      return;
    }

    Matcher matcher = pattern.matcher("");
    regexs.add( matcher );

  }

  public boolean accept( File pathName ) {
    for( Iterator iter=regexs.iterator(); iter.hasNext(); ) {
      Matcher matcher = (Matcher)iter.next();
      matcher.reset( pathName.getName() );
      if( matcher.matches() ) {
	return false;
      }
    }

    return true;
  }

}
