//
// FileUtilities.java
// Based on soma2.webserver.util.FileUtilities
// Part of the Aftershock Project, see README for details
// Copyright 1998-2003 Rob Linwood (rob@linwood.us)
//


package aftershock.util;

import java.io.File;

public class FileUtilities {


  public static String getPathRelativeTo( File file, String relativeName ) {
    String fileName = file.getPath();

    if( fileName.startsWith(relativeName) ) {
      return fileName.substring( relativeName.length() );
    } else {
      return fileName;
    }
  }

  /**
   * Determines if the file exists or not.
   *
   * @param fileName the name of the file to check
   * @return <code>true</code> if the file exists, <code>false</code> otherwise
   */
  public static boolean exists( String fileName ) {
    boolean b;

    try {
      b = new File( fileName ).exists();
    } catch( SecurityException e ) {
      b = false;
    }

    return b;
  }

  
  /**
   * Determines if the file exists or not.  Same as File.exists(), and is available for 
   * convenience reasons.
   *
   * @param file the File to check.
   * @return <code>true</code> if the file exists, <code>false</code> otherwise
   * @deprecated Do not use!  Use File.exists instead.
   */
  public static boolean exists( File file ) {
    return file.exists();
  }

  /**
   * Determines if the file is a directory or not
   *
   * @param fileName the name of the file to check
   * @return <code>true</code> if the file is a directory, 
   *         <code>false</code> otherwise
   */
  
  public static boolean isDir( String fileName ) {
    boolean b;

    try {
      b = new File( fileName ).isDirectory();
    } catch( SecurityException e ) {
      b = false;
    }

    return b;
  }

  public static boolean isDir( File file ) {
    return file.isDirectory();
  }


  // Append a path separator to the end of path if there isn't one already
  public static String slashify( String dir ) {
    
    if( isDir(dir) && (dir.charAt(dir.length()-1) != File.separatorChar) ) {
      return new String( dir + File.separator );
    } else {
      return dir;
    }
  }


  /**
   * Returns the extension of the given file. For example, 
   * <code>getExt("fido.png")</code> would return <code>"png"</code>.
   *
   * @param fileName the name of the file to examine
   * @return the file extension, or <code>""</code> if there is none
   */
  public static String getExt( String fileName ) {
    int dotPos;

    dotPos = fileName.lastIndexOf( '.' );
    if( dotPos == -1 ) {
      return "";
    } else {
      return fileName.substring( dotPos+1 );
    }
  }


  /**
   * Returns the length of the given file in bytes.
   *
   * @param fileName the name of the file to use
   * @return the number of bytes in the file
   */
  public static long getFileLength( String fileName ) {
    long l;

    try {
      l = new File(fileName).length();
    } catch( Exception e ) {  // Two different exceptions could be thrown
      // FIXME - do something
      return 0;
    }

    return l;
  }

  public static long getFileLength( File file ) {
    return file.length();
  }


  /**
   * Returns the last-modified date of the file.
   *
   * @param fileName the name of the file to examin
   * @return the time the file was last modified as a long
   */
  public static long getFileTime( String fileName ) {
    long lm;

    try {
      lm = (new File(fileName)).lastModified();
    } catch( Exception e ) {
      lm = 0;
    }

    return lm;
  }

}
