//
// BufferUtilities.java
// Based on soma2.webserver.util.BufferUtilities
// Part of the Aftershock Project, see README for details
// Copyright 1998-2003 Rob Linwood (rob@linwood.us)
//

package aftershock.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CharacterCodingException;
/**
 * <code>BufferUtilities</code> exists to handle certain translations, specifically those between
 * <code>String</code>s, <code>ByteBuffer</code>s, and <code>CharBuffer</code>s.  Because such
 * translations are common, they are being put in a seperate utility class
 *
 * @author Rob Linwood (rob@auntfloyd.org)
 * @version 0.1
 */

public class BufferUtilities {


  /**
   * Convert a <code>String</code> to a <code>CharBuffer</code>.
   *
   * @param str the <code>String</code> to be converted
   * @return a <code>CharBuffer</code> containing the same characters as the string.
   */
  public static CharBuffer toCharBuffer( String str ) {
    CharBuffer cbuf = CharBuffer.allocate( str.length() );
    cbuf.put( str );
    cbuf.flip();

    return cbuf;
  }

  public static ByteBuffer toByteBuffer( String str, CharsetEncoder encoder ) {
    ByteBuffer buffer = null;
    try {
      buffer = encoder.encode( toCharBuffer(str) );
    } catch( CharacterCodingException e ) {
      e.printStackTrace();
      return null;
    }
    ByteBuffer directBuffer = ByteBuffer.allocate( buffer.limit() );
    directBuffer.put( buffer );
    directBuffer.rewind();

    return directBuffer;
  }

}
