//
// LoggingThread.java
// Based on soma2.webserver.log.LoggingThread
// Part of the Aftershock Project, see README for details
// Copyright 1998-2003 Rob Linwood (rob@linwood.us)
//


package aftershock.log;

import java.io.FileWriter;
import java.io.PrintWriter;

class LoggingThread extends Thread {

  private static final long DEFAULT_SLEEP_TIME = 1000;
  private static final int EVERY_WRITE_COUNT = 10;

  long sleepTime = 0l;

  PrintWriter writer = null;
  String logFileName = null;
  boolean stopped = false;
  int written = 0;


  LoggingThread( String fileName ) {
    this( fileName, DEFAULT_SLEEP_TIME );
  }

  LoggingThread( String fileName, long sleepTime ) {
    assert sleepTime > 0l;

    this.sleepTime = sleepTime;
    this.logFileName = fileName;


    try {
      Runtime.getRuntime().addShutdownHook( new Thread() {
	  public void run() {
	    stopped = true;
	    closeFile();
	  }
	});
    } catch( Exception e ) {
      System.out.println("** LoggingThread: Exception in adding shutdown hook");
      e.printStackTrace();
    }

    openFile();
  }

  void openFile() {
    try {
      writer = new PrintWriter( new FileWriter(logFileName, true) );
    } catch( Exception e ) {
      System.out.println("** LoggingThread: Exception in openFile()");
      e.printStackTrace();
    }
  }

  void closeFile() {
    try {
      writer.close();
    } catch( Exception e ) {
      System.out.println("** LoggingThread: Exception in closeFile()");
      e.printStackTrace();
    }
  }


  public synchronized void write( String msg ) {
    writer.println( msg );
    
    if( (++written % EVERY_WRITE_COUNT) == 0 ) {
      closeFile();
      openFile(); 
    }    
  }

  public synchronized PrintWriter getWriter() {
    return writer;
  }

  public void run() {
    while( stopped == false ) {
      try {
	sleep( sleepTime );
      } catch( InterruptedException e ) {
      }
    }
  }

}
