//
// LogManager.java
// Part of the Aftershock Project, see README for details
// Copyright 2003 Rob Linwood (rob@linwood.us)
//

package aftershock.log;

import aftershock.io.GopherConnection;
import aftershock.conf.Configuration;

public class LogManager {

  LoggingThread accessThread = null;
  LoggingThread errorThread = null;
  LoggingThread exceptionThread = null;
  LoggingThread infoThread = null;

  Configuration config = null;

  public LogManager( Configuration config ) {
    this.config = config;

    if( config.getAccessLogFile() != null ) {
      accessThread = new LoggingThread( config.getAccessLogFile() );
      accessThread.start();
    }
    if( config.getErrorLogFile() != null ) {
      errorThread = new LoggingThread( config.getErrorLogFile() );
      errorThread.start();
    }
    if( config.getExceptionLogFile() != null ) {
      exceptionThread = new LoggingThread( config.getExceptionLogFile() );
      exceptionThread.start();
    }
    if( config.getInfoLogFile() != null ) {
      infoThread = new LoggingThread( config.getInfoLogFile() );
      infoThread.start();
    }
    
  }


  public void logAccess( GopherConnection conn ) {
    if( accessThread == null ) {
      return;
    }
    accessThread.write( LogFormatter
			.format(conn, config.getAccessLogFormat()) );
  }


  public void logError( String msg ) {
    if( errorThread == null ) {
      return;
    }
    errorThread.write( LogFormatter
		       .format(msg, config.getErrorLogFormat()) );
  }


  public void logException( Exception e ) {
    if( exceptionThread == null ) {
      return;
    }
    errorThread.write( LogFormatter
		       .format(e, config.getExceptionLogFormat()) );
  }


  public void logInfo( String msg ) {
    if( infoThread == null ) {
      return;
    }
    infoThread.write( LogFormatter
		      .format(msg,  config.getInfoLogFormat()) );
  }

}
