//
// Pipe.java
// Based on soma2.io.Pipe;
// Part of the Aftershock Project, see README for details
// Copyright 1998-2003 Rob Linwood (rob@linwood.us)
//

package aftershock.io;

import java.nio.channels.SocketChannel;
import java.nio.ByteBuffer;
import java.io.IOException;

public class Pipe {

  static ByteBuffer dot = null;

  static {
    dot = ByteBuffer.allocate( 3 );
    dot.put( (byte)0x2E );  // .
    dot.put( (byte)0x0D );  // <CR>
    dot.put( (byte)0x0A );  // <LF>

    dot.rewind();
  }

  public static void send( ByteBuffer input, SocketChannel sink ) {

    assert input != null : "Pipe input is null";

    try {
      input.rewind();
      sink.write( input );
    } catch( IOException e ) {
      System.err.println( "Exception in Pipe.send()" );
      e.printStackTrace( System.err );
    }

  }

  public static void sendDot( SocketChannel sink ) {
    try {
      dot.rewind();
      sink.write( dot );
    } catch( IOException e ) {
      System.err.println( "Exception in Pipe.sendDot()" );
      e.printStackTrace( System.err );
    }
  }
}
