//
// GopherRequest.java
// Part of the Aftershock Project, see README for details
// Copyright 2003 Rob Linwood (rob@linwood.us)
//

package aftershock.io;

import java.util.Vector;
import java.util.Iterator;
import java.util.StringTokenizer;

public class GopherRequest {
  
  static final String TAB = "\t";

  String selector = null;
  Vector additionalFields = new Vector();

  boolean gopherPlus = false;

  public GopherRequest( String text ) {

    StringTokenizer tok = new StringTokenizer( text, TAB );

    if( text.equals("\t$") || text.equals("\t") ) {
      // Gopher+ client
      gopherPlus = true;
    } else if( text.equals("") ) {
      selector = "/";
    } else {
      selector = tok.nextToken();
    }
      
    while( tok.hasMoreTokens() ) {
      additionalFields.add( tok.nextToken() );
    }

  }    

  public String getSelector() {
    return selector;
  }

  public Iterator getAdditionalFields() {
    return additionalFields.iterator();
  }

  public boolean isGopherPlus() {
    return gopherPlus;
  }
}
