//
// FileTypeManager.java
// Part of the Aftershock Project, see README for details
// Copyright 2003 Rob Linwood (rob@linwood.us)
//

package aftershock.engine;

import aftershock.util.FileUtilities;

import java.util.Hashtable;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.FileNotFoundException;


public class FileTypeManager {

  static Hashtable fileTypes = new Hashtable();

  static {
    // Load defaults
    fileTypes.put( "", "0" ); // Files without an extension are considered text
    fileTypes.put( "txt", "0" );
    fileTypes.put( "jpg", "I" );
    fileTypes.put( "gif", "g" );
    fileTypes.put( "html", "h" );
    fileTypes.put( "htm", "h" );
    fileTypes.put( "hqx", "4" );
    fileTypes.put( "exe", "5" );
    fileTypes.put( "com", "5" );
    fileTypes.put( "uue", "6" );
    fileTypes.put( "gz", "9" );
    fileTypes.put( "zip", "9" );
    fileTypes.put( "jar", "9" );
  }

  public static String getFileType( String fileName ) {
    String ext = FileUtilities.getExt( fileName );
    String type = (String)fileTypes.get( ext.toLowerCase() );

    return type;
  }


  // This is largely a duplicate of Configuration.read()
  public static void read( String fileName ) throws FileNotFoundException {
    BufferedReader in = null;

    in = new BufferedReader( new FileReader(fileName) );

    try {
      String input = null;
      while( (input = in.readLine()) != null ) {
	input = input.trim();
	if( input.length() > 0 ) { // skip blank lines
	  if( input.charAt(0) != '#' ) { // skip comments
	    int colonPos = input.indexOf( ':' );
	    if( colonPos != -1 ) {
	      String key = input.substring( 0, colonPos );
	      String value = input.substring( colonPos+1 ).trim();

	      if( key.equalsIgnoreCase("DefaultType") ) {
		fileTypes.put( "", value );
	      } else if( key.equalsIgnoreCase("AddType") ) {
		int space = value.indexOf( ' ' );
		String ext = value.substring( 0, space );
		String type = value.substring( space+1 );
		
		fileTypes.put( ext, type );
	      }
	    }
	  }
	}
      }
    } catch( IOException e ) {
    }

  }
  
}
