//
// Aftershock.java
// Part of the Aftershock Project, see README for details
// Copyright 2003 Rob Linwood (rob@linwood.us)
//

package aftershock;

import aftershock.conf.Configuration;
import aftershock.engine.ResponseFactory;
import aftershock.io.GopherListener;
import aftershock.util.UnixUtilities;

import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class Aftershock {
  
  public static final String VERSION = "1.01";

  public static final String TAB = "\t";
  public static final String CRLF = "\r\n";

  public static CharsetEncoder asciiEncoder = null;

  static {
    try {
      Charset charset = Charset.forName("US-ASCII");
      asciiEncoder = charset.newEncoder();
    } catch( Exception e ) {
      e.printStackTrace();
    }
  }

  public static void main( String[] args ) {
    String confFile = "aftershock.conf";

    if( args.length == 1 ) {
      confFile = args[0];
    }

    Configuration conf = null;
    
    try {
      conf = new Configuration( confFile );
    } catch( FileNotFoundException e ) {
      System.err.println( "Error: Can't find configuration file " + confFile );
      return;
    }

    int port = conf.getPortNumber();
    
    GopherListener listener = null;
    try {
    listener = new GopherListener( conf );
    } catch( Exception e ) {
      System.err.println( "Error: " + e );
      conf.getLogManager().logException( e );
    }

    if( UnixUtilities.isLoaded() ) {
      if( conf.getUserName() != null ) {
	conf.getLogManager().logInfo( "Switching to user: " + 
				      conf.getUserName() );
      	UnixUtilities.setUserId( conf.getUserName() );
      }
    }

    banner( port );

    conf.getLogManager().logInfo( "Starting Aftershock on port " + port );

    // needed for the run() to work
    final Configuration xConf = conf;
    final int xPort = port;
    try {
      Runtime.getRuntime().addShutdownHook( new Thread() {
	  public void run() {
	    xConf.getLogManager().logInfo("Stopped Aftershock on port "+xPort);
	  }
	});
    } catch( Exception e ) {
      xConf.getLogManager()
	.logError( "Cant add info log shutdown hook. See exception log.");
      xConf.getLogManager().logException( e );
    }

    listener.listen( new ResponseFactory(conf) );

  }


  static void banner( int portNum ) {
    System.out.println( "Aftershock Gopher Server, ver " + VERSION + " Listening on port " + 
			portNum + "\n" +
			"Copyright 1998-2004 Rob Linwood (rob@linwood.us)" );
    
  }
}
