#!/usr/bin/perl -w

#
# This script takes Aftershock's manual.txt and splits it into seperate
# sections, creating files for each section, and a Gopher .Link file to tie
# them all together
#

open( INPUT, "<manual.txt" );
open( LINKS, ">dotLink" );

$sect_count = 0;
$copy_out = 1;

while( <INPUT> ) {
  chomp;
  if( /^\:\: (.+?)$/ ) {
    $sect_count++;
    $copy_out = 0;
    print LINKS "Name=$1\n";
    print LINKS "Path=/manual/sect$sect_count.txt\n";
    print LINKS "Type=0\n";
    if( defined fileno(SECT) ) {
      close( SECT );
    }
    open( SECT, ">sect$sect_count.txt" );
    
  } elsif( 1 == $copy_out ) {
    print LINKS "Name=$_\n";
  } else {
    print SECT "$_\n";
  }
}

close( SECT );
close( LINKS );
close( INPUT );
