/*
 * Decompiled with CFR 0.152.
 */
package aftershock.util;

import java.io.File;

public class FileUtilities {
    public static String getPathRelativeTo(File file, String string) {
        String string2 = file.getPath();
        if (string2.startsWith(string)) {
            return string2.substring(string.length());
        }
        return string2;
    }

    public static boolean exists(String string) {
        boolean bl;
        try {
            bl = new File(string).exists();
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        return bl;
    }

    public static boolean exists(File file) {
        return file.exists();
    }

    public static boolean isDir(String string) {
        boolean bl;
        try {
            bl = new File(string).isDirectory();
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        return bl;
    }

    public static boolean isDir(File file) {
        return file.isDirectory();
    }

    public static String slashify(String string) {
        if (FileUtilities.isDir(string) && string.charAt(string.length() - 1) != File.separatorChar) {
            return new String(string + File.separator);
        }
        return string;
    }

    public static String getExt(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(n + 1);
    }

    public static long getFileLength(String string) {
        long l;
        try {
            l = new File(string).length();
        }
        catch (Exception exception) {
            return 0L;
        }
        return l;
    }

    public static long getFileLength(File file) {
        return file.length();
    }

    public static long getFileTime(String string) {
        long l;
        try {
            l = new File(string).lastModified();
        }
        catch (Exception exception) {
            l = 0L;
        }
        return l;
    }
}

