/*
 * Decompiled with CFR 0.152.
 */
package aftershock.log;

import aftershock.conf.Configuration;
import aftershock.io.GopherConnection;
import aftershock.log.LogFormatter;
import aftershock.log.LoggingThread;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogManager {
    LoggingThread accessThread;
    LoggingThread errorThread;
    LoggingThread exceptionThread;
    LoggingThread infoThread;
    Configuration config;

    public void logAccess(GopherConnection gopherConnection) {
        if (this.accessThread == null) {
            return;
        }
        this.accessThread.write(LogFormatter.format(gopherConnection, this.config.getAccessLogFormat()));
    }

    public void logError(String string) {
        if (this.errorThread == null) {
            return;
        }
        this.errorThread.write(LogFormatter.format(string, this.config.getErrorLogFormat()));
    }

    public void logException(Exception exception) {
        if (this.exceptionThread == null) {
            return;
        }
        this.errorThread.write(LogFormatter.format(exception, this.config.getExceptionLogFormat()));
    }

    public void logInfo(String string) {
        if (this.infoThread == null) {
            return;
        }
        this.infoThread.write(LogFormatter.format(string, this.config.getInfoLogFormat()));
    }

    private final /* synthetic */ void this() {
        this.accessThread = null;
        this.errorThread = null;
        this.exceptionThread = null;
        this.infoThread = null;
        this.config = null;
    }

    public LogManager(Configuration configuration) {
        this.this();
        this.config = configuration;
        if (configuration.getAccessLogFile() != null) {
            this.accessThread = new LoggingThread(configuration.getAccessLogFile());
            this.accessThread.start();
        }
        if (configuration.getErrorLogFile() != null) {
            this.errorThread = new LoggingThread(configuration.getErrorLogFile());
            this.errorThread.start();
        }
        if (configuration.getExceptionLogFile() != null) {
            this.exceptionThread = new LoggingThread(configuration.getExceptionLogFile());
            this.exceptionThread.start();
        }
        if (configuration.getInfoLogFile() != null) {
            this.infoThread = new LoggingThread(configuration.getInfoLogFile());
            this.infoThread.start();
        }
    }
}

