/*
 * Decompiled with CFR 0.152.
 */
package aftershock.log;

import aftershock.io.GopherConnection;
import aftershock.io.GopherRequest;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class LogFormatter {
    static Locale currentLocale = null;

    public static String format(String string) {
        Date date = new Date();
        DateFormat dateFormat = DateFormat.getDateInstance(3, currentLocale);
        String string2 = dateFormat.format(date);
        DateFormat dateFormat2 = DateFormat.getTimeInstance(2, currentLocale);
        String string3 = dateFormat2.format(date);
        String string4 = string.replaceAll("\\{DATE\\}", string2).replaceAll("\\{TIME\\}", string3).replaceAll("\\{NEWLINE\\}", "\n");
        return string4;
    }

    public static String format(Exception exception, String string) {
        StringBuffer stringBuffer = new StringBuffer(200);
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        int n = 0;
        while (n < stackTraceElementArray.length) {
            stringBuffer.append(stackTraceElementArray[n].toString()).append("\n");
            ++n;
        }
        String string2 = LogFormatter.format(string).replaceAll("\\{EXCEPTION\\}", exception.getMessage()).replaceAll("\\{STACK\\}", stringBuffer.toString());
        return string2;
    }

    public static String format(String string, String string2) {
        String string3 = LogFormatter.format(string2).replaceAll("\\{MESSAGE\\}", string);
        return string3;
    }

    public static String format(GopherConnection gopherConnection, String string) {
        GopherRequest gopherRequest = gopherConnection.getRequest();
        String string2 = gopherConnection.getChannel().socket().getInetAddress().toString();
        String string3 = gopherRequest.getSelector().replaceAll("\\r\\n", " [nl] ");
        String string4 = gopherRequest.isGopherPlus() ? "gopher+" : "gopher";
        String string5 = LogFormatter.format(string).replaceAll("\\{REMOTEIP\\}", string2).replaceAll("\\{SELECTOR\\}", string3).replaceAll("\\{PROTOCOL\\}", string4).replaceAll("\\{ERROR\\}", "");
        return string5;
    }

    static {
        currentLocale = Locale.getDefault();
    }
}

