/*
 * Decompiled with CFR 0.152.
 */
package aftershock.io;

import aftershock.conf.Configuration;
import aftershock.io.GopherConnection;
import aftershock.io.GopherRequest;
import aftershock.io.GopherResponseFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GopherListener {
    int port;
    int bufferSize;
    String charsetName;
    Charset charset;
    CharsetEncoder encoder;
    CharsetDecoder decoder;
    Selector serverSelector;
    String hostName;
    String lineEnd;
    int lineEndLength;
    private static final /* synthetic */ boolean $noassert;

    public ServerSocketChannel setup() throws Exception {
        ServerSocketChannel serverSocketChannel = ServerSocketChannel.open();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(this.hostName), this.port);
        serverSocketChannel.socket().bind(inetSocketAddress);
        serverSocketChannel.configureBlocking(false);
        serverSocketChannel.register(this.serverSelector, 16);
        return serverSocketChannel;
    }

    private final void serve(ServerSocketChannel serverSocketChannel, GopherResponseFactory gopherResponseFactory) throws Exception {
        while (this.serverSelector.select() > 0) {
            Iterator<SelectionKey> iterator = this.serverSelector.selectedKeys().iterator();
            while (iterator.hasNext()) {
                SelectionKey selectionKey = iterator.next();
                iterator.remove();
                if (selectionKey.isAcceptable()) {
                    SocketChannel socketChannel = serverSocketChannel.accept();
                    socketChannel.configureBlocking(false);
                    socketChannel.register(this.serverSelector, 1);
                    continue;
                }
                if (!selectionKey.isReadable()) continue;
                if (selectionKey.attachment() == null) {
                    selectionKey.attach(new GopherConnection((SocketChannel)selectionKey.channel()));
                }
                this.processRead(selectionKey, gopherResponseFactory);
            }
        }
    }

    private final void processRead(SelectionKey selectionKey, GopherResponseFactory gopherResponseFactory) throws Exception {
        GopherRequest gopherRequest;
        SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(this.bufferSize);
        socketChannel.read(byteBuffer);
        byteBuffer.flip();
        String string = this.decoder.decode(byteBuffer).toString();
        string = this.chop(string);
        GopherConnection gopherConnection = (GopherConnection)selectionKey.attachment();
        if (!$noassert && gopherConnection == null) {
            throw new AssertionError();
        }
        gopherConnection.request = gopherRequest = new GopherRequest(string);
        gopherResponseFactory.createResponse().respond(gopherConnection);
    }

    public void listen(GopherResponseFactory gopherResponseFactory) {
        if (!$noassert && gopherResponseFactory == null) {
            throw new AssertionError();
        }
        try {
            ServerSocketChannel serverSocketChannel = this.setup();
            while (true) {
                this.serve(serverSocketChannel, gopherResponseFactory);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        if (!$noassert && n <= 0) {
            throw new AssertionError();
        }
        this.port = n;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        if (!$noassert && n <= 0) {
            throw new AssertionError();
        }
        this.bufferSize = n;
    }

    private final String chop(String string) {
        if (string.endsWith("\r\n")) {
            return string.substring(0, string.length() - 2);
        }
        if (string.endsWith("\n")) {
            return string.substring(0, string.length() - 1);
        }
        if (string.endsWith("\r")) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    private final /* synthetic */ void this() {
        this.charsetName = null;
        this.charset = null;
        this.encoder = null;
        this.decoder = null;
        this.serverSelector = null;
        this.hostName = null;
        this.lineEnd = null;
        this.lineEndLength = 1;
    }

    public GopherListener(Configuration configuration) throws Exception {
        this.this();
        if (!$noassert && configuration.getCharsetName() == null) {
            throw new AssertionError();
        }
        if (!$noassert && configuration.getHostName() == null) {
            throw new AssertionError();
        }
        this.hostName = configuration.getHostName();
        this.charsetName = configuration.getCharsetName();
        this.setPort(configuration.getPortNumber());
        this.setBufferSize(configuration.getListenerBufferSize());
        this.serverSelector = Selector.open();
        this.charset = Charset.forName(this.charsetName);
        this.encoder = this.charset.newEncoder();
        this.decoder = this.charset.newDecoder();
        Configuration configuration2 = configuration;
        Thread thread = new Thread(this, configuration2){
            final /* synthetic */ GopherListener this$0;
            final /* synthetic */ Configuration val$xConfig;

            public final void run() {
                if (!this.this$0.serverSelector.isOpen()) {
                    this.val$xConfig.getLogManager().logError("Tried to close an already-closed serverSelector");
                }
                try {
                    this.this$0.serverSelector.close();
                }
                catch (IOException iOException) {
                    this.val$xConfig.getLogManager().logError("I/O Error occured on Selectorshutdown. See exception log.");
                    this.val$xConfig.getLogManager().logException(iOException);
                }
            }
            {
                this.this$0 = gopherListener;
                this.val$xConfig = configuration;
            }
        };
        try {
            Runtime.getRuntime().addShutdownHook(thread);
        }
        catch (Exception exception) {
            configuration.getLogManager().logException(exception);
        }
    }

    static {
        $noassert = Class.forName("[Laftershock.io.GopherListener;").getComponentType().desiredAssertionStatus() ^ true;
    }
}

