/*
 * Decompiled with CFR 0.152.
 */
package aftershock.engine;

import aftershock.Aftershock;
import aftershock.cache.CacheEntry;
import aftershock.conf.Configuration;
import aftershock.io.GopherConnection;
import aftershock.io.GopherRequest;
import aftershock.io.GopherResponse;
import aftershock.io.Pipe;
import aftershock.util.BufferUtilities;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Response
implements GopherResponse {
    static ByteBuffer errorBadSelector;
    static ByteBuffer errorNotFound;
    static ByteBuffer gopherPlusDir;
    Configuration config;
    private static final /* synthetic */ boolean $noassert;

    public void respond(GopherConnection gopherConnection) {
        ByteBuffer byteBuffer = null;
        boolean bl = false;
        GopherRequest gopherRequest = gopherConnection.getRequest();
        this.config.getLogManager().logAccess(gopherConnection);
        if (gopherRequest.isGopherPlus()) {
            byteBuffer = gopherPlusDir;
            bl = true;
        } else {
            String string = gopherRequest.getSelector();
            String string2 = this.config.getGopherRoot() + string;
            CacheEntry cacheEntry = null;
            if (string.charAt(0) == '.') {
                byteBuffer = errorBadSelector;
            } else {
                cacheEntry = this.config.getCache().getEntry(string2);
            }
            if (cacheEntry == null) {
                try {
                    cacheEntry = this.config.getCache().addFile(string2);
                    byteBuffer = cacheEntry.getFile();
                    if (cacheEntry.isDirectory() || cacheEntry.getFileType().equals("0")) {
                        bl = true;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    byteBuffer = errorNotFound;
                    this.config.getLogManager().logError("File not found: " + string2);
                }
                catch (SecurityException securityException) {
                    byteBuffer = errorNotFound;
                    this.config.getLogManager().logError("Security error: " + string2);
                }
                catch (Exception exception) {
                    this.config.getLogManager().logError("Can't add file to cache: " + string2 + "\nSee exception log for more info");
                    this.config.getLogManager().logException(exception);
                }
            } else {
                byteBuffer = cacheEntry.getFile();
                if (cacheEntry.isDirectory() || cacheEntry.getFileType().equals("0")) {
                    bl = true;
                }
            }
        }
        if (!$noassert && byteBuffer == null) {
            throw new AssertionError((Object)"Response: file is null");
        }
        Pipe.send(byteBuffer, gopherConnection.getChannel());
        if (bl) {
            Pipe.sendDot(gopherConnection.getChannel());
        }
        try {
            gopherConnection.getChannel().close();
        }
        catch (Exception exception) {
            this.config.getLogManager().logException(exception);
        }
    }

    private final /* synthetic */ void this() {
        this.config = null;
    }

    Response(Configuration configuration) {
        this.this();
        this.config = configuration;
        gopherPlusDir = BufferUtilities.toByteBuffer("+-1\r\n+INFO: 1Main menu (non-gopher+)\t\t" + configuration.getHostName() + '\t' + configuration.getPortNumber() + "\r\n+ADMIN:\r\n Admin: Server Administrator\r\n Server:\r\n+VIEWS:\r\n application/gopher+-menu: <512b>\r\n+ABSTRACT:\r\n This gopher supports standard gopher access only. Use this\r\n kludge to disable gopher+ client requests by your client.\r\n", Aftershock.asciiEncoder);
    }

    static {
        $noassert = Class.forName("[Laftershock.engine.Response;").getComponentType().desiredAssertionStatus() ^ true;
        errorBadSelector = null;
        errorNotFound = null;
        gopherPlusDir = null;
        errorNotFound = BufferUtilities.toByteBuffer("3File Not Found\tNotFound\terror.host\t1\r\n", Aftershock.asciiEncoder);
        errorBadSelector = BufferUtilities.toByteBuffer("3Bad Selector\tBadSelector\terror.host\t1\r\n", Aftershock.asciiEncoder);
    }
}

