/*
 * Decompiled with CFR 0.152.
 */
package aftershock.engine;

import aftershock.Aftershock;
import aftershock.conf.Configuration;
import aftershock.engine.FileTypeManager;
import aftershock.util.BufferUtilities;
import aftershock.util.FileUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;

public class DirectoryLister {
    private static final /* synthetic */ boolean $noassert;

    public static ByteBuffer list(File file, Configuration configuration) throws SecurityException {
        if (!$noassert && !file.isDirectory()) {
            throw new AssertionError((Object)"DirectoryLister.list() called on non-directory");
        }
        if (!$noassert && configuration.getLinkFileName() == null) {
            throw new AssertionError((Object)"linkFileName is null");
        }
        File file2 = new File(file, configuration.getLinkFileName());
        if (file2.exists()) {
            return DirectoryLister.readLinkFile(file2, configuration);
        }
        File[] fileArray = file.listFiles(configuration.getFileFilter());
        StringBuffer stringBuffer = new StringBuffer(fileArray.length * 35);
        Iterator<File> iterator = Arrays.asList(fileArray).iterator();
        while (iterator.hasNext()) {
            File file3 = iterator.next();
            String string = file3.getName();
            String string2 = FileUtilities.getPathRelativeTo(file3, configuration.getGopherRoot());
            if (file3.isDirectory()) {
                stringBuffer.append("1" + string + '\t' + string2 + '\t' + configuration.getHostName() + '\t' + configuration.getPortNumber() + "\r\n");
                continue;
            }
            String string3 = FileTypeManager.getFileType(string);
            if (string3 == null) {
                string3 = "0";
            }
            stringBuffer.append(string3 + string + '\t' + string2 + '\t' + configuration.getHostName() + '\t' + configuration.getPortNumber() + "\r\n");
        }
        return BufferUtilities.toByteBuffer(stringBuffer.toString(), Aftershock.asciiEncoder);
    }

    static ByteBuffer readLinkFile(File file, Configuration configuration) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error: Tried to read non-existant file: " + file.getPath());
            configuration.getLogManager().logError("Tried to read non-existant file: " + file.getPath());
            configuration.getLogManager().logException(fileNotFoundException);
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = "i";
        String string4 = configuration.getHostName();
        String string5 = "" + configuration.getPortNumber();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string6 = null;
            while ((string6 = bufferedReader.readLine()) != null) {
                int n;
                if ((string6 = string6.trim()).length() <= 0 || string6.charAt(0) == '#' || (n = string6.indexOf(61)) == -1) continue;
                String string7 = string6.substring(0, n).toLowerCase();
                String string8 = string6.substring(n + 1).trim();
                if (string7.equalsIgnoreCase("name")) {
                    if (string != null) {
                        stringBuffer.append(string3 + string + '\t' + string2 + '\t' + string4 + '\t' + string5 + "\r\n");
                        string = null;
                        string2 = null;
                        string3 = "i";
                        string4 = configuration.getHostName();
                        string5 = "" + configuration.getPortNumber();
                    }
                    string = string8;
                    continue;
                }
                if (string7.equalsIgnoreCase("type")) {
                    string3 = string8;
                    continue;
                }
                if (string7.equalsIgnoreCase("path")) {
                    string2 = string8;
                    continue;
                }
                if (string7.equalsIgnoreCase("host")) {
                    string4 = string8;
                    continue;
                }
                if (!string7.equalsIgnoreCase("port")) continue;
                string5 = string8;
            }
            stringBuffer.append(string3 + string + '\t' + string2 + '\t' + string4 + '\t' + string5 + "\r\n");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return BufferUtilities.toByteBuffer(stringBuffer.toString(), Aftershock.asciiEncoder);
    }

    static {
        $noassert = Class.forName("[Laftershock.engine.DirectoryLister;").getComponentType().desiredAssertionStatus() ^ true;
    }
}

