/*
 * Decompiled with CFR 0.152.
 */
package aftershock.cache;

import aftershock.cache.CacheEntry;
import aftershock.conf.Configuration;
import aftershock.util.FileUtilities;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import java.util.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileCache {
    static final int DEFAULT_MAXIMUM_SIZE = 10000000;
    static final int DEFAULT_HASH_SIZE = 50;
    int maximumSize;
    Map cache;
    Configuration config;
    private static final /* synthetic */ boolean $noassert;

    public void setMaxSize(int n) {
        this.maximumSize = n;
    }

    public int getMaxSize() {
        return this.maximumSize;
    }

    public CacheEntry addFile(String string) throws FileNotFoundException, SecurityException {
        CacheEntry cacheEntry = null;
        if (!$noassert && string == null) {
            throw new AssertionError((Object)"FileCache.addFile() : fileName is null");
        }
        File file = new File(string);
        cacheEntry = file.isDirectory() ? CacheEntry.createDirectoryEntry(file, this.config) : CacheEntry.createFileEntry(file, this.config);
        this.cache.put(string, cacheEntry);
        return cacheEntry;
    }

    public CacheEntry getEntry(String string) {
        return (CacheEntry)this.cache.get(string);
    }

    public ByteBuffer getFile(String string) {
        CacheEntry cacheEntry = this.getEntry(string);
        if (cacheEntry != null) {
            if (this.config.checkCacheTimes()) {
                if (FileUtilities.getFileTime(cacheEntry.fileName) > cacheEntry.timeStamp) {
                    this.cache.remove(string);
                    CacheEntry cacheEntry2 = null;
                    try {
                        cacheEntry2 = this.addFile(string);
                    }
                    catch (Exception exception) {
                        this.config.getLogManager().logError("Error reloading file " + string + " into cache. Using old cached copy instead. See exception log for more");
                        this.config.getLogManager().logException(exception);
                        return cacheEntry.getFile();
                    }
                    return cacheEntry2.getFile();
                }
                return cacheEntry.getFile();
            }
            return cacheEntry.getFile();
        }
        return null;
    }

    private final /* synthetic */ void this() {
        this.maximumSize = 10000000;
        this.cache = null;
        this.config = null;
    }

    public FileCache(Configuration configuration) {
        this(configuration, 10000000);
    }

    public FileCache(Configuration configuration, int n) {
        this.this();
        this.config = configuration;
        this.setMaxSize(n);
        this.cache = new Hashtable(50);
    }

    static {
        $noassert = Class.forName("[Laftershock.cache.FileCache;").getComponentType().desiredAssertionStatus() ^ true;
    }
}

