/*
 * Decompiled with CFR 0.152.
 */
package aftershock.cache;

import aftershock.conf.Configuration;
import aftershock.engine.DirectoryLister;
import aftershock.engine.FileTypeManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.GregorianCalendar;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CacheEntry {
    int hits;
    long timeStamp;
    String fileName;
    ByteBuffer fileBytes;
    String fileType;
    boolean isDir;

    static CacheEntry createFileEntry(File file, Configuration configuration) throws FileNotFoundException, SecurityException {
        CacheEntry cacheEntry = new CacheEntry(file.getName());
        cacheEntry.fileType = FileTypeManager.getFileType(file.getName());
        FileInputStream fileInputStream = new FileInputStream(file);
        FileChannel fileChannel = fileInputStream.getChannel();
        try {
            cacheEntry.fileBytes = ByteBuffer.allocate((int)fileChannel.size());
            fileChannel.read(cacheEntry.fileBytes);
        }
        catch (IOException iOException) {
            configuration.getLogManager().logException(iOException);
            System.err.println("Exception in channel.read( fileBytes ) ");
            iOException.printStackTrace(System.err);
            System.exit(1);
        }
        return cacheEntry;
    }

    static CacheEntry createDirectoryEntry(File file, Configuration configuration) throws SecurityException {
        CacheEntry cacheEntry = new CacheEntry(file.getName());
        cacheEntry.fileBytes = DirectoryLister.list(file, configuration);
        cacheEntry.isDir = true;
        return cacheEntry;
    }

    public void hit() {
        ++this.hits;
    }

    public int getHits() {
        return this.hits;
    }

    public long getTime() {
        return this.timeStamp;
    }

    public ByteBuffer getFile() {
        return this.fileBytes;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileType() {
        return this.fileType;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    private final /* synthetic */ void this() {
        this.hits = 0;
        this.fileName = null;
        this.fileBytes = null;
        this.fileType = null;
        this.isDir = false;
    }

    CacheEntry(String string) {
        this.this();
        this.fileName = string;
        this.hits = 0;
        this.timeStamp = new GregorianCalendar().getTimeInMillis();
    }
}

