/*
 * Decompiled with CFR 0.152.
 */
package aftershock;

import aftershock.conf.Configuration;
import aftershock.engine.ResponseFactory;
import aftershock.io.GopherListener;
import aftershock.util.UnixUtilities;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class Aftershock {
    public static final String VERSION = "1.01";
    public static final String TAB = "\t";
    public static final String CRLF = "\r\n";
    public static CharsetEncoder asciiEncoder = null;

    public static void main(String[] stringArray) {
        String string = "aftershock.conf";
        if (stringArray.length == 1) {
            string = stringArray[0];
        }
        Configuration configuration = null;
        try {
            configuration = new Configuration(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error: Can't find configuration file " + string);
            return;
        }
        int n = configuration.getPortNumber();
        GopherListener gopherListener = null;
        try {
            gopherListener = new GopherListener(configuration);
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception);
            configuration.getLogManager().logException(exception);
        }
        if (UnixUtilities.isLoaded() && configuration.getUserName() != null) {
            configuration.getLogManager().logInfo("Switching to user: " + configuration.getUserName());
            UnixUtilities.setUserId(configuration.getUserName());
        }
        Aftershock.banner(n);
        configuration.getLogManager().logInfo("Starting Aftershock on port " + n);
        Configuration configuration2 = configuration;
        int n2 = n;
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(n2, configuration2){
                final /* synthetic */ int val$xPort;
                final /* synthetic */ Configuration val$xConf;

                public final void run() {
                    this.val$xConf.getLogManager().logInfo("Stopped Aftershock on port " + this.val$xPort);
                }
                {
                    this.val$xPort = n;
                    this.val$xConf = configuration;
                }
            });
        }
        catch (Exception exception) {
            configuration2.getLogManager().logError("Cant add info log shutdown hook. See exception log.");
            configuration2.getLogManager().logException(exception);
        }
        gopherListener.listen(new ResponseFactory(configuration));
    }

    static void banner(int n) {
        System.out.println("Aftershock Gopher Server, ver 1.01 Listening on port " + n + "\nCopyright 1998-2004 Rob Linwood (rob@linwood.us)");
    }

    static {
        try {
            Charset charset = Charset.forName("US-ASCII");
            asciiEncoder = charset.newEncoder();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

