/*
 * Copy me, if you can.
 * by 20h
 */

#include <u.h>
#include <libc.h>
#include <ip.h>
#include "ind.h"
#include "handlr.h"

#define VERSION "P9/Gopherd R2"

char *erro = 	"3Sorry, but the requested token could not be found\tErr"
	  		  	"\tlocalhost\t70\r\n";
char *htredir =	"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
				"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n"
				"        \"DTD/xhtml-transitional.dtd\">\n"
				"<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\">\n"
				"  <head>\n"
				"    <title>gopherd redirect</title>\n"
				"\n"
				"    <meta http-equiv=\"Refresh\" content=\"1;url=%s\" />\n"
				"  </head>\n"
				"  <body>\n"
				"    This page is for redirecting you to: <a href=\"%s\">%s</a>.\n"
				"  </body>\n"
				"</html>\n";

typedef struct filefuncs filefunc;
struct filefuncs {
	void (* f)(int, char *, int);
	char *ext;
};

filefunc functions[] = {
	handlebin, 	"default",
	handlegph,		"gph",
	nil,			nil,
};

void
usage(void)
{
	print("usage: gopherd [-b htdocs]\n");
	exits(0);
}

void
main(int argc, char *argv[])
{
	char *htdocs, *path, buf[512];
	Dir *dir;
	int len, fp;

	htdocs = "/usr/gopher";

	ARGBEGIN {
	case 'b':
		htdocs = EARGF(usage());
		break;
	default:
		usage();
	} ARGEND;

	bind(htdocs, "/", MBEFORE);

	len = read(0, buf, 511);
	buf[len] = '\0';
	path = strrchr(buf, '\r');
	if(path != nil) {
		*path = '\0';
	} else {
		path = strrchr(buf, '\n');
		if(path != nil)
			*path = '\0';
	}

	if(!strncmp(buf, "URL:", 4)) {
		fprint(1, htredir, buf + 4, buf + 4, buf + 4);
		exits(0);
	}

	path = nil;
	dir = dirstat(buf);
	if(dir != nil) {
		if(dir->qid.type & QTDIR)
			path = smprint("%s/index.gph", buf);
		free(dir);
	} else {
		path = strdup("/index.gph");
	}
	if(path == nil)
		path = strdup(buf);

	fp = open(path, OREAD);
	if(fp > 0) {
		len = 0;
		while(functions[++len].ext != nil) {
			if(!cistrncmp(functions[len].ext, path + strlen(path) -
					3, 3) && functions[len].f != nil) {
				(functions[len].f)(1, path, fp);
				break;
			}
		}
		if(functions[len].ext == nil)
			(functions[0].f)(1, path, fp);
		close(fp);
	} else
		write(1, erro, strlen(erro));
	free(path);

	exits(0);
}

