/*
 * Copy me, if you can.
 * by 20h
 */

#include <u.h>
#include <libc.h>
#include "ind.h"

char *
readline(int fp)
{
	char *ret;
	int len, stat;

	len = -1;
	ret = realloc(nil, 1);

	while((stat = read(fp, &ret[++len], 1)) > 0 && ret[len] != '\n')
		ret = realloc(ret, len + 2);
	ret[len] = '\0';

	if(stat <= 0) {
		free(ret);
		return nil;
	}

	return ret;
}

void
freeelem(Elems *e)
{
	if(e != nil) {
		if(e->e != nil) {
			while(--e->num >= 0)
				if(e->e[e->num] != nil)
					free(e->e[e->num]);
			free(e->e);
		}
		free(e);
	}
}

void
freeindex(Indexs *i)
{
	if(i != nil) {
		if(i->n != nil) {
			while(--i->num >= 0)
				if(i->n[i->num] != nil)
					freeelem(i->n[i->num]);
			free(i->n);
		}
		free(i);
	}
}

void
addelem(Elems *e, char *s)
{
	e->num++;
	e->e = realloc(e->e, sizeof(char *) * e->num);
	e->e[e->num - 1] = malloc(strlen(s) + 1);
	strcpy(e->e[e->num - 1], s);
}

Elems *
getadv(char *str)
{
	char *b, *e;
	Elems *ret;

	b = str;
	e = strchr(b, '[');
	if(e == nil)
		return nil;
	b = e + 1;

	ret = mallocz(sizeof(Elems), 2);
	while((e = strchr(b, '|')) != nil) {
		*e = '\0';
		e++;
		addelem(ret, b);
		b = e;
	}

	e = strchr(b, ']');
	if(e != nil) {
		*e = '\0';
		addelem(ret, b);
	}
	if(ret->e == nil) {
		free(ret);
		return nil;
	}

	return ret;
}

Indexs *
scanfile(char *fname)
{
	int fp;
	char *ln;
	Indexs *ret;
	Elems *el;

	fp = open(fname, OREAD);
	if(fp < 0)
		return nil;

	ret = mallocz(sizeof(Indexs), 2);
	if(ret == nil) {
		close(fp);
		return nil;
	}

	while(fp) {
		ln = readline(fp);
		if(ln == nil)
			break;

		el = getadv(ln);
		free(ln);
		if(el == nil)
			continue;

		ret->num++;
		ret->n = realloc(ret->n, sizeof(Elems) * ret->num);
		ret->n[ret->num - 1] = el;
	}
	close(fp);
	if(ret->n == nil) {
		free(ret);
		return nil;
	}

	return ret;
}

