/*
 * Copy me if you can.
 * by 20h
 */

#define FUSE_USE_VERSION 26

#include <fuse.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>
#include "ind.h"
#include "sdb.h"
#include "proto.h"
#include "download.h"

sdb *db;

static int
gopendir(const char *path, struct fuse_file_info *fi)
{
	int res;
	sdbe *e;

	res = 0;

	e = getelem(db, (char *)path, nil);
	if(e == nil)
		return ~ENOENT;	

	return 0;
}


static int
ggetattr(const char *path, struct stat *stbuf)
{
	int res;
	sdbe *e;

	res = 0;

	memset(stbuf, 0, sizeof(struct stat));
	if(!strcmp(path, "/")) {
		stbuf->st_mode = S_IFDIR | 0755;
		stbuf->st_nlink = 1;
	} else {
		e = getelem(db, (char *)path, nil);
		if(e == nil)
			return ~ENOENT;
		if(e->v[0] == '1') {
			stbuf->st_mode = S_IFDIR | 0444;
			stbuf->st_nlink = 1;
		} else 
			stbuf->st_mode = S_IFREG | 0444;
	}

	return res;
}

static int
greaddir(const char *path, void *buf, fuse_fill_dir_t filler, off_t offset,
			struct fuse_file_info *fi)
{
	sdbe *e;
	char *v, *d;

	e = nil;

	filler(buf, ".", 0, 0);
	filler(buf, "..", 0, 0);

	e = getelem(db, (char *)path, e);
	if(e == nil)
		return 0;

        if(checkcache(db, e->k) == 1)
                if(rnpggopher(e->v + sizeof(char) + sizeof(time_t), db, e->k,
                                -1) < 0)
                        return 0;

	for(; e != nil; e = getelem(db, (char *)path, e)) {
		if(!strcmp(e->k, (char *)path))
			continue;
		if(strchr(e->k + strlen(path) + 1, '/'))
			continue;
		v = gmemdup(e->k, strlen(e->k) + 1);
		d = strrchr(v, '/');
		if(d == nil)
			continue;
		*d++ = '\0';
		filler(buf, d, 0, 0);
		free(v);
	}  

	return 0;
}

static int
gopen(const char *path, struct fuse_file_info *fi)
{

        if(checkqueue(db, (char *)path) < 0)
                if(downloadfile(db, (char *)path) < 0)
                        return ~ENOENT;

	fi->direct_io = 1;

	return 0;
}

static int
gread(const char *path, char *buf, size_t size, off_t offset,
		struct fuse_file_info *fi)
{

	return getbytes(db, (char *)path, buf, size, offset);
}

static struct fuse_operations goper = {
	.getattr = ggetattr,
	.readdir = greaddir,
	.opendir = gopendir,
	.open = gopen,
	.read = gread,
};

int
main(int argc, char *argv[])
{
	char *server, *port;
	int res;

	db = createdb();

	if(argc > 1) {
		server = gmemdup(argv[1], strlen(argv[1]) + 1);
		port = strchr(server, ':');
		if(port == nil)
			port = "70";
		else
			*port++ = '\0';

		adddbentry(db, '1', "", "", "", server, port);

		argc--;
		argv++;
	}		

	res = fuse_main(argc, argv, &goper, nil);

	destroydb(db);

	return res;
}

