/* resources.h
   xgopher application resources and program options.  Also
   function header for resources.c */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/

#ifndef RESOURCES_H
#define RESOURCES_H

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

/* for the showLevel type... */
#include "gui.h"



typedef struct {
	Boolean		defaultsInstalled;
	String		resourcesVersion;
	String		rootServer;
	int		rootPort;
	String		mainTitle;
	String		rootPath;
	String		helpFile;
	String		bookmarkFile;
	Boolean		allowSave;
	Boolean		allowPrint;
	Boolean		allowTelnet;
	Boolean		allowTn3270;
	Boolean		allowBookmarkSave;
	Boolean		allowCopy;
	Boolean		allowImage;
	Boolean		hasSound;
	String		printCommand;
	String		imageCommand;
	String		soundCommand;
	String		telnetCommand;
	String		tn3270Command;
	String		imageServers;
	String		soundServers;
	String		textServers;
	Boolean		appendBookmarks;
	Boolean		loadBookmarks;
	Boolean		resetOptions;
	Boolean		optionsButton;
	Boolean		singleItemButton;
	Boolean		swapRestartAndQuit;
	Boolean		restartButton;
	Boolean		dirHistory;
	Boolean		nameText;
	Boolean		commonText;
	Boolean		allowFtp;
	Boolean		publicMode;
	Boolean		statusWindow;
	int		showItems;
	int		concurrentText;
	Boolean		allowHold;
	int		directoryTime;
	int		itemStart;
	int		itemIncrement;
	int		dirStart;
	int		dirIncrement;
	Boolean		warpCursor;
	Boolean		doubleClick;
	Boolean		markRoot;
	String		extendedTypes;
	String		tempDirectory;
	String		logFile;
	String		prefixFile;
	String		prefixDir;
	String		prefixTelnet;
	String		prefixTn3270;
	String		prefixCSO;
	String		prefixIndex;
	String		prefixBinary;
	String		prefixImage;
	String		prefixSound;
	String		prefixUnknown;
	String		infoDirLabel;
	String		markDirLabel;
	} gopherAppResources, *gopherAppResourcesP;


/* conf.h contains the default values for many of the resources */

#include "conf.h"

#define GOffset(x) XtOffset(gopherAppResourcesP, x)

static XtResource resources[] = {
    {"defaultsInstalled", "DefaultsInstalled", XtRBoolean, sizeof(Boolean),
		GOffset(defaultsInstalled), XtRImmediate, (XtPointer) False},
    {"resourcesVersion", "ResourcesVersion", XtRString, sizeof(String),
		GOffset(resourcesVersion), XtRString, "Unknown, pre-1.3"},
    {"rootServer", "RootServer", XtRString, sizeof(String),
		GOffset(rootServer), XtRString, ROOT_SERVER},
    {"rootPort", "RootPort", XtRInt, sizeof(int),
		GOffset(rootPort), XtRImmediate, (XtPointer) ROOT_PORT},
    {"mainTitle", "MainTitle", XtRString, sizeof(String),
		GOffset(mainTitle), XtRString, MAIN_TITLE},
    {"rootPath", "RootPath", XtRString, sizeof(String),
		GOffset(rootPath), XtRString, ROOT_PATH},
    {"allowSave", "AllowSave", XtRBoolean, sizeof(Boolean),
		GOffset(allowSave), XtRImmediate, (XtPointer) ALLOW_SAVE},
    {"allowCopy", "AllowCopy", XtRBoolean, sizeof(Boolean),
		GOffset(allowCopy), XtRImmediate, (XtPointer) ALLOW_COPY},
    {"allowPrint", "AllowPrint", XtRBoolean, sizeof(Boolean),
		GOffset(allowPrint), XtRImmediate, (XtPointer) ALLOW_PRINT},
    {"allowTn3270", "AllowTn3270", XtRBoolean, sizeof(Boolean),
		GOffset(allowTn3270), XtRImmediate, (XtPointer) ALLOW_TN3270},
    {"printCommand", "PrintCommand", XtRString, sizeof(String),
		GOffset(printCommand), XtRString, PRINT_COMMAND},
    {"helpFile", "HelpFile", XtRString, sizeof(String),
		GOffset(helpFile), XtRString, HELP_FILE},
    {"bookmarkFile", "BookmarkFile", XtRString, sizeof(String),
		GOffset(bookmarkFile), XtRString, BOOKMARK_FILE},
    {"imageServers", "Servers", XtRString, sizeof(String),
		GOffset(imageServers), XtRString, ""},
    {"soundServers", "Servers", XtRString, sizeof(String),
		GOffset(soundServers), XtRString, ""},
    {"textServers", "Servers", XtRString, sizeof(String),
		GOffset(textServers), XtRString, ""},
    {"allowBookmarkSave", "AllowBookmarkSave", XtRBoolean, sizeof(Boolean),
		GOffset(allowBookmarkSave), XtRImmediate,
		(XtPointer) ALLOW_BOOKMARK_SAVE},
    {"appendBookmarks", "AppendBookmarks", XtRBoolean, sizeof(Boolean),
		GOffset(appendBookmarks), XtRImmediate,
		(XtPointer) APPEND_BOOKMARKS},
    {"swapRestartAndQuit", "SwapRestartAndQuit", XtRBoolean, sizeof(Boolean),
		GOffset(swapRestartAndQuit), XtRImmediate,
		(XtPointer) SWAP_RESTART_QUIT},
    {"restartButton", "RestartButton", XtRBoolean, sizeof(Boolean),
		GOffset(restartButton), XtRImmediate,
		(XtPointer) RESTART_BUTTON},
    {"optionsButton", "OptionsButton", XtRBoolean, sizeof(Boolean),
		GOffset(optionsButton), XtRImmediate,
		(XtPointer) OPTIONS_BUTTON},
    {"singleItemButton", "SingleItemButton", XtRBoolean, sizeof(Boolean),
		GOffset(singleItemButton), XtRImmediate,
		(XtPointer) SINGLE_ITEM_BUTTON},
    {"showItems", "ShowItems", XgRShowLevel, sizeof(int),
		GOffset(showItems), XtRImmediate, (XtPointer) showAll},
    {"allowFtp", "AllowFtp", XtRBoolean, sizeof(Boolean),
		GOffset(allowFtp), XtRImmediate, (XtPointer) ALLOW_FTP},
    {"publicMode", "PublicMode", XtRBoolean, sizeof(Boolean),
		GOffset(publicMode), XtRImmediate, (XtPointer) PUBLIC_MODE},
    {"statusWindow", "StatusWindow", XtRBoolean, sizeof(Boolean),
		GOffset(statusWindow), XtRImmediate, (XtPointer) STATUS_WINDOW},
    {"dirHistory", "DirHistory", XtRBoolean, sizeof(Boolean),
		GOffset(dirHistory), XtRImmediate, (XtPointer) DIR_HISTORY},
    {"nameText", "NameText", XtRBoolean, sizeof(Boolean),
		GOffset(nameText), XtRImmediate, (XtPointer) NAME_TEXT},
    {"commonText", "CommonText", XtRBoolean, sizeof(Boolean),
		GOffset(commonText), XtRImmediate, (XtPointer) COMMON_TEXT},
    {"concurrentText", "ConcurrentText", XtRInt, sizeof(int),
		GOffset(concurrentText), XtRImmediate,
		(XtPointer)CONCURRENT_TEXT},
    {"allowHold", "AllowHold", XtRBoolean, sizeof(Boolean),
		GOffset(allowHold), XtRImmediate, (XtPointer) ALLOW_HOLD},
    {"directoryTime", "DirectoryTime", XtRInt, sizeof(int),
		GOffset(directoryTime), XtRImmediate,
		(XtPointer)DIRECTORY_TIME},
    {"allowImage", "AllowImage", XtRBoolean, sizeof(Boolean),
		GOffset(allowImage), XtRImmediate, (XtPointer) ALLOW_IMAGE},
    {"imageCommand", "ImageCommand", XtRString, sizeof(String),
		GOffset(imageCommand), XtRString, IMAGE_COMMAND},
    {"hasSound", "HasSound", XtRBoolean, sizeof(Boolean),
		GOffset(hasSound), XtRImmediate, (XtPointer) HAS_SOUND},
    {"soundCommand", "SoundCommand", XtRString, sizeof(String),
		GOffset(soundCommand), XtRString, SOUND_COMMAND},
    {"allowTelnet", "AllowTelnet", XtRBoolean, sizeof(Boolean),
		GOffset(allowTelnet), XtRImmediate, (XtPointer) ALLOW_TELNET},
    {"telnetCommand", "TelnetCommand", XtRString, sizeof(String),
		GOffset(telnetCommand), XtRString, TELNET_COMMAND},
    {"tn3270Command", "Tn3270Command", XtRString, sizeof(String),
		GOffset(tn3270Command), XtRString, TN3270_COMMAND},
    {"loadBookmarks", "LoadBookmarks", XtRBoolean, sizeof(Boolean),
		GOffset(loadBookmarks), XtRImmediate,
		(XtPointer) LOAD_BOOKMARKS},
    {"resetOptions", "ResetOptions", XtRBoolean, sizeof(Boolean),
		GOffset(resetOptions), XtRImmediate,
		(XtPointer) RESET_OPTIONS},
    {"itemStart", "ItemStart", XtRInt, sizeof(int),
		GOffset(itemStart), XtRImmediate, (XtPointer) ITEMS_TO_START},
    {"itemIncrement", "ItemIncrement", XtRInt, sizeof(int),
		GOffset(itemIncrement), XtRImmediate,
		(XtPointer) ITEMS_TO_ADD},
    {"dirStart", "DirStart", XtRInt, sizeof(int),
		GOffset(dirStart), XtRImmediate, (XtPointer) DIRS_TO_START},
    {"dirIncrement", "DirIncrement", XtRInt, sizeof(int),
		GOffset(dirIncrement), XtRImmediate, (XtPointer) DIRS_TO_ADD},
    {"warpCursor", "WarpCursor", XtRBoolean, sizeof(Boolean),
		GOffset(warpCursor), XtRImmediate, (XtPointer) WARP_CURSOR},
    {"doubleClick", "DoubleClick", XtRBoolean, sizeof(Boolean),
		GOffset(doubleClick), XtRImmediate, (XtPointer) DOUBLE_CLICK},
    {"markRoot", "MarkRoot", XtRBoolean, sizeof(Boolean),
		GOffset(markRoot), XtRImmediate, (XtPointer) MARK_ROOT},
    {"extendedTypes", "ExtendedTypes", XtRString, sizeof(String),
		GOffset(extendedTypes), XtRString, ""},
    {"tempDirectory", "TempDirectory", XtRString, sizeof(String),
		GOffset(tempDirectory), XtRString, TEMP_DIRECTORY},
    {"logFile", "LogFile", XtRString, sizeof(String),
		GOffset(logFile), XtRImmediate, NULL},
    {"prefixFile", "PrefixFile", XtRString, sizeof(String),
		GOffset(prefixFile), XtRString, PREFIX_FILE},
    {"prefixDir", "PrefixDir", XtRString, sizeof(String),
		GOffset(prefixDir), XtRString, PREFIX_DIR},
    {"prefixTelnet", "PrefixTelnet", XtRString, sizeof(String),
		GOffset(prefixTelnet), XtRString, PREFIX_TELNET},
    {"prefixTn3270", "PrefixTn3270", XtRString, sizeof(String),
		GOffset(prefixTn3270), XtRString, PREFIX_TN3270},
    {"prefixCSO", "PrefixCSO", XtRString, sizeof(String),
		GOffset(prefixCSO), XtRString, PREFIX_CSO},
    {"prefixIndex", "PrefixIndex", XtRString, sizeof(String),
		GOffset(prefixIndex), XtRString, PREFIX_INDEX},
    {"prefixBinary", "PrefixBinary", XtRString, sizeof(String),
		GOffset(prefixBinary), XtRString, PREFIX_BINARY},
    {"prefixImage", "PrefixImage", XtRString, sizeof(String),
		GOffset(prefixImage), XtRString, PREFIX_IMAGE},
    {"prefixSound", "PrefixSound", XtRString, sizeof(String),
		GOffset(prefixSound), XtRString, PREFIX_SOUND},
    {"prefixUnknown", "PrefixUnknown", XtRString, sizeof(String),
		GOffset(prefixUnknown), XtRString, PREFIX_UNKNOWN},
    {"infoDirectoryLabel", "Label", XtRString, sizeof(String),
		GOffset(infoDirLabel), XtRString, "Info about\nDirectory"},
    {"markDirectoryLabel", "Label", XtRString, sizeof(String),
		GOffset(markDirLabel), XtRString, "Mark\nDirectory"},
    };

#undef GOffset

void			saveChangableResources(
#ifdef PROTO
				gopherAppResourcesP	/* arP */
#endif
);

void			restoreChangableResources(
#ifdef PROTO
				gopherAppResourcesP	/* arP */
#endif
);

gopherAppResources	*getApplicationResources(
#ifdef PROTO
				Widget,		/* topLevel */
				int,		/* argc */
				char **		/* argv */
#endif
);

#endif   /* RESOURCES_H */
