/* osdep.h
   try to isolate operating system and environment dependencies. */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.3     08 April 1993                  */
     /*                version 1.2     20 November 1992               */
     /*                version 1.1     20 April 1992                  */
     /*                version 1.0     04 March 1992                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992, 1993 by                                       */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


/* This file would be mostly unnecessary if everyone was running X11R5,
   where the file <Xos.h> is pretty decent.  But, X11R4's <Xos.h> is
   not sufficient to solve the OS dependencies.
*/

#ifndef OSDEP_H
#define OSDEP_H

/*======================================================================*/
/* getenv() is in stdlib.h =============================================*/
/*======================================================================*/

#if defined(SYSV) || defined(SVR4)
#include <stdlib.h>
#else
char	*getenv();
#endif

/*======================================================================*/
/* get string/strings and open(2) values ===============================*/
/* by using MIT's logic from the R5 distribution of X11 ================*/
/* R4 is pretty broken, so I can't use that one ========================*/
/*======================================================================*/
#include "MIT-Xos.h"

/*======================================================================*/
/* binary copy header files ============================================*/
/*======================================================================*/

#if defined(SYSV) || defined(SVR4)
#ifndef bcopy
#define bcopy(s,d,n)	memcpy((d),(s),(n))
#endif
#ifndef bzero
#define bzero(s,n)	memset((s), 0, (n))
#endif
#endif

/*======================================================================*/
/* get working directory path name =====================================*/
/*======================================================================*/

#if defined(SYSV) || defined(SVR4)
#include "conf.h"	/* for PATH_NAME_LEN */
#include <unistd.h>	/* declaration of getcwd */
#define getwd(d)	getcwd((d), PATH_NAME_LEN)
#else
	char	*getwd();
#endif


/*======================================================================*/
/* try to find malloc's declaration ====================================*/
/*======================================================================*/

#if defined(_POSIX_SOURCE) || !defined(NOSTDHDRS)
#  if !defined(sequent) && !defined(Mips)
#include <stdlib.h>
#  else /* sequent/Mips */
char	*malloc();
char	*realloc();
#  endif
#else
#  if !defined(NeXt) && !defined(sequent) && !defined(__bsdi__) && !defined(unix)
#include <malloc.h>
#  else 
char	*malloc();
char	*realloc();
#  endif
#endif

/*======================================================================*/
/* pid type ============================================================*/
/*======================================================================*/

#if     !defined(SYSV) && !defined(__convex__) && !defined(__bsdi__) && !defined(linux)
#define		PID_TYPE	int
#ifdef ISCX	/** for ISC 3.0 + ISC's X11R4 package */
#define		WNOHANG		1
#endif
#else
	/* <sys/file.h> was included by the earlier section for open(2)
	   constants, but would otherwise need to be included here. */
#define		PID_TYPE	pid_t
#endif                          /* !defined(SYSV) */

/*======================================================================*/
/* popon declaration ===================================================*/
/*======================================================================*/

#if      defined(sequent)

	/* this is supposed to be defined in <stdio.h>, but
	   it turns up missing on some machines - like the sequent */
#include <stdio.h>
	FILE		*popen();
#endif


#endif /* OSDEP_H */
