package PGopherLib::VT100;

use strict;
use warnings;
use PGopherLib::Globals qw/$dumb/;

require Exporter;
our @ISA = qw(Exporter);
our %EXPORT_TAGS = ('const' => [qw(BOLD UNDER BLINK REVERSE)]);
our @EXPORT_OK = (@{$EXPORT_TAGS{'const'}}, qw(attr cls clreol hidecur
	showcur curpos appkeys));

use constant {
    BOLD => 1,
    UNDER => 4,
    BLINK => 5,
    REVERSE => 7
};


sub attr { return (!$dumb ? "\033[" . join(';', 0, @_) . "m" : ""); }
sub cls { !$dumb and print "\033[H\033[2J"; }
sub clreol { !$dumb and print "\033[K"; }
sub hidecur { !$dumb and print "\033[?25l"; }
sub showcur { !$dumb and print "\033[?25h"; }
sub curpos { !$dumb and print "\033[$_[0];$_[1]H"; }
sub appkeys { !$dumb and print (shift() ? "\033[?1h" : "\033[?1l"); }

1;
