package PGopherLib::TTY;

use strict;
use warnings;
use POSIX ();
use PGopherLib::Globals qw/$TERMSIZE $rows $cols $dumb/;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(oldtty newtty getwinsize ttyinit);

my ($oldtty, $newtty);

my $dowinsize = 0;


sub oldtty { !$dumb and $oldtty->setattr(0, &POSIX::TCSANOW); }
sub newtty { $newtty->setattr(0, &POSIX::TCSANOW); }

sub getwinsize {
    my $first = shift;
    !$first and !$dowinsize and return 0;
    my $TIOCGWINSZ =
	    ($^O eq "linux") ? 0x5413 :
	    ($^O eq "solaris") ? ord('T') * 256 + 104 :
	    0x40087468;
    my $winsize = pack("S4", 0, 0, 0, 0);
    ioctl(STDIN, $TIOCGWINSZ, $winsize) or return 0;
    ($rows, $cols) = unpack("SS", $winsize);
    return 1;
}

sub ttyinit {
    if (defined($TERMSIZE)) {
	($cols, $rows) = ($TERMSIZE =~ /^(\d+)x(\d+)$/) or
		die "Invalid format of \$TERMSIZE string\n";
    } else {
	getwinsize(1) or die "Can't get terminal size; " .
		"you need to define \$TERMSIZE in your .pgopherrc\n";
	$dowinsize++;
    }

    ($oldtty, $newtty) = (POSIX::Termios->new(), POSIX::Termios->new());
    $newtty->getattr(0) or die "getattr: $!\n";
    $dumb and return;
    $oldtty->getattr(0) or die "getattr: $!\n";
    $newtty->setiflag($newtty->getiflag() & ~&POSIX::ICRNL);
    # ECHOCTL
    $^O =~ /bsd$/ and $newtty->setlflag($newtty->getlflag() & ~0x40);
    $newtty->setcc(&POSIX::VEOL, 015);
    newtty or die "setattr: $!\n";
}

1;
