package PGopherLib::Main;

use strict;
use warnings;
no warnings 'exec';
use Encode qw/from_to/;
use PGopherLib::Globals qw/$DEFHOST $PAGER $HTMLVIEW $PDFVIEW $IMGVIEW
	$SNDPLAY $MOVPLAY $PHBOOK $TELNET $TN3270 $PRINTCMD $DLDIR
	$BOOKMARKS $PROMPT $TEXTENC @history @menu $user $rows $cols
	$sigint $sigpipe $utf8 $dumb/;
use PGopherLib::Init qw/init quit/;
use PGopherLib::Misc qw/msg prompt errmsg mysystem myconnect isutf8
	escape unescape splithpts getbookmark help menu/;
use PGopherLib::TTY qw/newtty oldtty/;
use PGopherLib::VT100 qw/cls appkeys/;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(main);

my %cmd = (
    'h' => \$HTMLVIEW,
    'P' => \$PDFVIEW,
    'g' => \$IMGVIEW,
    'I' => \$IMGVIEW,
    's' => \$SNDPLAY,
    ';' => \$MOVPLAY,
    '2' => \$PHBOOK,
    '8' => \$TELNET,
    'T' => \$TN3270
);


sub doit {
    my ($type, $desc, $sel, $host, $port);

    my $input = (shift =~ /^\s*(.*?)\s*$/)[0];

    SWITCH: {
	$input eq "" and return;
	$input =~ /^[Qq]$/ and quit;
	$input eq "!" and return do {cls; mysystem($ENV{'SHELL'})};
	$input =~ /^[Hh]$/ and return help;
	$input =~ /^\?\d*$/ and do {
	    if ($input =~ /\d/) {
		scalar(@menu) or return;
		my $n = substr($input, 1);
		$n < 1 || $n > scalar(@menu) and
			return errmsg "invalid entry";
		($type, $desc, $sel, $host, $port) = @{$menu[$n - 1]};
	    } else {
		scalar(@history) or return;
		($type, $desc, $sel, $host, $port) =
			@{$history[$#history]};
	    }
	    prompt "$host:$port/$type$sel ";
	    return;
	};
	$input =~ /^[dp]?\d+$/ and do {
	    scalar(@menu) or return;
	    my $n = ($input =~ /^[dp]?(\d+)$/)[0];
	    $n < 1 || $n > scalar(@menu) and
		    return errmsg "invalid entry";
	    ($type, $desc, $sel, $host, $port) = @{$menu[$n - 1]};
	    $type =~ /[3i]/ and return errmsg "not a selectable item";
	    if ($input =~ /^d/) {
		$type =~ /[1278T]/ and
			return errmsg "not a downloadable item";
	    } elsif ($input =~ /^p/) {
		$PRINTCMD eq "" and return;
		$type ne "0" and return errmsg "not a printable item";
	    }
	    last;
	};
	$input eq "." and do {
	    scalar(@history) or return;
	    ($type, $desc, $sel, $host, $port) = @{$history[$#history]};
	    last;
	};
	$input eq "," and do {
	    scalar(@history) < 2 and return;
	    pop @history;
	    ($type, $desc, $sel, $host, $port) = @{$history[$#history]};
	    last;
	};
	$input eq "b" and do {
	    ($type, $desc, $sel, $host, $port) = getbookmark or return;
	    $type ne "1" and $input = 1;
	    last;
	};
	$input =~ /^B\d*$/ and do {
	    if ($input =~ /\d/) {
		scalar(@menu) or return;
		my $n = substr($input, 1);
		$n < 1 || $n > scalar(@menu) and
			return errmsg "invalid entry";
		($type, $desc, $sel, $host, $port) = @{$menu[$n - 1]};
	    } else {
		scalar(@history) or return;
		($type, $desc, $sel, $host, $port) =
			@{$history[$#history]};
	    }
	    ($desc = prompt("Description: ")) eq "" and
	    	    $desc = "$host:$port/$type$sel";
	    open(FILE, ">>$BOOKMARKS") or return errmsg "open: $!";
	    $utf8 and binmode FILE, ':utf8';
	    my $tmp = "$desc\t$host";
	    SWITCH: {
		$type eq "2" and do
			{$port != 105 and $tmp .= ":$port"; last};
		$type =~ /[8T]/ and do
			{$port != 23 and $tmp .= ":$port"; last};
		$port != 70 and $tmp .= ":$port";
	    }
	    ($type ne "1" or $sel ne "") and $tmp .= "/$type$sel";
	    print FILE "$tmp\n";
	    close(FILE);
	    return;
	};
	$desc = "";
	($host, $port, $type, $sel) = splithpts(unescape($input)) or
		return errmsg "invalid entry";
	$type ne "1" and $input = 1;
    }

    $type eq "7" and $sel !~ /\t/ and do {
	(my $query = prompt("Query: ")) eq "" and return;
	$sel .= "\t$query";
    };

    my $sock;
    $type !~ /[28T]/ and do {
	msg "Getting data... " . ($dumb ? "\n" : "");
	$sock = myconnect($host, $port) or return;
	binmode $sock;
	select($sock); $| = 1; print $sock "$sel\r\n"; select(STDOUT);
    };

    ACTION: {
	if ($type =~ /[17]/) {
	    my @tmenu = ();
	    $sigint = 0;
	    while (<$sock>) {
		s/[\r\n]+$//;
		$_ eq "." and last;
		my ($desc, $sel, $host, $port) = split(/\t/);
		my $type = substr($desc, 0, 1);
		$desc = substr($desc, 1);
		$desc =~ s/[\x80-\x9f]//g;
		$type eq "+" and do {
		    scalar(@tmenu) or last;
		    my @tmp = ($host, $port);
		    ($type, $desc, $sel, $host, $port) =
			    @{$tmenu[$#tmenu]};
		    ($host, $port) = @tmp;
		};
		$sigint and last ACTION;
		push @tmenu, [$type, $desc, $sel, $host, $port];
	    }
	    @menu = @tmenu;
	    if ($input ne "." and $input ne ",") {
		push @history, [$type, $desc, $sel, $host, $port];
		scalar(@history) > 100 and splice(@history, 0, 1);
	    }
	} else {
	    my $fname;
	    if ($type eq "h" and $sel =~ /^URL:/) {
		$fname = "redirect.html";
	    } else {
		my $delim = ($sel =~ /\//) ? '/' :
			($sel =~ /\\/) ? '\\' :
			($sel =~ /:/) ? ':' :
			'/';
		$fname = (unescape($sel) =~
			/^(.*[\Q$delim\E])?(.*)$/)[1];
		$fname ||= "dummy";
	    }
	    SWITCH: {
		$type eq "0" and do {
		    my $file;
		    if ($input =~ /^d/) {
			open(FILE, '>', "$DLDIR/$fname") or do
				{errmsg "open: $!"; last ACTION};
			binmode FILE;
			$file = \*FILE;
			msg "Saving file `$fname'... " .
				($dumb ? "\n" : "");
		    } else {
			$input !~ /^p/ and do {cls; oldtty; appkeys 1};
			open(PIPE, "|" . ($input =~ /^p/ ? $PRINTCMD :
				$PAGER)) or do {
			    $input !~ /^p/ and do {newtty; appkeys 0};
			    errmsg "open: $!";
			    last ACTION;
			};
			binmode PIPE;
			$file = \*PIPE;
			$input =~ /^p/ and
				msg "Printing file `$fname'... " .
					($dumb ? "\n" : "");
		    }
		    $sigint = $sigpipe = 0;
		    while (<$sock>) {
			s/[\r\n]+$//;
			$_ eq "." and last;
			s/^\.//;
			$utf8 and $input !~ /^[dp]/ and (isutf8($_) or
				from_to($_, $TEXTENC, "utf-8"));
			last if $sigint || $sigpipe;
			print $file $_ . ($input =~ /^p/ ? "\r\n" :
				"\n");
		    }
		    close($file);
		    if ($input =~ /^d/) {
			$sigint and unlink "$DLDIR/$fname";
		    } elsif ($input !~ /^p/) {
			newtty; appkeys 0;
			$PAGER !~ /^less\s*/ and
				prompt "Press RETURN to continue ";
		    }
		    last;
		};
		$type =~ /[hPgIs;]/ and do {
		    open(FILE, '>', "$DLDIR/$fname") or do
			    {errmsg "open: $!"; last ACTION};
		    binmode FILE;
		    $input =~ /^d/ and msg "Saving file `$fname'... " .
			    ($dumb ? "\n" : "");
		    $sigint = 0;
		    print FILE while (read($sock, $_, 8192) and
			    ! $sigint);
		    close(FILE);
		    $sigint and do
			    {unlink "$DLDIR/$fname"; last ACTION};
		    if ($input =~ /^\d/) {
			my $cmd = ${$cmd{$type}}; $cmd eq "" and last;
			msg $PROMPT;
			my $r = mysystem($cmd . ($type eq "h" ?
				" file://" . escape("$DLDIR/$fname") :
				" '$DLDIR/$fname'"));
			unlink "$DLDIR/$fname";
			$r == -1 and do
				{errmsg "system: $!"; last ACTION};
		    }
		    last;
		};
		$type =~ /[28T]/ and do {
		    my $cmd = ${$cmd{$type}}; $cmd eq "" and last;
		    $cmd =~ s/%HOST%/$host/; $cmd =~ s/%PORT%/$port/;
		    $type eq "8" and do {
		    	my $login = ($sel or $user);
			$cmd =~ s/%LOGIN%/$login/;
		    };
		    cls;
		    mysystem($cmd) == -1 and do
			    {errmsg "system: $!"; last ACTION};
		    print "\n";
		    prompt "Press RETURN to continue ";
		    last;
		};
		open(FILE, '>', "$DLDIR/$fname") or do
			{errmsg "open: $!"; last ACTION};
		binmode FILE;
		msg "Saving file `$fname'... " . ($dumb ? "\n" : "");
		$sigint = 0;
		print FILE while (read($sock, $_, 8192) and ! $sigint);
		close(FILE);
		$sigint and unlink "$DLDIR/$fname";
	    }
	}
    }

    $type !~ /[28T]/ and close($sock);
}

sub main {
    init;
    cls;
    doit (scalar(@ARGV) ? $ARGV[0] : $DEFHOST);
    while (1) {
	menu;
	doit prompt($PROMPT);
    }
}

1;
