package PGopherLib::Init;

use strict;
use warnings;
use Getopt::Std;
use Encode ();
use PGopherLib::Globals qw/$DEFHOST $PAGER $HTMLVIEW $PDFVIEW $IMGVIEW
	$SNDPLAY $MOVPLAY $PHBOOK $TELNET $TN3270 $PRINTCMD $DLDIR
	$BOOKMARKS $PROMPT $TEXTENC $TERMSIZE $user $sigint $sigpipe
	$sigwinch $utf8 $dumb/;
use PGopherLib::TTY qw/ttyinit oldtty newtty/;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(quit init);

my $RCFILE = $ENV{'HOME'} . "/.pgopherrc";


sub quit {
    print "\n";
    oldtty;
    exit;
}

sub sigtstp_handler {
    oldtty;
    $SIG{'TSTP'} = 'DEFAULT';
    kill 'TSTP', $$;
}

sub sigcont_handler {
    newtty;
    $SIG{'TSTP'} = \&sigtstp_handler;
}

sub noempty {
    die shift() . " can't be an empty string in $RCFILE\n";
}

sub usage {
    my $cmd = ($0 =~ m#^(?:.*/)?(.*)$#)[0];
    die "usage: $cmd [-d] [host[:port][/type[selector]]]\n";
}

sub init {
    $| = 1;

    grep(/^utf8$/, PerlIO::get_layers(STDIN)) and $utf8++;

    my %opts;
    getopts("d", \%opts) or usage;
    defined $opts{"d"} and $dumb++;

    -f $RCFILE and do {
	no strict 'vars';
	open(FILE, $RCFILE) or die "Couldn't open $RCFILE: $!\n";
	$utf8 and binmode FILE, ':utf8';
	my $rc;
	{ local $/ = undef; $rc = <FILE>; }
	close(FILE);
	defined(eval $rc) or die "Couldn't parse $RCFILE: $@\n";
    };

    $DEFHOST eq "" and noempty '$DEFHOST';

    $PAGER =~ /^less\s*/ and do {
	$PAGER .= " -X";
	$utf8 and $ENV{'LESSCHARSET'} = "utf-8";
    };

    $PHBOOK ne "" and ($PHBOOK =~ /%HOST%/ && $PHBOOK =~ /%PORT%/ or
	    die "Invalid format of \$PHBOOK string\n");
    $TELNET ne "" and ($TELNET =~ /%HOST%/ && $TELNET =~ /%PORT%/ or
	    die "Invalid format of \$TELNET string\n");
    $TN3270 ne "" and ($TN3270 =~ /%HOST%/ && $TN3270 =~ /%PORT%/ or
	    die "Invalid format of \$TN3270 string\n");

    $DLDIR eq "" and noempty '$DLDIR';

    $BOOKMARKS eq "" and noempty '$BOOKMARKS';

    $utf8 and do {
	$TEXTENC eq "" and noempty '$TEXTENC';
	grep(/^${TEXTENC}$/, Encode->encodings(":all")) or
		die "Unsupported encoding `$TEXTENC'\n";
    };

    $SIG{'HUP'} = \&quit;
    $SIG{'INT'} = sub { $sigint++ };
    $SIG{'PIPE'} = sub { $sigpipe++ };
    $SIG{'TERM'} = \&quit;
    $SIG{'TSTP'} = \&sigtstp_handler;
    $SIG{'CONT'} = \&sigcont_handler;
    $SIG{'WINCH'} = sub { $sigwinch++ };

    $user = getpwuid($<);

    ttyinit;
}

1;
