package PGopherLib::Globals;

use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw($DEFHOST $PAGER $HTMLVIEW $PDFVIEW $IMGVIEW $SNDPLAY
	$MOVPLAY $PHBOOK $TELNET $TN3270 $PRINTCMD $DLDIR $BOOKMARKS
	$PROMPT $TEXTENC $TERMSIZE @history @menu $user $rows $cols
	$sigint $sigpipe $sigwinch $utf8 $dumb);

our $DEFHOST = "gopher.sm5sxl.net";
our $PAGER = ($ENV{'PAGER'} || "more");
our $HTMLVIEW = "lynx";
our $PDFVIEW = "acroread";
our $IMGVIEW = "xv";
our $SNDPLAY = "xmms";
our $MOVPLAY = "mplayer";
our $PHBOOK = "ph -s %HOST% -p %PORT%";
our $TELNET = "telnet -l %LOGIN% %HOST% %PORT%";
our $TN3270 = "tn3270 %HOST% %PORT%";
our $PRINTCMD = "lpr";
our $DLDIR = $ENV{'HOME'};
our $BOOKMARKS = $ENV{'HOME'} . "/.pgopher_bookmarks";
our $PROMPT = "pgopher> ";
our $TEXTENC = "iso-8859-1";
our $TERMSIZE;

our @history = ();
our @menu = ();
our $user;
our ($rows, $cols);
our ($sigint, $sigpipe, $sigwinch) = (0, 0, 0);
our $utf8 = 0;
our $dumb = 0;

1;
