/*
 * gnopher_view class stuff
 */

#include <gtk/gtk.h>
#include <gtkhtml/gtkhtml.h>
#include <fcntl.h>
#include <stdio.h>
#include "gnopher-view.h"
#include "gnopher-location.h"

struct _GnopherViewDetails {
	char      *location;
	GtkWidget * gtkhtml;
};

char *
load_file (char * filename)
{
	FILE * file;
	char * buffer = NULL;
	int buffersize = 0, bytes_read = 0;

	file = fopen (filename, "r");
	do
	{
		buffersize += 20;

		buffer = (char *) realloc (buffer, sizeof (char) * buffersize);
		bytes_read += fread (buffer + bytes_read, sizeof(char), buffersize - bytes_read, file);
	}
	while (!feof(file) && !ferror(file));

	buffersize++;
	buffer = (char *) realloc (buffer, sizeof (char) * buffersize);
	*(buffer + bytes_read) = '\0';

	fclose (file);
	return buffer;
}

char *
load_header ()
{
	return load_file (PREFIX "/share/gnopher/themes/default/header.php");
}
char *
load_footer ()
{
	return load_file (PREFIX "/share/gnopher/themes/default/footer.php");
}

static void
on_url_cb (GtkHTML *html, const gchar *url, gpointer user_data)
{
	if (!url)
		url = "";
	nautilus_view_report_status (NAUTILUS_VIEW(user_data), url);
}

static void
link_clicked_cb (GtkHTML * html, char * url, gpointer user_data)
{
	g_printerr ("Clicked: %s\n", url);
	nautilus_view_open_location_in_this_window (NAUTILUS_VIEW(user_data), url);
}
static void
url_requested_cb (GtkHTML *html, const char *url, GtkHTMLStream *stream, gpointer data)
{
	int fd;
	gchar *filename;

	filename = g_strconcat (PREFIX "/share/gnopher/themes/default/", url, NULL);
	fd = open (filename, O_RDONLY);

	if (fd != -1) {
		#define MY_BUF_SIZE 32768
		gchar *buf;
		size_t size;

		buf = alloca (MY_BUF_SIZE);

		while ((size = read (fd, buf, MY_BUF_SIZE)) > 0)
		{
			gtk_html_stream_write (stream, buf, size);
		}

		gtk_html_stream_close (stream, size == -1 ? GTK_HTML_STREAM_ERROR : GTK_HTML_STREAM_OK);
		close (fd);
	} else
		gtk_html_stream_close (stream, GTK_HTML_STREAM_ERROR);
	g_free (filename);
}

static void
load_location_cb (NautilusView * nautilus_view,
	const char * url,
	gpointer user_data)
{
	GnopherView * view;
	GnopherLocation * location, * entry;
	GList * dirlist;
	char * string, * string1, filetype, * url2;

	g_printerr ("in callback, url is %s\n", url);

	nautilus_view_report_load_underway(nautilus_view);

	if (!strncmp (url, "gnopher:", 8))
	{
		url2 = g_strconcat("gopher:/", url + 9, NULL);

		nautilus_view_report_load_complete (nautilus_view);
		nautilus_view_report_redirect (nautilus_view, url, url2, NULL, "weet ik `t");
		nautilus_view_open_location_in_this_window (nautilus_view, url2);
		url= url + 9;
		return;
	}

	nautilus_view_report_load_underway(nautilus_view);

	/* using both pointers for both cases };-) */
	view = GNOPHER_VIEW(nautilus_view);

	location = GNOPHER_LOCATION(gnopher_location_new ());
	gnopher_location_set_url (location, url);
	gnopher_location_get_directory (location);

	dirlist = location->directory;

	string = load_header();

	g_printerr ("voor while\n");
	while (dirlist != NULL && dirlist->data != NULL)
	{
		g_printerr("whiling...\n");
		entry = GNOPHER_LOCATION(dirlist->data);

		if (entry->filetype != 'i')
		{
			string1 = g_strdup_printf (
				"%s<A HREF=\"gnopher:%c/%s/%s\">%s</A><BR>",
				string,
				entry->filetype,
				entry->server,
				entry->selector,
				entry->description
			);
		}
		else
			string1 = g_strdup_printf (
				"%s<PRE>%s</PRE>",
				string,
				entry->description
			);

		free (string);
		string = string1;

		dirlist = dirlist->next;
	}
	g_printerr ("na while\n");

	string1 = g_strdup_printf ("%s%s", string, load_footer());
	free(string);
	string = string1;

/*	gtk_label_set_text (GTK_LABEL(view->details->label), "Na callback");*/
	gtk_html_load_from_string (GTK_HTML(view->details->gtkhtml), string, strlen(string));

	nautilus_view_report_load_complete (nautilus_view);

	g_printerr ("pagina is %s\n", string);
	g_printerr ("na callback\n");
}

guint
gnopher_view_get_type (void)
{
	static guint gnopherviewtype = 0;

	if (!gnopherviewtype)
	{
		GtkTypeInfo gnopherviewinfo =
		{
			"GnopherView",
			sizeof (GnopherView),
			sizeof (GnopherViewClass),
			(GtkClassInitFunc) gnopher_view_class_init,
			(GtkObjectInitFunc) gnopher_view_init,
			(GtkArgSetFunc) NULL,
			(GtkArgGetFunc) NULL
		};
		gnopherviewtype = gtk_type_unique (NAUTILUS_TYPE_VIEW, &gnopherviewinfo);
	}

	return gnopherviewtype;
}

static void gnopher_view_class_init (GnopherViewClass * klass)
{
	GtkObjectClass *object_class;

	g_printerr ("in class init\n");
	g_assert (IS_GNOPHER_VIEW_CLASS(klass));

	object_class = GTK_OBJECT_CLASS(klass);

	object_class->destroy = gnopher_view_destroy;
	g_printerr ("uit class init\n");
}

static void gnopher_view_init (GnopherView * view)
{
	GtkAdjustment * hadj, * vadj;

	g_printerr ("in init\n");
	g_assert (IS_GNOPHER_VIEW(view));

	view->details = g_new0 (GnopherViewDetails, 1);

	view->details->gtkhtml = gtk_html_new ();
	gtk_signal_connect (GTK_OBJECT(view->details->gtkhtml),
		"url_requested",
		GTK_SIGNAL_FUNC(url_requested_cb),
		NULL
	);
	gtk_signal_connect (GTK_OBJECT(view->details->gtkhtml),
		"link_clicked",
		GTK_SIGNAL_FUNC(link_clicked_cb),
		view
	);
	gtk_signal_connect (GTK_OBJECT(view->details->gtkhtml),
		"on_url",
		GTK_SIGNAL_FUNC(on_url_cb),
		view
	);

	hadj = GTK_ADJUSTMENT(gtk_adjustment_new ( 5.0, 0.0, 10.0, 1.0, 2.0, 10.0));
	vadj = GTK_ADJUSTMENT(gtk_adjustment_new ( 5.0, 0.0, 10.0, 1.0, 2.0, 10.0));
	gtk_layout_set_hadjustment (GTK_LAYOUT(view->details->gtkhtml), hadj);
	gtk_layout_set_vadjustment (GTK_LAYOUT(view->details->gtkhtml), vadj);

	gtk_widget_show (view->details->gtkhtml);

	nautilus_view_construct (NAUTILUS_VIEW(view),
		view->details->gtkhtml);

/*	view->details->label = gtk_label_new ("Hallo fans");
	gtk_widget_show (view->details->label);

	nautilus_view_construct (NAUTILUS_VIEW(view),
		view->details->label);*/

	gtk_signal_connect (GTK_OBJECT (view),
		"load_location",
		load_location_cb,
		NULL);

	g_printerr ("uit init\n");
}

static void
gnopher_view_destroy (GtkObject *object)
{
	GnopherView *view;

	g_printerr ("in destroy\n");
	view = GNOPHER_VIEW(object);

	g_free (view->details->location);
	g_free (view->details);

	(* GTK_OBJECT_CLASS(gtk_type_class (NAUTILUS_TYPE_VIEW))->destroy) (object);
	g_printerr ("uit destroy\n");
}


