#include <gnet/gnet.h>
#include <gtk/gtk.h>

#include <string.h> /* or strings, or whatever :-) */
#include <fcntl.h>
#include <stdio.h>
#include "gnopher-location.h"

/*
 * Class functions
 */

#ifdef DEBUG
        extern GMutex * mutex;
	        extern int logcount;
#endif

guint
gnopher_location_get_type (void)
{
	static guint gnopheritemtype = 0;

	if (!gnopheritemtype)
	{
		GtkTypeInfo gnopheriteminfo =
		{
			"GnopherLocation",
			sizeof (GnopherLocation),
			sizeof (GnopherLocationClass),
			(GtkClassInitFunc) gnopher_location_class_init,
			(GtkObjectInitFunc) gnopher_location_init,
			(GtkArgSetFunc) NULL,
			(GtkArgGetFunc) NULL
		};
		gnopheritemtype = gtk_type_unique (gtk_object_get_type(), &gnopheriteminfo);
	}

	return gnopheritemtype;
}

static void gnopher_location_class_init (GnopherLocationClass * class)
{
	enum {
		CHANGED,
		LAST_SIGNAL
	};
	static guint signals[LAST_SIGNAL] = {0};

	g_printerr ("in gl class init\n");

	signals[CHANGED] = gtk_signal_new ("changed",
		GTK_RUN_FIRST,
		GTK_OBJECT_CLASS(class)->type,
		GTK_SIGNAL_OFFSET(GnopherLocationClass, changed),
		gtk_signal_default_marshaller,
		GTK_TYPE_NONE,
		0);
	gtk_object_class_add_signals (GTK_OBJECT_CLASS(class),
		signals,
		LAST_SIGNAL);

	g_printerr ("uit gl class init\n");
}

static void gnopher_location_init (GnopherLocation * child)
{}
 
GtkObject * gnopher_location_new ()
{
	return GTK_OBJECT (gtk_type_new (gnopher_location_get_type()));
}


/*
 * End of class functions
 */

GnomeVFSResult
gnopher_location_set_location (GnopherLocation * self,
	const gchar filetype,
	const gchar * description,
	const gchar * selector,
	const gchar * server,
	guint port,
	const gchar * query)
{
	gchar * url = "", * port2;

	g_printerr ("in gl set location\n");

	if (server == NULL)
		server = "localhost";

	if (selector == NULL)
		selector = "/";

	if (description == NULL)
		description = "foo";

	if (port == 0)
		port = 70;

	/* in proper use, description etc. are set together with selector
	   so we only have to check selector to see if we should free stuff */

	if (self->selector != NULL)
	{
		free (self->selector);
		free (self->description);
		free (self->server);
	}

	if (self->query != NULL)
	{
		free (self->query);
	}

	self->filetype = filetype;
	self->description = strdup(description);
	self->selector = strdup(selector);
	self->server = strdup(server);
	self->port = port;
	if (query != NULL)
	{
		self->query = g_strdup(query);
	}
	else
	{
		self->query = NULL;
	}

	port2 = g_strdup_printf (":%d", port);
	/* don't show port if it's the default */
	if (port2 = ":70")
	{
		free (port2);
		port2 = "";
	}
	
	url = g_strconcat ("gopher://", server, port2, "/", selector, NULL);
	if (self->modern_url != NULL)
	{
		free (self->modern_url);
	}
	self->modern_url = url;

	self->data = NULL;
	self->datasize = 0;
#ifdef DEBUG
	g_mutex_lock(mutex);
	fprintf (stderr, "[%u] Modern_url is now: %s\n",
		logcount,
		self->modern_url);
	fflush (stderr);
	logcount++;
	g_mutex_unlock(mutex);
#endif
	/*gtk_signal_emit_by_name (GTK_OBJECT(self), "changed");*/

	g_printerr ("uit gl set location\n");
}

void
gnopher_location_set_url (GnopherLocation * self, const gchar * url)
{
	gchar * selector, * server, * port, * description;

	g_printerr ("in gl set url\n");
	
	if (strncmp (url, "gopher://", 9) == 0)
	{
		url = url + 9;
	}
	/* find the slash delimiting the server:port and selector */
	selector = strdup (url);
	port = strsep (&selector, "/");
	if (selector == NULL)
	{
		selector = strdup("");
	}
	else
	{
		/* by lack of a better description, make it be the
		   selector (if available, else it will be the server) */
		description = selector;
	}
	server = strsep (&port, ":");
	if (port == NULL)
	{
		port = strdup ("70");
	}

	description = server;

	gnopher_location_set_location (self, '?', description, selector, server, atoi (port), NULL);
	free (selector);
	free (server);
	free (port);

	g_printerr ("uit gl set url\n");
}

/* this function currently represents the dir listing through a GList
 * of GnopherLocations, which might be a little mem-expensive, but it is kewl
 * as far as OO-stuff is concerned, I guess, so the hype being the hype,
 * to hell with it :-)
 */
 
GnomeVFSResult
gnopher_location_get_directory (GnopherLocation * self)
{
	GnomeVFSResult retval;
	gchar * list, * line;
	gchar filetype, * selector, *description, * server, * query = NULL, * port2;
	int port;
	GList * itemlist = NULL;
	GtkObject * item;

	g_printerr ("in gl get directory\n");

	retval = gnopher_location_get_raw_data (self, FALSE);
	
	if (retval != GNOME_VFS_OK)
	{
		g_printerr ("uit gl get directory [!GNOME_VFS_OK]\n");
		return retval;
	}
		
	list = self->data;

	line = strsep (&list, "\n");
	if (line != NULL)
		line = g_strchomp (line);
	while (line != NULL && (strcmp(line, ".") != 0) && (strcmp (line, "") != 0))

	{
		filetype = line[0];
		line++;
		description = strsep (&line, "\t");
		selector = strsep (&line, "\t");
		server = strsep (&line, "\t");
		port2 = strsep (&line, "\t");
		if (port2 != NULL)
			port = atoi (port2);

		item = gnopher_location_new ();
		gnopher_location_set_location (
			GNOPHER_LOCATION(item),
			filetype, description,
			selector,
			server,
			port,
			query);

		itemlist = g_list_append (itemlist, item);

		line = strsep (&list, "\n");
		if (line != NULL)
			line = g_strchomp (line);
	}

	self->directory = itemlist;
	self->wherewasi = 0;

	g_printerr ("uit gl get directory [einde functie]\n");

	return GNOME_VFS_OK;
}

gboolean
gnopher_location_set_directory (GnopherLocation * self, GList * dirlist)
{
	gchar * data = "", * port, filetype[1];
	GnopherLocation * location;

	g_printerr ("in gl set directory\n");

	filetype[1] = '\0';

	while (dirlist != NULL)
	{
		location = GNOPHER_LOCATION(dirlist->data);

		filetype[0] = location->filetype;
		port = g_strdup_printf ("%d", location->port);
		data = g_strconcat (data, filetype,
			location->description,
			"\t", location->selector,
			"\t", location->server,
			"\t", port,
			"\r\n",
			NULL);
		free (port);
		dirlist = g_list_next (dirlist);
	}
	data = g_strconcat (data, ".\r\n", NULL);

	g_printerr ("bijna uit gl set directory\n");

	return gnopher_location_set_raw_data (self, data, 0);
}

GnomeVFSResult
gnopher_location_get_raw_data (GnopherLocation * self, gboolean force_reload)
{
	gchar * buffer = NULL, * selector2, * local;
	GTcpSocket * socket = NULL;
	GIOChannel * channel = NULL;
	gulong buffersize;
	guint bytes, counter;
	int filedes;

	g_printerr ("in gl get raw data\n");
	if ((self->data != NULL) && (force_reload == FALSE))
	{
		g_printerr ("uit gl get raw data [!reload]\n");
		return GNOME_VFS_OK;
	}

	g_printerr ("Server: %s, port: %u, selector: %s\n",
		self->server,
		self->port,
		self->selector);

	if (!(socket = gnet_tcp_socket_connect ((gchar *)self->server, self->port)))
	{
		g_printerr ("uit gl get raw data [err]\n");
		return GNOME_VFS_ERROR_GENERIC;
	}

	if (self->filetype == '7')
		selector2 = g_strconcat (self->selector, "\t", self->query, "\r\n", NULL);
	else
		selector2 = g_strconcat (self->selector, "\r\n", NULL);

	channel = gnet_tcp_socket_get_iochannel (socket);
	
	if (channel == NULL)
	{
		g_printerr ("uit gl get raw data [io err]\n");
		return GNOME_VFS_ERROR_IO;
	}

	gnet_io_channel_writen (channel, selector2, strlen(selector2), &bytes);
	free (selector2);

	buffersize = 250;
	buffer = g_malloc (buffersize);
	counter = 0;

	gnet_io_channel_readn (channel, &buffer[counter], 1, &bytes);
	while (bytes != 0)
	{
		counter++;
		if (counter >= (buffersize - 1)) /* counter starts at 0 */
		{
			buffersize = buffersize + 250;
			buffer = g_realloc (buffer, buffersize);
		}
		gnet_io_channel_readn (channel, &buffer[counter], 1, &bytes);
	}
	g_io_channel_unref (channel);
	if (socket != NULL)
	{
		gnet_tcp_socket_delete (socket);
	}
	if (filedes > 0)
	{
		close (filedes);
	}

	/* Add a trailing '\0' for interpretation as string. FIXME: is this necessary? */
	if (counter >= (buffersize - 2))
	{
		buffersize++;
		buffer = g_realloc (buffer, buffersize);
	}
	buffer[counter + 1] = '\0';

	if (self->data != NULL)
	{
		free (self->data);
	}

	self->data = buffer;
	self->datasize = (counter + 1);

	g_printerr ("uit gl get raw data\n");
	return GNOME_VFS_OK;
}

gboolean
gnopher_location_set_raw_data (GnopherLocation * self, gchar * data, guint datasize)
{
	gchar * filename;
	guint count = 0;
	FILE * file;

	g_printerr ("in gl set raw data\n");

	if (datasize == 0) /* it is a null-terminated string */
		datasize = strlen (data) + 1;

	if (strcmp (self->server, "<local>") == 0)
	{
		filename = g_strconcat (g_get_home_dir (),
			"/.gnopher/",
			NULL);
		if (g_file_exists (filename) == FALSE)
		{
			mkdir (filename, 0777);
			g_free (filename);
		}
		filename = g_strconcat (g_get_home_dir (),
			"/.gnopher/",
			self->selector,
			NULL);

	}
	else if (strcmp (self->server, "<download>") == 0)
	{
		filename = (gchar *) self->selector;
	}
	else
	{
		g_message ("You can set_data local files only. You"
			"never should've reached this place; it's a bug, baby.");
		return FALSE;
	}

	if (file = fopen (filename, "w"))
	{
		while (count < (datasize - 1))
		{
			fputc (data[count++], file);
		}
		fclose (file);
		g_printerr ("uit gl set raw data [TRUE]\n");
		return (TRUE);
	}
	else
	{
		perror ("fopen");
		g_printerr ("uit gl set raw data [FALSE]\n");
		return FALSE;
	}

}

