                            2     	      dnl  x86 mpn_lshift -- mpn left shift.

dnl  Copyright (C) 1992, 1994, 1996, 1999, 2000 Free Software Foundation,
dnl  Inc.
dnl 
dnl  This file is part of the GNU MP Library.
dnl 
dnl  The GNU MP Library is free software; you can redistribute it and/or
dnl  modify it under the terms of the GNU Lesser General Public License as
dnl  published by the Free Software Foundation; either version 2.1 of the
dnl  License, or (at your option) any later version.
dnl 
dnl  The GNU MP Library is distributed in the hope that it will be useful,
dnl  but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
dnl  Lesser General Public License for more details.
dnl 
dnl  You should have received a copy of the GNU Lesser General Public
dnl  License along with the GNU MP Library; see the file COPYING.LIB.  If
dnl  not, write to the Free Software Foundation, Inc., 59 Temple Place -
dnl  Suite 330, Boston, MA 02111-1307, USA.


include(`../config.m4')


C mp_limb_t mpn_lshift (mp_ptr dst, mp_srcptr src, mp_size_t size,
C                       unsigned shift);

defframe(PARAM_SHIFT,16)
defframe(PARAM_SIZE, 12)
defframe(PARAM_SRC,  8)
defframe(PARAM_DST,  4)

	.text
	ALIGN(8)
PROLOGUE(mpn_lshift)

	pushl	%edi
	pushl	%esi
	pushl	%ebx
deflit(`FRAME',12)

	movl	PARAM_DST,%edi
	movl	PARAM_SRC,%esi
	movl	PARAM_SIZE,%edx
	movl	PARAM_SHIFT,%ecx

	subl	$4,%esi			C adjust src

	movl	(%esi,%edx,4),%ebx	C read most significant limb
	xorl	%eax,%eax
	shldl(	%cl, %ebx, %eax)	C compute carry limb
	decl	%edx
	jz	L(end)
	pushl	%eax			C push carry limb onto stack
	testb	$1,%dl
	jnz	L(1)			C enter loop in the middle
	movl	%ebx,%eax

	ALIGN(8)
L(oop):	movl	(%esi,%edx,4),%ebx	C load next lower limb
	shldl(	%cl, %ebx, %eax)	C compute result limb
	movl	%eax,(%edi,%edx,4)	C store it
	decl	%edx
L(1):	movl	(%esi,%edx,4),%eax
	shldl(	%cl, %eax, %ebx)
	movl	%ebx,(%edi,%edx,4)
	decl	%edx
	jnz	L(oop)

	shll	%cl,%eax		C compute least significant limb
	movl	%eax,(%edi)		C store it

	popl	%eax			C pop carry limb

	popl	%ebx
	popl	%esi
	popl	%edi
	ret

L(end):	shll	%cl,%ebx		C compute least significant limb
	movl	%ebx,(%edi)		C store it

	popl	%ebx
	popl	%esi
	popl	%edi
	ret

EPILOGUE()
TEXTCWIE                        