/** @file wlan_wext.h
 * @brief This file contains definition for IOCTL call.
 *  
 *  Copyright (c) Marvell Semiconductor, Inc., 2003-2005
 */
/********************************************************
Change log:
	10/11/05: Add Doxygen format comments
	
********************************************************/

#ifndef	_WLAN_WEXT_H_
#define	_WLAN_WEXT_H_

/** PRIVATE CMD ID */
#define	WLANIOCTL			SIOCIWFIRSTPRIV

#define WLANSETWPAIE			(WLANIOCTL + 0)  
#define WLANCISDUMP 			(WLANIOCTL + 1)
#define	WLANMANFCMD			(WLANIOCTL + 2)
#define	WLANREGRDWR			(WLANIOCTL + 3)
#define MAX_EEPROM_DATA     			256
#define	WLANSTDCMD			(WLANIOCTL + 4)

#ifdef HOST_SLEEP
#define WLANHOSTSLEEPCFG		(WLANIOCTL + 6)
#endif

#define WLAN_SETNONE_GETBYTE		(WLANIOCTL + 7)

#ifdef REASSOCIATION
#define WLANREASSOCIATIONAUTO			1
#define WLANREASSOCIATIONUSER			2
#endif /* REASSOCIATION */

#define WLANWLANIDLEON				3
#define WLANWLANIDLEOFF				4


#define WLAN_SETNONE_GETNONE	        (WLANIOCTL + 8)
#define WLANDEAUTH                  		1
#define WLANRADIOON                 		2
#define WLANRADIOOFF                		3
#define WLANREMOVEADHOCAES          		4
#define WLANADHOCSTOP               		5	
#define WLANCIPHERTEST              		6

#define WLANGETLOG                  	(WLANIOCTL + 9)
#define WLAN_SETCONF_GETCONF		(WLANIOCTL + 10)

#ifdef BG_SCAN
#define BG_SCAN_CONFIG				1
#endif /* BG_SCAN */

#ifdef SUBSCRIBE_EVENT_CTRL
#define SUBSCRIBE_EVENT				6
#endif

#ifdef WMM
#define WMM_TSPEC				2
#define WMM_ACK_POLICY				3
#define WMM_PARA_IE				4
#define WMM_ACK_POLICY_PRIO			4
#endif /* WMM */

#ifdef CAL_DATA
#define	CAL_DATA_EXT_CONFIG			5		
#define WLANGET_CAL_DATA_EXT			0
#define WLANSET_CAL_DATA_EXT			1
#endif
#define WLANSCAN_TYPE			(WLANIOCTL + 11)

#define WLAN_SETNONE_GETONEINT		(WLANIOCTL + 15)
#define WLANGETREGION				1
#define WLAN_GET_LISTEN_INTERVAL		2
#define WLAN_GET_MULTIPLE_DTIM			3
#define	WLANGETBCNAVG				5

#define WLAN_SETTENCHAR_GETNONE		(WLANIOCTL + 16)
#ifdef MULTI_BANDS
#define WLAN_SET_BAND               		1
#define WLAN_SET_ADHOC_CH           		2
#endif
#ifdef ENABLE_802_11H
#define WLAN_11H_CHANSWANN          		3
#endif

#define WLAN_SETNONE_GETTENCHAR		(WLANIOCTL + 17)
#ifdef MULTI_BANDS
#define WLAN_GET_BAND				1
#define WLAN_GET_ADHOC_CH			2
#endif

#define WLANREGCFRDWR			(WLANIOCTL + 18)

#define WLAN_SETNONE_GETTWELVE_CHAR	(WLANIOCTL + 19)
#define WLAN_SUBCMD_GETRXANTENNA		1
#define WLAN_SUBCMD_GETTXANTENNA		2

#define WLAN_SETWORDCHAR_GETNONE	(WLANIOCTL + 20)
#define WLANSETADHOCAES				1	

#define WLAN_SETNONE_GETWORDCHAR	(WLANIOCTL + 21)
#define WLANGETADHOCAES				1	
#define WLANVERSION				2	

#define WLAN_SETONEINT_GETONEINT	(WLANIOCTL + 23)
#define WLANNF					1
#define WLANRSSI				2

#ifdef THROUGHPUT_TEST
#define WLANTHRUPUT				4
#endif /* THROUGHTPUT_TEST */

#ifdef BG_SCAN
#define WLANBGSCAN				5
#endif /* BG_SCAN */

#ifdef ENABLE_802_11D
#define WLANENABLE11D				6
#endif

#ifdef ADHOC_GRATE
#define WLANADHOCGRATE				7
#endif

#ifdef ENABLE_802_11H
#define WLAN_11H_ENABLE             		8
#define WLAN_11H_SETLOCALPOWER      		9
#endif

#ifdef BULVERDE_SDIO
#define WLANSDIOCLOCK				10
#endif

#ifdef WMM
#define WLANWMM_ENABLE				11
#endif /* WMM */

#ifdef WMM_UAPSD
#define WLAN_WMM_QOSINFO			12
#endif /* WMM_UAPSD */

#ifdef PS_REQUIRED
#define	WLAN_LISTENINTRVL			13
#ifdef FW_WAKEUP_METHOD
#define WLAN_FW_WAKEUP_METHOD			15
#define WAKEUP_FW_UNCHANGED			0
#define WAKEUP_FW_THRU_INTERFACE		1
#define WAKEUP_FW_THRU_GPIO			2
#endif
#endif

#define WLAN_TXCONTROL				16

#ifdef ATIMGEN			
#define WLANATIMGEN				17
#endif

#ifdef WMM_UAPSD
#define WLANNULLGEN				18
#endif

#define WLAN_SETONEINT_GETNONE		(WLANIOCTL + 24)
#define WLAN_SUBCMD_SETRXANTENNA		1
#define WLAN_SUBCMD_SETTXANTENNA		2
#define WLANSETAUTHALG				5
#define WLANSET8021XAUTHALG			6
#define WLANSETENCRYPTIONMODE			7
#define WLANSETREGION				8
#define WLAN_SET_LISTEN_INTERVAL		9

#ifdef PS_REQUIRED
#define WLAN_SET_MULTIPLE_DTIM			10
#endif
#define WLAN_SET_ATIM_WINDOW			11
#define WLANSETBCNAVG				13
#define WLANSETDATAAVG				14

#define WLAN_SET64CHAR_GET64CHAR	(WLANIOCTL + 25)	
#define WLANSLEEPPARAMS 			2

#ifdef BCA
#define	WLAN_BCA_TIMESHARE			3
#endif

#ifdef ENABLE_802_11H
#define WLAN_11H_REQUESTTPC         		4
#define WLAN_11H_SETPOWERCAP        		5
#endif
#define WLANSCAN_MODE				6

#define WLAN_GET_ADHOC_STATUS			9

#if defined(IWGENIE_SUPPORT) && (WIRELESS_EXT < 18)
#define WLAN_SET_GEN_IE                 	10
#define WLAN_GET_GEN_IE                 	11
#endif
#if defined(REASSOC_CMD_SUPPORT)
#define WLAN_REASSOCIATE                	12
#endif
#ifdef ENABLE_MEAS
#define WLAN_MEASREQ                    	13
#endif


#define WLANEXTSCAN			(WLANIOCTL + 26)
#ifdef DEEP_SLEEP
#define WLANDEEPSLEEP			(WLANIOCTL + 27)
#define DEEP_SLEEP_ENABLE			1
#define DEEP_SLEEP_DISABLE  			0	
#endif

#define WLAN_SET_GET_SIXTEEN_INT       (WLANIOCTL + 29)
#define WLAN_TPCCFG                             1
#define WLAN_POWERCFG                           2

#ifdef AUTO_FREQ_CTRL
#define WLAN_AUTO_FREQ_SET			3
#define WLAN_AUTO_FREQ_GET			4
#endif
#ifdef LED_GPIO_CTRL	
#define WLAN_LED_GPIO_CTRL			5
#endif
#define WLAN_SCANPROBES 			6
#define WLAN_SLEEP_PERIOD			7
#define	WLAN_ADAPT_RATESET			8
#define	WLAN_INACTIVITY_TIMEOUT			9
#define WLANSNR					10
#define WLAN_GET_RATE				11

#define WLANCMD52RDWR			(WLANIOCTL + 30)
#define WLANCMD53RDWR			(WLANIOCTL + 31)
#define CMD53BUFLEN				32

#define	REG_MAC					0x19
#define	REG_BBP					0x1a
#define	REG_RF					0x1b
#define	REG_EEPROM				0x59

#define	CMD_DISABLED				0
#define	CMD_ENABLED				1
#define	CMD_GET					2
#define SKIP_CMDNUM				4
#define SKIP_TYPE				1
#define SKIP_SIZE				2
#define SKIP_ACTION				2
#define SKIP_TYPE_SIZE			(SKIP_TYPE + SKIP_SIZE)
#define SKIP_TYPE_ACTION		(SKIP_TYPE + SKIP_ACTION)

/** wlan_ioctl */
typedef struct _wlan_ioctl {
	/** Command ID */
	u16	command;
	/** data length */
	u16	len;
	/** data pointer */
	u8	*data;
} wlan_ioctl;

/** wlan_ioctl_rfantenna */
typedef struct _wlan_ioctl_rfantenna {
	u16 Action;
	u16 AntennaMode;
} wlan_ioctl_rfantenna;

/** wlan_ioctl_regrdwr */
typedef struct _wlan_ioctl_regrdwr {
	/** Which register to access */
	u16	WhichReg;
	/** Read or Write */
	u16	Action;
	u32	Offset;
	u16	NOB;
	u32	Value;
} wlan_ioctl_regrdwr;

/** wlan_ioctl_cfregrdwr */
typedef struct _wlan_ioctl_cfregrdwr {
	/** Read or Write */
	u8	Action;
	/** register address */
	u16	Offset;
	/** register value */
	u16	Value;
} wlan_ioctl_cfregrdwr;

/** wlan_ioctl_rdeeprom */
typedef struct _wlan_ioctl_rdeeprom {
	u16	WhichReg;
	u16	Action;
	u16	Offset;
	u16	NOB;
	u8	Value;
} wlan_ioctl_rdeeprom;

/** wlan_ioctl_adhoc_key_info */
typedef struct _wlan_ioctl_adhoc_key_info {
	u16	action;
	u8	key[16];
	u8 	tkiptxmickey[16];
	u8	tkiprxmickey[16];
}wlan_ioctl_adhoc_key_info;			

#ifdef __KERNEL__
extern  struct iw_handler_def wlan_handler_def;
struct iw_statistics *wlan_get_wireless_stats(struct net_device *dev);
int wlan_do_ioctl(struct net_device *dev, struct ifreq *req, int i);
#endif

#ifdef SUBSCRIBE_EVENT_CTRL
/** EventSubscribe*/
typedef struct _EventSubscribe {
	u16	Action;
	u16	Events;
	u8	RSSIValue;
	u8	RSSIFreq;
	u8	SNRValue;
	u8	SNRFreq;
	u8	FailValue;
	u8	FailFreq;
	u8	BcnMissed;
} EventSubscribe;
#endif

#ifdef WMM
/** wlan_ioctl_wmm_para_ie */
struct _wlan_ioctl_wmm_para_ie {
	/** type */
	u8 	Type;
	/** action */
	u16	Action;
	/** WMM Parameter IE */
	u8	Para_IE[26];
}  __ATTRIB_PACK__ ;

/** wlan_ioctl_wmm_tspec*/
struct _wlan_ioctl_wmm_tspec {
	u8 	Type;
	/** 0 - Get TSPEC
	    1 - Set TSPEC
	    3 - Remove TSPEC */
	u16	Action;
	/** 0 - TSPEC for AC_BE
	    1 - TSPEC for AC_BK
	    2 - TSPEC for AC_BK
	    3 - TSPEC for AC_BE
	    4 - TSPEC for AC_VI
	    5 - TSPEC for AC_VI
	    6 - TSPEC for AC_VO
	    7 - TSPEC for AC_VO */
	u8	UserPriority;
	
	/** 0 - WMM_PS_LEGACY
	    1 - WMM_PS_TRIGGERED */
	u8	PSMethod;
	
	/** 0 - Size of MSDU not fixed
	    1 - Size of MSDU is fixed */
	u8	FixedSizeMSDU;
	/** Nominal MSDU size in bytes */	
	u16	MSDUSize;
	/** Average data rate in bits/sec */
	u32	MeanDataRate;
	/** Minimum PHY rate in bits/sec */
	u32	MinPhyRate;
	
	/**Extra bandwidth factor to account for retries */
	u16	ExtraBandwidth;
} __ATTRIB_PACK_;

/** wlan_ioctl_wmm_ack_policy */
struct _wlan_ioctl_wmm_ack_policy{
	u8	Type;
	/** 0-ACT_GET	   1-ACT_SET */
	u16	Action;
	/** 0-AC_BE 1-AC_BK 2-AC_VI 3-AC_VO */
	u8	AC;
	/** 0-WMM_ACK_POLICY_IMM_ACK 1-WMM_ACK_POLICY_NO_ACK */
	u8	AckPolicy;
} __ATTRIB_PACK__;

#endif /* WMM */

/** sleep_params */	
typedef struct _wlan_ioctl_sleep_params_config  {
	u16		Action;
	u16 		Error;
	u16 		Offset;
	u16 		StableTime;
	u8		CalControl;	
	u8		ExtSleepClk;	
	u16		Reserved;
} __ATTRIB_PACK__ wlan_ioctl_sleep_params_config,
	*pwlan_ioctl_sleep_params_config;

/** BCA TIME SHARE */
typedef struct _wlan_ioctl_bca_timeshare_config {
	/** ACT_GET/ACT_SET */	
	u16	 	Action;
 	/** Type: WLAN, BT */
	u16	 	TrafficType;
	/** Interval: 20msec - 60000msec */
	u32 	 	TimeShareInterval; 
 	/** PTA arbiter time in msec */	
	u32	 	BTTime;
} __ATTRIB_PACK__ wlan_ioctl_bca_timeshare_config,
	*pwlan_ioctl_bca_timeshare_config;

typedef struct _wlan_ioctl_reassociation_info {
    u8 CurrentBSSID[6];
    u8 DesiredBSSID[6];
    char DesiredSSID[IW_ESSID_MAX_SIZE + 1];
} __ATTRIB_PACK__ wlan_ioctl_reassociation_info;

#endif /* _WLAN_WEXT_H_ */
