/** @file wlan_types.h
 *  @brief This header file contains definition for global types
 *
 *  Copyright (c) Marvell Semiconductor, Inc., 2003-2005
 */
/*************************************************************
Change log:
	10/11/05: add Doxygen format comments 
************************************************************/

#ifndef _WLAN_TYPES_
#define _WLAN_TYPES_

/** IEEE Type definitions  */
typedef enum _IEEEtypes_ElementId_e {
    SSID = 0,
    SUPPORTED_RATES,
    FH_PARAM_SET,
    DS_PARAM_SET,
    CF_PARAM_SET,
    TIM,
    IBSS_PARAM_SET,
#ifdef ENABLE_802_11D
    COUNTRY_INFO = 7,
#endif

    CHALLENGE_TEXT = 16,

#ifdef ENABLE_802_11H
    POWER_CONSTRAINT = 32,
    POWER_CAPABILITY = 33,
    TPC_REQUEST  = 34,
    TPC_REPORT   = 35,
    SUPPORTED_CHANNELS = 36,
    CHANNEL_SWITCH_ANN = 37,
    QUIET              = 40,
    IBSS_DFS           = 41,
#endif

    EXTENDED_SUPPORTED_RATES = 50,
    
    VENDOR_SPECIFIC_221 = 221,
#ifdef WMM
    WMM_IE = 221,
#endif /* WMM */
    
#ifdef WPA
    WPA_IE = 221,
#ifdef WPA2
    WPA2_IE = 48,
#endif  /* WPA2 */
#endif  /* WPA */
    
    EXTRA_IE = 133,
} __ATTRIB_PACK__ IEEEtypes_ElementId_e;

#ifdef WMM
#define WMM_OUI_TYPE  2
#endif /* WMM */

#define CAPINFO_MASK    (~( W_BIT_15 | W_BIT_14 |               \
                            W_BIT_12 | W_BIT_11 | W_BIT_9) )

#ifdef BIG_ENDIAN
/** Capability Bit Map*/
typedef struct _IEEEtypes_CapInfo_t {
	u8	Rsrvd1:2;
	u8	DSSSOFDM:1;
	u8	Rsvrd2:2;
	u8	ShortSlotTime:1;
	u8	Rsrvd3:1;
	u8	SpectrumMgmt:1;
	u8	ChanAgility:1;
	u8	Pbcc:1;
	u8	ShortPreamble:1;
	u8	Privacy:1;
	u8	CfPollRqst:1;
	u8	CfPollable:1;
	u8	Ibss:1;
	u8	Ess:1;
} __ATTRIB_PACK__ IEEEtypes_CapInfo_t;
#else
typedef struct _IEEEtypes_CapInfo_t {
	u8	Ess:1;
	u8	Ibss:1;
	u8	CfPollable:1;
	u8	CfPollRqst:1;
	u8	Privacy:1;
	u8	ShortPreamble:1;
	u8	Pbcc:1;
	u8	ChanAgility:1;
	u8	SpectrumMgmt:1;
	u8	Rsrvd3:1;
	u8	ShortSlotTime:1;
	u8	Apsd:1;
	u8	Rsvrd2:1;
	u8	DSSSOFDM:1;
	u8	Rsrvd1:2;
} __ATTRIB_PACK__ IEEEtypes_CapInfo_t;

#endif /* BIG_ENDIAN */

/** IEEEtypes_CfParamSet_t */
typedef struct _IEEEtypes_CfParamSet_t {
	u8	ElementId;
	u8	Len;
	u8	CfpCnt;
	u8	CfpPeriod;
	u16	CfpMaxDuration;
	u16	CfpDurationRemaining;
} __ATTRIB_PACK__ IEEEtypes_CfParamSet_t;

typedef struct IEEEtypes_IbssParamSet_t {
	u8	ElementId;
	u8	Len;
	u16	AtimWindow;
} __ATTRIB_PACK__ IEEEtypes_IbssParamSet_t;

/** IEEEtypes_SsParamSet_t */
typedef union _IEEEtypes_SsParamSet_t {
	IEEEtypes_CfParamSet_t		CfParamSet;
	IEEEtypes_IbssParamSet_t	IbssParamSet;
} __ATTRIB_PACK__ IEEEtypes_SsParamSet_t;

/** IEEEtypes_FhParamSet_t */
typedef struct _IEEEtypes_FhParamSet_t {
	u8	ElementId;
	u8	Len;
	u16	DwellTime;
	u8	HopSet;
	u8	HopPattern;
	u8	HopIndex;
} __ATTRIB_PACK__ IEEEtypes_FhParamSet_t;

typedef struct _IEEEtypes_DsParamSet_t {
	u8	ElementId;
	u8	Len;
	u8	CurrentChan;
} __ATTRIB_PACK__ IEEEtypes_DsParamSet_t;

/** IEEEtypes_DsParamSet_t */
typedef union IEEEtypes_PhyParamSet_t {
	IEEEtypes_FhParamSet_t	FhParamSet;
	IEEEtypes_DsParamSet_t	DsParamSet;
} __ATTRIB_PACK__ IEEEtypes_PhyParamSet_t;


/** TLV  type ID definition */
#define PROPRIETARY_TLV_BASE_ID		0x0100

/* Terminating TLV Type */
#define MRVL_TERMINATE_TLV_ID		0xffff

#define TLV_TYPE_SSID				0x0000
#define TLV_TYPE_RATES				0x0001
#define TLV_TYPE_PHY_FH				0x0002
#define TLV_TYPE_PHY_DS				0x0003
#define TLV_TYPE_CF				    0x0004
#define TLV_TYPE_IBSS				0x0006

#ifdef ENABLE_802_11D
#define TLV_TYPE_DOMAIN				0x0007
#endif

#ifdef ENABLE_802_11H
#define TLV_TYPE_POWER_CONSTRAINT	0x0020
#endif
#define TLV_TYPE_POWER_CAPABILITY	0x0021

#define TLV_TYPE_KEY_MATERIAL       (PROPRIETARY_TLV_BASE_ID + 0)
#define TLV_TYPE_CHANLIST           (PROPRIETARY_TLV_BASE_ID + 1)
#define TLV_TYPE_NUMPROBES          (PROPRIETARY_TLV_BASE_ID + 2)
#define TLV_TYPE_RSSI               (PROPRIETARY_TLV_BASE_ID + 4)
#define TLV_TYPE_SNR                (PROPRIETARY_TLV_BASE_ID + 5)
#define TLV_TYPE_FAILCOUNT          (PROPRIETARY_TLV_BASE_ID + 6)
#define TLV_TYPE_BCNMISS            (PROPRIETARY_TLV_BASE_ID + 7)
#define TLV_TYPE_LED_GPIO           (PROPRIETARY_TLV_BASE_ID + 8)
#define TLV_TYPE_LEDBEHAVIOR        (PROPRIETARY_TLV_BASE_ID + 9)
#define TLV_TYPE_PASSTHROUGH        (PROPRIETARY_TLV_BASE_ID + 10)
#define TLV_TYPE_REASSOCAP          (PROPRIETARY_TLV_BASE_ID + 11)
#define TLV_TYPE_POWER_TBL_2_4GHZ   (PROPRIETARY_TLV_BASE_ID + 12)
#define TLV_TYPE_POWER_TBL_5GHZ     (PROPRIETARY_TLV_BASE_ID + 13)
#define TLV_TYPE_BCASTPROBE	    (PROPRIETARY_TLV_BASE_ID + 14)
#define TLV_TYPE_NUMSSID_PROBE	    (PROPRIETARY_TLV_BASE_ID + 15)

/** TLV related data structures*/
/** MrvlIEtypesHeader_t */
typedef struct _MrvlIEtypesHeader {
	u16	Type;
	u16	Len;
} __ATTRIB_PACK__ MrvlIEtypesHeader_t;

/** MrvlIEtypes_RatesParamSet_t */
typedef struct 	_MrvlIEtypes_RatesParamSet_t {
	MrvlIEtypesHeader_t	Header;
	u8	Rates[1];
} __ATTRIB_PACK__ MrvlIEtypes_RatesParamSet_t;

/** MrvlIEtypes_SsIdParamSet_t */
typedef struct 	_MrvlIEtypes_SsIdParamSet_t {
	MrvlIEtypesHeader_t	Header;
	u8	SsId[1];
} __ATTRIB_PACK__ MrvlIEtypes_SsIdParamSet_t;

/** ChanScanParamSet_t */
typedef struct _ChanScanParamSet_t{
	u8	RadioType;
	u8	ChanNumber;
	u8	ScanType;
	u16	MinScanTime;
	u16	MaxScanTime;
} __ATTRIB_PACK__ ChanScanParamSet_t;

/** MrvlIEtypes_ChanListParamSet_t */
typedef struct 	_MrvlIEtypes_ChanListParamSet_t {
	MrvlIEtypesHeader_t	Header;
	ChanScanParamSet_t 	ChanScanParam[1];
} __ATTRIB_PACK__ MrvlIEtypes_ChanListParamSet_t;

/** CfParamSet_t */
typedef struct _CfParamSet_t {
	u8	CfpCnt;
	u8	CfpPeriod;
	u16	CfpMaxDuration;
	u16	CfpDurationRemaining;
} __ATTRIB_PACK__ CfParamSet_t;

/** IbssParamSet_t */
typedef struct _IbssParamSet_t {
	u16	AtimWindow;
} __ATTRIB_PACK__ IbssParamSet_t;

/** MrvlIEtypes_SsParamSet_t */
typedef struct _MrvlIEtypes_SsParamSet_t {
	MrvlIEtypesHeader_t	Header;
	union {
		CfParamSet_t	CfParamSet[1];
		IbssParamSet_t	IbssParamSet[1];
	} cf_ibss;
} __ATTRIB_PACK__ MrvlIEtypes_SsParamSet_t;

/** FhParamSet_t */
typedef struct _FhParamSet_t {
	u16	DwellTime;
	u8	HopSet;
	u8	HopPattern;
	u8	HopIndex;
} __ATTRIB_PACK__ FhParamSet_t;

/** DsParamSet_t */
typedef struct _DsParamSet_t {
	u8	CurrentChan;
} __ATTRIB_PACK__ DsParamSet_t;

/** MrvlIEtypes_PhyParamSet_t */
typedef struct _MrvlIEtypes_PhyParamSet_t {
	MrvlIEtypesHeader_t	Header;
	union {
		FhParamSet_t	FhParamSet[1];
		DsParamSet_t	DsParamSet[1];
	} fh_ds;
} __ATTRIB_PACK__ MrvlIEtypes_PhyParamSet_t;

#ifdef REASSOC_CMD_SUPPORT
/** MrvlIEtypes_ReassocAp_t */
typedef struct _MrvlIEtypes_ReassocAp_t {
	MrvlIEtypesHeader_t	Header;
    WLAN_802_11_MAC_ADDRESS currentAp;

} __ATTRIB_PACK__ MrvlIEtypes_ReassocAp_t;
#endif

#ifdef  WPA
/** MrvlIEtypes_RsnParamSet_t */
typedef struct 	_MrvlIEtypes_RsnParamSet_t {
	MrvlIEtypesHeader_t	Header;
	u8	RsnIE[1];
} __ATTRIB_PACK__ MrvlIEtypes_RsnParamSet_t;
#endif

#ifdef  WMM
/** MrvlIEtypes_WmmParamSet_t */
typedef struct 	_MrvlIEtypes_WmmParamSet_t {
	MrvlIEtypesHeader_t	Header;
	u8	WmmIE[1];
} __ATTRIB_PACK__ MrvlIEtypes_WmmParamSet_t;
#endif

/**  Local Power Capability */
typedef struct _MrvlIEtypes_PowerCapability_t {
	MrvlIEtypesHeader_t	Header;
	s8 	MinPower;
	s8	MaxPower;
} __ATTRIB_PACK__ MrvlIEtypes_PowerCapability_t;

/** MrvlIEtypes_RssiParamSet_t */
typedef struct _MrvlIEtypes_RssiThreshold_t {
	MrvlIEtypesHeader_t	Header;
	u8			RSSIValue;
	u8			RSSIFreq;
} __ATTRIB_PACK__ MrvlIEtypes_RssiParamSet_t;

/** MrvlIEtypes_SnrThreshold_t */
typedef struct _MrvlIEtypes_SnrThreshold_t {
	MrvlIEtypesHeader_t	Header;
	u8			SNRValue;
	u8			SNRFreq;
} __ATTRIB_PACK__ MrvlIEtypes_SnrThreshold_t;

/** MrvlIEtypes_FailureCount_t */
typedef struct _MrvlIEtypes_FailureCount_t {
	MrvlIEtypesHeader_t	Header;
	u8			FailValue;
	u8			FailFreq;
} __ATTRIB_PACK__ MrvlIEtypes_FailureCount_t;

/** MrvlIEtypes_BeaconsMissed_t */
typedef struct _MrvlIEtypes_BeaconsMissed_t {
	MrvlIEtypesHeader_t	Header;
	u8			BeaconMissed;
	u8			Reserved;
} __ATTRIB_PACK__ MrvlIEtypes_BeaconsMissed_t;

/** MrvlIEtypes_NumProbes_t */
typedef struct 	_MrvlIEtypes_NumProbes_t {
	MrvlIEtypesHeader_t	Header;
	u16 			NumProbes;
} __ATTRIB_PACK__ MrvlIEtypes_NumProbes_t;

/** MrvlIEtypes_BcastProbe_t */
typedef struct 	_MrvlIEtypes_BcastProbe_t {
	MrvlIEtypesHeader_t	Header;
	u16 			BcastProbe;
} __ATTRIB_PACK__ MrvlIEtypes_BcastProbe_t;

/** MrvlIEtypes_NumSSIDProbe_t */
typedef struct 	_MrvlIEtypes_NumSSIDProbe_t {
	MrvlIEtypesHeader_t	Header;
	u16 			NumSSIDProbe;
} __ATTRIB_PACK__ MrvlIEtypes_NumSSIDProbe_t;

#ifdef LED_GPIO_CTRL
typedef struct {
  u8 Led;
  u8 Pin;
} __ATTRIB_PACK__ Led_Pin;

/** MrvlIEtypes_LedGpio_t */
typedef struct 	_MrvlIEtypes_LedGpio_t {
	MrvlIEtypesHeader_t	Header;
	Led_Pin			LedPin[1];
} __ATTRIB_PACK__ MrvlIEtypes_LedGpio_t;
#endif

#endif /* _WLAN_TYPES_ */

