/** @file wlan_dev.h
 *  @brief This file contains definitions and data structures specific
 *          to Marvell 802.11 NIC. It contains the Device Information
 *          structure wlan_adapter.  
 *
 *  Copyright (c) Marvell Semiconductor, Inc., 2003-2005
 */
/*************************************************************
Change log:
	09/26/05: add Doxygen format comments 
 ************************************************************/

#ifndef _WLAN_DEV_H_
#define _WLAN_DEV_H_

#define	MAX_BSSID_PER_CHANNEL		16

/* For the extended Scan */
#define MAX_EXTENDED_SCAN_BSSID_LIST    MAX_BSSID_PER_CHANNEL * \
						MRVDRV_MAX_CHANNEL_SIZE + 1
						
typedef struct _PER_CHANNEL_BSSID_LIST_DATA {
	u8	ucStart;
	u8	ucNumEntry;
} PER_CHANNEL_BSSID_LIST_DATA, *PPER_CHANNEL_BSSID_LIST_DATA;

typedef struct _MRV_BSSID_IE_LIST {
	WLAN_802_11_FIXED_IEs   FixedIE;
	u8                   VariableIE[MRVDRV_SCAN_LIST_VAR_IE_SPACE];
} MRV_BSSID_IE_LIST, *PMRV_BSSID_IE_LIST;

#define	MAX_REGION_CHANNEL_NUM	2

/** Chan-Freq-TxPower mapping table*/
typedef struct _CHANNEL_FREQ_POWER {
	/** Channel Number		*/
	u16	Channel;
	/** Frequency of this Channel	*/
	u32	Freq;
	/** Max allowed Tx power level	*/
	u16	MaxTxPower;
	/** TRUE:channel unsupported;  FLASE:supported*/
	BOOLEAN	Unsupported;
} CHANNEL_FREQ_POWER;

/** region-band mapping table*/
typedef	struct	_REGION_CHANNEL {
	/** TRUE if this entry is valid		     */
	BOOLEAN	Valid;
	/** Region code for US, Japan ...	     */
	u8	Region;
	/** Band B/G/A, used for BAND_CONFIG cmd	     */
	u8	Band;
	/** Actual No. of elements in the array below */
	u8	NrCFP;
	/** chan-freq-txpower mapping table*/
	CHANNEL_FREQ_POWER	*CFP;
} REGION_CHANNEL;


typedef struct  _wlan_802_11_security_t
{
#ifdef WPA
	BOOLEAN				WPAEnabled;
#ifdef WPA2
	BOOLEAN				WPA2Enabled;
#endif /* WPA2*/
#endif /* WPA */
	WLAN_802_11_WEP_STATUS 		WEPStatus;
	WLAN_802_11_AUTHENTICATION_MODE AuthenticationMode;
	WLAN_802_1X_AUTH_ALG 		Auth1XAlg;
	WLAN_802_11_ENCRYPTION_MODE 	EncryptionMode;
} wlan_802_11_security_t;

/** Current Basic Service Set State Structure */
typedef struct CurrentBSSParams
{
	/** ssid */
	WLAN_802_11_SSID 	ssid;
	/** bssid */
	WLAN_802_11_BSSID 	bssid;
	/** band */
	u8			band;
	/** channel */
	u8			channel;
	/** number of rates supported */
	int			NumOfRates;
	/** supported rates*/
	u8			DataRates[WLAN_SUPPORTED_RATES];
#ifdef WMM
	/** wmm enable? */
	u8			wmm_enabled;
	/** wmm queue priority table*/
	u8			wmm_queue_prio[MAX_AC_QUEUES];
#endif /* WMM */
#ifdef WMM_UAPSD
	/** uapse enable?*/
	u8			wmm_uapsd_enabled;
#endif
} CurrentBSSParams;

/** sleep_params */	
typedef struct SleepParams
{
	u16 			sp_error;
	u16 			sp_offset;
	u16 			sp_stabletime;
	u8 			sp_calcontrol;	
	u8 			sp_extsleepclk;	
	u16 			sp_reserved;
} SleepParams;

/** sleep_period */	
typedef struct SleepPeriod
{
	u16 			period;
	u16 			reserved;
} SleepPeriod;

/** Data structure for the Marvell WLAN device */
typedef struct _wlan_dev {
	/** device name */
	char 			name[DEV_NAME_LEN];
  	/** card pointer */
	void			*card;
  	/** IO port */	
	u32 			ioport;
  	/** Upload received */
	u32  			upld_rcv;
 	/** Upload type */
	u32  			upld_typ;
       	/** Upload length */	
	u32 			upld_len;
  	/** netdev pointer */
	struct net_device	*netdev;
	/* Upload buffer*/
	u8  			upld_buf[WLAN_UPLD_SIZE];
	/* Download sent: 
	 	bit0 1/0=data_sent/data_tx_done, 
		bit1 1/0=cmd_sent/cmd_tx_done, 
		all other bits reserved 0 */
	u8			dnld_sent;
} wlan_dev_t, *pwlan_dev_t;

/** Private structure for the MV device */
struct _wlan_private {
	int			open;

	wlan_adapter		*adapter;
	wlan_dev_t		wlan_dev;

	struct net_device_stats	stats;

#ifdef linux
	struct iw_statistics	wstats;
	struct proc_dir_entry	*proc_entry;
	struct proc_dir_entry	*proc_dev;
#endif

	/** thread to service interrupts */
	wlan_thread 		MainThread;

#ifdef REASSOCIATION
	/** thread to service mac events */
	wlan_thread 		ReassocThread;	
#endif /* REASSOCIATION */
};

/** Wlan Adapter data structure*/
struct _wlan_adapter
{
	/** STATUS variables */
	WLAN_HARDWARE_STATUS 	HardwareStatus;
	u16 			CurrentChannel;
	u32 			FWReleaseNumber;
	u32			fwCapInfo;

	u8			TmpTxBuf[WLAN_UPLD_SIZE];
	u8			chip_rev;

	/** Command-related variables */
	u16 			SeqNum;
	CmdCtrlNode 		*CmdArray;
	/** Current Command */	
	CmdCtrlNode 		*CurCmd;

	/** Command Queues */
	/** Free command buffers */
	struct list_head 	CmdFreeQ;
	/** Pending command buffers */	
	struct list_head 	CmdPendingQ;

	/** Variables brought in from private structure */
	int			irq;

	/** Async and Sync Event variables */
	u32			IntCounter;
	u32			IntCounterSaved; /* save int for DS/PS */
	u32			EventCause;
	u8			nodeName[16]; 	/* nickname */
#ifdef SUBSCRIBE_EVENT_CTRL
	u16			GetEvents;
#endif

	/** spin locks */
	spinlock_t 		QueueSpinLock  __ATTRIB_ALIGN__;

	/** Timers */ 
	WLAN_DRV_TIMER 		MrvDrvCommandTimer  __ATTRIB_ALIGN__;
	BOOLEAN 		CommandTimerIsSet;

#ifdef REASSOCIATION
	/**Reassociation timer*/
	BOOLEAN 		TimerIsSet;
	WLAN_DRV_TIMER		MrvDrvTimer __ATTRIB_ALIGN__;
#endif /* REASSOCIATION */

	/** Event Queues */
	wait_queue_head_t	scan_q __ATTRIB_ALIGN__;
	wait_queue_head_t	ds_awake_q __ATTRIB_ALIGN__;

	u8			HisRegCpy;

#ifdef MANF_CMD_SUPPORT
	/** manf command related cmd variable*/
	u32			mfg_cmd_len;
	int			mfg_cmd_flag; 
	u32			mfg_cmd_resp_len;
	u8			*mfg_cmd;
	wait_queue_head_t	mfg_cmd_q;
#endif

#ifdef THROUGHPUT_TEST
	u8			ThruputTest;
	u32			NumTransfersTx;
	u32			NumTransfersRx;
#endif /* THROUGHPUT_TEST */

#ifdef BG_SCAN
	/** bg scan related variable */
	pHostCmd_DS_802_11_BG_SCAN_CONFIG 	bgScanConfig;
	u32 					bgScanConfigSize;
#endif /* BG_SCAN */

#ifdef WMM
	/** WMM related variable*/
	WMM_DESC				wmm;
	HostCmd_DS_802_11_WMM_TSPEC 		tspec;
	HostCmd_DS_802_11_WMM_ACK_POLICY 	ackpolicy;
	HostCmd_DS_802_11_WMM_GET_STATUS	getstatus;
	HostCmd_DS_802_11_WMM_PRIO_PKT_AVAIL	priopktavail;
#endif /* WMM */

	/** current ssid/bssid related parameters*/
	CurrentBSSParams 	CurBssParams;

	WLAN_802_11_NETWORK_INFRASTRUCTURE InfrastructureMode;
	u32 			ulAttemptedBSSIDIndex;
	u32 			ulCurrentBSSIDIndex;
	u8 			CurrentBSSID[MRVDRV_ETH_ADDR_LEN];
	WLAN_802_11_CONFIGURATION CurrentConfiguration;
	WLAN_802_11_BSSID 	CurrentBSSIDDescriptor;
	WLAN_802_11_SSID 	AttemptedSSIDBeforeScan;

	WLAN_802_11_SSID 	PreviousSSID;
	u8 			PreviousBSSID[MRVDRV_ETH_ADDR_LEN];

	BOOLEAN 		RequestViaBSSID;
        u8   			RequestedBSSID[ETH_ALEN];

	PWLAN_802_11_BSSID 	BSSIDList;
	
	u32 			ulNumOfBSSIDs;
	BOOLEAN 		bIsScanInProgress;
	u32 			ulAttemptedSSIDIndex;
	
	u8			ScanType;
	u32			ScanMode;

	/** Specific scan ssid */
	WLAN_802_11_SSID 	SpecificScanSSID;
	BOOLEAN 		SetSpecificScanSSID;

	/** Specific scan bssid */
	WLAN_802_11_MAC_ADDRESS SpecificScanBSSID;

#ifdef	PROGRESSIVE_SCAN
	u32			ScanChannelsLeft;
	u16 			ChannelsPerScan;
#endif

	u16			BeaconPeriod;

	u8			AdhocCreate;

	/** Capability Info used in Association, start, join */
	IEEEtypes_CapInfo_t	capInfo;

#ifdef REASSOCIATION
	/** Reassociation on and off */
	BOOLEAN 		Reassoc_on;
#endif /* REASSOCIATION */

	BOOLEAN			ATIMEnabled;

	/** MAC address information */
	u8 			PermanentAddr[MRVDRV_ETH_ADDR_LEN];
	u8 			CurrentAddr[MRVDRV_ETH_ADDR_LEN];
	u8 			MulticastList[MRVDRV_MAX_MULTICAST_LIST_SIZE]
						[MRVDRV_ETH_ADDR_LEN];
	u32 			NumOfMulticastMACAddr;

	/** 802.11 statistics */
	HostCmd_DS_802_11_GET_STAT wlan802_11Stat;

	BOOLEAN 		AdHocCreated;
	BOOLEAN 		AdHocFailed;

	u16			EnableHwAuto;
	u16			RateBitmap;
#ifdef ADHOC_GRATE
	/** control G Rates */
	BOOLEAN 		adhoc_grate_enabled;
#endif

	WLAN_802_11_ANTENNA 	TxAntenna;
	WLAN_802_11_ANTENNA 	RxAntenna;
	
	u32 			Channel;
	u8 			AdhocChannel;
	
	WLAN_802_11_FRAGMENTATION_THRESHOLD FragThsd;
	WLAN_802_11_RTS_THRESHOLD RTSThsd;
	
	u32 			DataRate; 
	BOOLEAN			Is_DataRate_Auto;

	/** number of association attempts for the current SSID cmd */
	u32 			m_NumAssociationAttemp;
	u16			ListenInterval; 
	u8			TxRetryCount;

	/** Tx-related variables (for single packet tx) */
	spinlock_t 		TxSpinLock  __ATTRIB_ALIGN__;
	struct sk_buff 		*CurrentTxSkb;
	struct sk_buff		RxSkbQ;
	spinlock_t 		CurrentTxLock  __ATTRIB_ALIGN__;

	/** NIC Operation characteristics */
	u32 			LinkSpeed;
	u16 			CurrentPacketFilter;
	u32 			MediaConnectStatus;
	u16 			RegionCode;
	u16 			RegionTableIndex;
	u16 			TxPowerLevel;
	

	/** POWER MANAGEMENT AND PnP SUPPORT */
	BOOLEAN 		SurpriseRemoved;
	u16 			AtimWindow;

#ifdef PS_REQUIRED
	u16 			PSMode;	/* Wlan802_11PowerModeCAM=disable
					   Wlan802_11PowerModeMAX_PSP=enable */
	u16			MultipleDtim;
	u32 			PSState;
	BOOLEAN			NeedToWakeup;

	PS_CMD_ConfirmSleep	*PSConfirmSleep;
	u16			LocalListenInterval;
#ifdef FW_WAKEUP_METHOD
	u16			fwWakeupMethod;
#endif
#endif

#ifdef DEEP_SLEEP
	BOOLEAN			IsDeepSleep;
#endif

#ifdef HOST_SLEEP
	/** Host wakeup parameter */
	BOOLEAN			bWakeupDevRequired;
	BOOLEAN			bHostSleepConfigured;
	HostCmd_DS_802_11_HOST_SLEEP_CFG HostSleepCfgParam;
	u32			WakeupTries;
#endif
		
	/** Encryption parameter */
	wlan_802_11_security_t  SecInfo;

	MRVL_WEP_KEY 		WepKey[4];
	u16 			CurrentWepKeyIndex; 

#ifdef WPA 
	/* buffer to store data from OID_802_22_ASSOCIATION_INFORMATION */
	u8 		AssocInfoBuffer[MRVDRV_ASSOCIATE_INFO_BUFFER_SIZE];
#endif

#if defined(IWGENIE_SUPPORT)
	u8 genIeBuffer[256];
	u8 genIeBufferLen;
#endif

#ifdef WPA
	WLAN_802_11_ENCRYPTION_STATUS EncryptionStatus;

	/* TRUE (1), FALSE (0), or (TRUE + 1), meaning setting GTK */
	int			IsGTK_SET; 
	

	/** Encryption Key*/	
	u8			Wpa_ie[256];
	u8			Wpa_ie_len;

	MRVL_WPA_KEY		WpaPwkKey, WpaGrpKey;

	HostCmd_DS_802_11_KEY_MATERIAL		aeskey;
#endif /* WPA */

	/* Advanced Encryption Standard */
#ifdef ADHOCAES
	BOOLEAN 		AdhocAESEnabled;
	wait_queue_head_t	cmd_EncKey __ATTRIB_ALIGN__;
#endif

	u16			RxAntennaMode;
	u16			TxAntennaMode;

	/** Requested Signal Strength*/
	u16			bcn_avg_factor;
	u16			data_avg_factor;
	u16			SNR[MAX_TYPE_B][MAX_TYPE_AVG];
	u16			NF[MAX_TYPE_B][MAX_TYPE_AVG];
	u8			RSSI[MAX_TYPE_B][MAX_TYPE_AVG];
	u32			RxPDSNRAge;


	BOOLEAN			RadioOn;
	u32			Preamble;

	/** Multi Bands Parameter*/
#ifdef MULTI_BANDS
	u8			SupportedRates[A_SUPPORTED_RATES];
#else
#ifdef G_RATE
	u8			SupportedRates[G_SUPPORTED_RATES];
#else
	u8			SupportedRates[B_SUPPORTED_RATES];
#endif
#endif

#ifdef MULTI_BANDS
	/* F/W supports multiband? */
	u16			is_multiband;	
	/* F/W supported bands */
	u16			fw_bands;
	/* User selected bands (a/b/bg/abg) */
	u16			config_bands;
	/* User selected bands (a/b/g) to start adhoc network */
	u16			adhoc_start_band;
#endif

	/** Blue Tooth Co-existence Arbitration */	
#ifdef BCA
	HostCmd_DS_802_11_BCA_TIMESHARE bca_ts;
#endif

	/** sleep_params */	
	SleepParams 		sp;

	/** sleep_period (Enhanced Power Save) */	
	SleepPeriod 		sleep_period;

	/** RF calibration data */
#ifdef CAL_DATA
	HostCmd_DS_COMMAND	caldataext;
#endif

	/** Region Channel data */
	REGION_CHANNEL		region_channel[MAX_REGION_CHANNEL_NUM];
	REGION_CHANNEL		*cur_region_channel;

#ifdef ENABLE_802_11D
	REGION_CHANNEL		universal_channel[MAX_REGION_CHANNEL_NUM];

	/** 11D and Domain Regulatory Data */
	wlan_802_11d_domain_reg_t DomainReg;
	parsed_region_chan_11d_t  parsed_region_chan;
	
	/** FSM variable for 11d support */
	wlan_802_11d_state_t	State11D; 
#endif

#ifdef ENABLE_802_11H
	/* FSM variable for 11h support */
    	wlan_11h_state_t    state11h;
#endif

#ifdef ENABLE_MEAS
    	wlan_meas_state_t   stateMeas;
#endif

#ifdef REASSOC_CMD_SUPPORT
    	int reassocAttempt;
    	WLAN_802_11_MAC_ADDRESS reassocCurrentAp;
#endif

	/**	MISCELLANEOUS */
	/* Card Information Structure */
	u8 			CisInfoBuf[512];
	u16 			CisInfoLen;
	u8			*pRdeeprom;
	wlan_offset_value	OffsetValue;

#ifdef linux
	wait_queue_head_t	cmd_get_log;
#endif
	
	HostCmd_DS_802_11_GET_LOG LogMsg;
  	u16 ScanProbes;

	u32			PktTxCtrl;
};

#endif /* _WLAN_DEV_H_ */

