/** @file wlan_decl.h
 *  @brief This file contains declaration referring to
 *  functions defined in other source files
 *
 *  Copyright (c) Marvell Semiconductor, Inc., 2003-2005
 */
/******************************************************
Change log:
	09/29/05: add Doxygen format comments
******************************************************/ 

#ifndef _WLAN_DECL_H_
#define _WLAN_DECL_H_

/** Function Prototype Declaration */
int wlan_tx_packet(wlan_private *priv, struct sk_buff *skb);
void wlan_free_adapter(wlan_private *priv);
int SetMacPacketFilter(wlan_private *priv);

#ifdef WMM_UAPSD
int SendNullPacket(wlan_private *priv, u8 pwr_mgmt);
#endif

void Wep_encrypt(wlan_private *priv,  u8* Buf, u32 Len);
int FreeCmdBuffer(wlan_private *priv);
void CleanUpCmdCtrlNode(CmdCtrlNode *pTempNode);
CmdCtrlNode *GetFreeCmdCtrlNode(wlan_private *priv);

void SetCmdCtrlNode(wlan_private * priv,
	       CmdCtrlNode * pTempNode,
	       WLAN_OID cmd_oid,
	       u16 wait_option, 
	       void *pdata_buf);

int PrepareAndSendCommand(wlan_private * priv,
	       		u16 cmd_no,
		       	u16 cmd_action,
		      	u16 wait_option,
		       	WLAN_OID cmd_oid,
		      	void *pdata_buf);

void QueueCmd(wlan_adapter *Adapter, CmdCtrlNode *CmdNode, BOOLEAN addtail);
int JoinAdhocNetwork(wlan_private *priv, WLAN_802_11_SSID *AdhocSSID, int i);
int StartAdhocNetwork(wlan_private *priv, WLAN_802_11_SSID *AdhocSSID);
int SendSpecificScan(wlan_private *priv, WLAN_802_11_SSID *RequestedSSID);
int SetDeepSleep(wlan_private *priv, BOOLEAN bDeepSleep);
int AllocateCmdBuffer(wlan_private *priv);
int ExecuteNextCommand(wlan_private *priv);
int wlan_process_event(wlan_private *priv);
void wlan_interrupt(struct net_device *);
int wlan_scan_networks(wlan_private *priv);
int wlan_associate(wlan_private *priv, WLAN_802_11_SSID *ssid);
int SetRadioControl( wlan_private *priv );
u32 index_to_data_rate(u8 index);
u8 data_rate_to_index(u32 rate);
void HexDump(char *prompt, u8 *data, int len);
void get_version(wlan_adapter *adapter, char *version, int maxlen);
void wlan_read_write_rfreg(wlan_private *priv);

/** The proc fs interface */
void wlan_proc_entry(wlan_private *priv, struct net_device *dev);
void wlan_proc_remove(char *name);
void wlan_debug_entry(wlan_private *priv, struct net_device *dev);
void wlan_debug_remove(wlan_private *priv);
int wlan_process_rx_command(wlan_private * priv);
void wlan_process_tx(wlan_private * priv);
void CleanupAndInsertCmd(wlan_private * priv, CmdCtrlNode * pTempCmd);
void MrvDrvCommandTimerFunction(void *FunctionContext);

#ifdef REASSOCIATION
void MrvDrvTimerFunction(void *FunctionContext);
#endif /* REASSOCIATION */


int wlan_set_rate(struct net_device *dev, struct iw_request_info *info, 
				struct iw_param *vwrq, char *extra);

int wlan_set_essid(struct net_device *dev, struct iw_request_info *info,
			       struct iw_point *dwrq, char *extra);

int wlan_set_freq(struct net_device *dev, struct iw_request_info *info, 
				struct iw_freq *fwrq, char *extra);

int wlan_set_mode(struct net_device *dev, struct iw_request_info *info, 
			      	u32 * uwrq, char *extra);

int wlan_set_encode(struct net_device *dev,struct iw_request_info *info,
				struct iw_point *dwrq, char *extra);

int wlan_set_txpow(struct net_device *dev, struct iw_request_info *info,
			   	struct iw_param *vwrq, char *extra);

int wlan_set_scan(struct net_device *dev, struct iw_request_info *info, 
				struct iw_param *vwrq, char *extra);

int wlan_get_essid(struct net_device *dev, struct iw_request_info *info,
				struct iw_point *dwrq, char *extra);

int wlan_get_rate(struct net_device *dev, struct iw_request_info *info, 
				struct iw_param *vwrq, char *extra);

int wlan_set_regiontable(wlan_private *priv, u8 region, u8 band);

#ifdef DEEP_SLEEP
int wlan_deep_sleep_ioctl(wlan_private *priv, struct ifreq *rq);
#endif /* DEEP_SLEEP */

int ProcessRxed_802_3_Packet(wlan_private *priv, struct sk_buff *);
#define	ProcessRxedPacket	ProcessRxed_802_3_Packet

#ifdef PS_REQUIRED
int AllocatePSConfirmBuffer(wlan_private *priv);
void PSSleep(wlan_private *priv, int wait_option);
void PSConfirmSleep(wlan_private *priv, u16 PSMode);
void PSWakeup(wlan_private *priv, int wait_option);
#ifdef BULVERDE_SDIO
void sdio_clear_imask(mmc_controller_t);
int  sdio_check_idle_state(mmc_controller_t);
void sdio_print_imask(mmc_controller_t);
void sdio_clear_imask(mmc_controller_t);
#endif /* BULVERDE_SDIO */
#endif /* PS_REQUIRED */

#ifdef BULVERDE_SDIO
int start_bus_clock(mmc_controller_t);
int stop_bus_clock_2(mmc_controller_t);
#endif /* BULVERDE_SDIO */


#ifdef BULVERDE_SDIO
int wlan_sdio_clock(wlan_private *priv, BOOLEAN on);
#endif /* BULVERDE_SDIO */


void wlan_send_rxskbQ(wlan_private *priv);

int SSIDcmp(WLAN_802_11_SSID *ssid1, WLAN_802_11_SSID *ssid2);
int FindSSIDInList(wlan_adapter *Adapter,
		WLAN_802_11_SSID *ssid, u8 *bssid, int mode );

#if WIRELESS_EXT > 14
void send_iwevcustom_event(wlan_private *priv, s8 *str);
#endif

#endif /* _WLAN_DECL_H_ */
