/** @file sbi.h
 * 
 * @brief This file contains IF layer definitions.
 *  
 *  Copyright (c) Marvell Semiconductor, Inc., 2003-2005
 */
/********************************************************
Change log:
	10/11/05: Add Doxygen format comments
	
********************************************************/

#ifndef	_SBI_H_
#define	_SBI_H_

/**Bit Definition*/
#define B_BIT_0		0x01
#define B_BIT_1		0x02
#define B_BIT_2		0x04
#define B_BIT_3		0x08
#define B_BIT_4		0x10
#define B_BIT_5		0x20
#define B_BIT_6		0x40
#define B_BIT_7		0x80
#define B_BIT_8		0x100
#define B_BIT_9		0X200
#define B_BIT_10	0x400

/** INT Status Bit Definition*/
#define HIS_RxUpLdRdy			B_BIT_0
#define HIS_TxDnLdRdy			B_BIT_1
#define HIS_CmdDnLdRdy			B_BIT_2
#define HIS_CardEvent			B_BIT_3
#define HIS_CmdUpLdRdy			B_BIT_4
#define HIS_WrFifoOvrflow		B_BIT_5
#define HIS_RdFifoUndrflow		B_BIT_6
#define HIS_WlanReady			B_BIT_7

#ifdef CF
#define	HIM_ENABLE			0x001f
#define	HIM_DISABLE			0x001f
#else
#define	HIM_DISABLE			0xff
#ifdef MS
#define HIM_ENABLE			0x7F
#else
#define HIM_ENABLE			0x03
#endif
#endif

#define FIRMWARE_READY			0xfedc
#ifndef DEV_NAME_LEN
#define DEV_NAME_LEN			32
#endif
#define MAXKEYLEN			13

/* The number of times to try when polling for status bits */
#define MAX_POLL_TRIES			100

/* The number of times to try when waiting for downloaded firmware to 
     become active. (polling the scratch register). */

#define MAX_FIRMWARE_POLL_TRIES		100

#define FIRMWARE_TRANSFER_NBLOCK	2
#define SBI_EVENT_CAUSE_SHIFT		3

typedef enum _mv_sd_type{
	MVSD_DAT = 0,
	MVSD_CMD = 1,
	MVSD_TXDONE = 2,
	MVSD_EVENT
} mv_sd_type;

/** Function Prototype Declaration */
typedef wlan_private *	(*wlan_notifier_fn_add)(void *dev_id);
typedef int		(*wlan_notifier_fn_remove)(void *dev_id);
typedef void (*isr_notifier_fn_t)(s32 irq, void *dev_id, struct pt_regs *reg);
typedef void (*handler_fn_t)(s32 irq, void *dev_id, struct pt_regs *);

/* Probe and Check if the card is present*/
int sbi_probe_card (void *card); 
int sbi_register_dev (wlan_private *priv); 
int sbi_unregister_dev (wlan_private *);
int  sbi_disable_host_int(wlan_private *priv);
int sbi_get_int_status(wlan_private *priv, u8 *);
int *sbi_register(wlan_notifier_fn_add,wlan_notifier_fn_remove,void *);
void sbi_unregister(void);
int sbi_prog_firmware(wlan_private *);
int sbi_verify_fw_download(wlan_private *);

#ifdef HELPER_IMAGE
int sbi_prog_helper(wlan_private *);
int sbi_prog_firmware_w_helper(wlan_private *);
#endif

int sbi_read_event_cause(wlan_private *);
int sbi_reenable_host_interrupt(wlan_private *, u8);
int sbi_host_to_card(wlan_private *priv, u8 type, u8 *payload, u16 nb);
int sbi_card_to_host(wlan_private *priv, u32 type, u32 *nb, u8 *payload,
							u16 npayload);
int sbi_enable_host_int(wlan_private *);

#ifdef DEEP_SLEEP
inline int sbi_exit_deep_sleep(wlan_private *);
inline int sbi_reset_deepsleep_wakeup(wlan_private *);
#endif

#ifdef CONFIG_PM
inline int sbi_suspend(wlan_private *);
inline int sbi_resume(wlan_private *);
#endif

#if (defined SD) || (defined SPI)
int sbi_read_ioreg(wlan_private *priv, u8 func, u32 reg, u8 *dat);
int sbi_write_ioreg(wlan_private *priv, u8 func, u32 reg, u8 dat);
#endif

#ifdef CF
int sbi_read_cfreg(wlan_private *priv, s32 offset);
int sbi_write_cfreg(wlan_private *priv, s32 offset, u16 value);
#endif

int sbi_get_cis_info(wlan_private *priv);

static inline u32 get_utimeofday(void)
{
	struct timeval t;
	u32 ut;

	do_gettimeofday(&t);
	ut = (u32)t.tv_sec * 1000000 + ((u32)t.tv_usec);
	return ut;
}

#endif /* _SBI_H */

