/** @file cfio_debug.c
  * @brief This file contains bus driver debug functions.
  * 
  *  Copyright (c) Marvell Semiconductor, Inc., 2003-2005
  */
/********************************************************
Change log:
	10/04/05: Add Doxygen format comments
	
********************************************************/

#include <linux/kernel.h>

/********************************************************
		Local Variables
********************************************************/

/********************************************************
		Global Variables
********************************************************/

/********************************************************
		Local Functions
********************************************************/

/********************************************************
		Global Functions
********************************************************/
#ifdef DEBUG

/** 
 *  @brief dump data in Hex format
 *  @param prompt    prompt string
 *  @param p         data pointer
 *  @param size      data length
 *  @return 	     N/A
 */
void cfio_hexdump(u8 *prompt, u8 *p, s16 size)
{
	printk(KERN_DEBUG "%s: ", prompt);

	while (size--)
		printk("%02x ", *p++);

	printk("\n");
}

/** 
 *  @brief dump data in character format
 *  @param prompt    prompt string
 *  @param p         data pointer
 *  @param size      data length
 *  @return 	     N/A
 */
void cfio_asciidump(u8 *prompt, u8 *p, s16 size)
{
	printk(KERN_DEBUG "%s: ", prompt);

	while (size--)
		printk("%c", *p++);

	printk("\n");
}

#endif /* DEBUG */

