/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

class SolarisSerial
extends SerialPort {
    private int baud = 9600;
    private int databits = 8;
    private int stopbits = 1;
    private int parity = 0;
    private int flowcontrol = 0;
    private int port_fd;
    private SerialPortEventListener listener;
    private SSCheckStatusThread CheckStatus;
    private SSInputStream inputStream;
    private SSOutputStream outputStream;
    private int rcvThreshold = -1;
    private int rcvTimeout = -1;
    byte[] tmprbuf;
    private boolean write_finished_flag = false;
    private Object write_finished_flag_lock = new Object();
    private SSReaderThread readerThread;
    private static final int STATUS_DTR = 1;
    private static final int STATUS_RTS = 2;
    private static final int STATUS_CTS = 4;
    private static final int STATUS_DSR = 8;
    private static final int STATUS_RI = 16;
    private static final int STATUS_CD = 32;
    private static final int STATUS_DATA_AVAIL = 1;
    private static final int STATUS_OUTPUTEMPTY = 2;
    private int notificationMask;
    private static final int NOTIFY_DataAvailable = 1;
    private static final int NOTIFY_OutputEmpty = 2;
    private static final int NOTIFY_CTS = 4;
    private static final int NOTIFY_DSR = 8;
    private static final int NOTIFY_RingIndicator = 16;
    private static final int NOTIFY_CarrierDetect = 32;
    private static final int NOTIFY_OverrunError = 64;
    private static final int NOTIFY_ParityError = 128;
    private static final int NOTIFY_FramingError = 256;
    private static final int NOTIFY_BreakInterrupt = 512;
    private int framing_byte = -1;
    private int ibuffer_size = 1024;
    private int obuffer_size = 1024;

    private native void nWaitForEvent(int var1);

    private native int nCheckBreak(int var1);

    private native int nCheckParityErrors(int var1);

    public SolarisSerial(String string) throws IOException {
        this.name = string;
        if (this.port_fd != 0) {
            return;
        }
        this.port_fd = this.openNativePort(string);
        if (this.port_fd > 0) {
            try {
                this.setNativeSerialPortParams(this.port_fd, 1, this.baud, this.databits, this.stopbits, this.parity, this.flowcontrol);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {}
            this.tmprbuf = new byte[1];
            this.readerThread = new SSReaderThread();
            this.readerThread.start();
            return;
        }
        throw new IOException(String.valueOf(-this.port_fd));
    }

    private native void nReaderThread(int var1);

    protected void finalize() {
        this.close();
    }

    public int getBaudRate() {
        if (this.port_fd != 0) {
            return this.nativeGetBaudRate(this.port_fd);
        }
        throw new IllegalStateException("This port is closed");
    }

    public int getDataBits() {
        if (this.port_fd != 0) {
            return this.nativeGetDataBits(this.port_fd);
        }
        throw new IllegalStateException("This port is closed");
    }

    public int getStopBits() {
        if (this.port_fd != 0) {
            return this.nativeGetStopBits(this.port_fd);
        }
        throw new IllegalStateException("This port is closed");
    }

    public int getParity() {
        if (this.port_fd != 0) {
            return this.nativeGetParity(this.port_fd);
        }
        throw new IllegalStateException("This port is closed");
    }

    private native int nativeGetBaudRate(int var1);

    private native int nativeGetDataBits(int var1);

    private native int nativeGetStopBits(int var1);

    private native int nativeGetParity(int var1);

    public void sendBreak(int n) {
        if (this.port_fd != 0) {
            this.nativeSendBreak(this.port_fd);
            return;
        }
        throw new IllegalStateException("This port is closed");
    }

    private native void nativeSendBreak(int var1);

    public void setFlowControlMode(int n) throws UnsupportedCommOperationException {
        try {
            if (this.port_fd != 0) {
                if ((n & 1) != 0 ? (n & 8) != 0 || (n & 4) != 0 : (n & 2) != 0 && ((n & 4) != 0 || (n & 8) != 0)) {
                    throw new UnsupportedCommOperationException("Cannot mix hardware and software flow control");
                }
                this.setNativeSerialPortParams(this.port_fd, 0, this.baud, this.databits, this.stopbits, this.parity, n);
                this.flowcontrol = n;
                return;
            }
            throw new IllegalStateException("This port is closed");
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            unsupportedCommOperationException.printStackTrace();
            return;
        }
    }

    public int getFlowControlMode() {
        if (this.port_fd != 0) {
            return this.nativeGetFlowctrl(this.port_fd);
        }
        throw new IllegalStateException("This port is closed");
    }

    private native int nativeGetFlowctrl(int var1);

    public void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        if (n2 != 5 && n2 != 6 && n2 != 7 && n2 != 8) {
            throw new UnsupportedCommOperationException("Unsupported number of databits");
        }
        if (n3 != 1 && n3 != 2) {
            throw new UnsupportedCommOperationException("Unsupported number of stopbits" + n3);
        }
        if (n4 != 2 && n4 != 1 && n4 != 0) {
            throw new UnsupportedCommOperationException("Unsupported parity value");
        }
        if (this.port_fd != 0) {
            this.setNativeSerialPortParams(this.port_fd, 0, n, n2, n3, n4, this.flowcontrol);
            this.baud = n;
            this.databits = n2;
            this.stopbits = n3;
            this.parity = n4;
            return;
        }
        throw new IllegalStateException("This port is closed");
    }

    private native void setNativeSerialPortParams(int var1, int var2, int var3, int var4, int var5, int var6, int var7) throws UnsupportedCommOperationException;

    public void setDTR(boolean bl) {
        if (this.port_fd != 0) {
            this.nativeSetDTR(this.port_fd, bl);
            return;
        }
        throw new IllegalStateException("This port is closed");
    }

    public native void nativeSetDTR(int var1, boolean var2);

    public void setRTS(boolean bl) {
        if (this.port_fd != 0) {
            if ((this.flowcontrol & 1) == 1) {
                throw new IllegalStateException("Cannot modify RTS when Hardware flowcontrol is on.");
            }
            this.nativeSetRTS(this.port_fd, bl);
            return;
        }
        throw new IllegalStateException("This port is closed");
    }

    public native void nativeSetRTS(int var1, boolean var2);

    public boolean isDTR() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 1) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isRTS() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 2) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isCTS() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 4) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isDSR() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 8) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isRI() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 0x10) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isCD() {
        if (this.port_fd != 0) {
            return (this.getStatusFlags(this.port_fd) & 0x20) > 0;
        }
        throw new IllegalStateException("This port is closed");
    }

    private native int getStatusFlags(int var1);

    public void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        if (this.port_fd != 0) {
            if (this.listener != null) {
                throw new TooManyListenersException("Only one listener is allowed");
            }
            this.listener = serialPortEventListener;
            if (this.CheckStatus == null) {
                this.CheckStatus = new SSCheckStatusThread(this, serialPortEventListener);
            }
            this.CheckStatus.start();
            return;
        }
        throw new IllegalStateException("This port is closed");
    }

    public void removeEventListener() {
        this.listener = null;
        this.CheckStatus.stop();
    }

    public void notifyOnDataAvailable(boolean bl) {
        this.notificationMask &= 0xFFFFFFFE;
        if (bl) {
            this.notificationMask |= 1;
        }
    }

    public void notifyOnOutputEmpty(boolean bl) {
        this.notificationMask &= 0xFFFFFFFD;
        if (bl) {
            this.notificationMask |= 2;
        }
    }

    public void notifyOnCTS(boolean bl) {
        this.notificationMask &= 0xFFFFFFFB;
        if (bl) {
            this.notificationMask |= 4;
        }
    }

    public void notifyOnDSR(boolean bl) {
        this.notificationMask &= 0xFFFFFFF7;
        if (bl) {
            this.notificationMask |= 8;
        }
    }

    public void notifyOnRingIndicator(boolean bl) {
        this.notificationMask &= 0xFFFFFFEF;
        if (bl) {
            this.notificationMask |= 0x10;
        }
    }

    public void notifyOnCarrierDetect(boolean bl) {
        this.notificationMask &= 0xFFFFFFDF;
        if (bl) {
            this.notificationMask |= 0x20;
        }
    }

    public void notifyOnOverrunError(boolean bl) {
        this.notificationMask &= 0xFFFFFFBF;
        if (bl) {
            this.notificationMask |= 0x40;
        }
    }

    public void notifyOnParityError(boolean bl) {
        this.notificationMask &= 0xFFFFFF7F;
        if (bl) {
            this.notificationMask |= 0x80;
        }
    }

    public void notifyOnFramingError(boolean bl) {
        this.notificationMask &= 0xFFFFFEFF;
        if (bl) {
            this.notificationMask |= 0x100;
        }
    }

    public void notifyOnBreakInterrupt(boolean bl) {
        this.notificationMask &= 0xFFFFFDFF;
        if (bl) {
            this.notificationMask |= 0x200;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.port_fd != 0) {
            if (this.inputStream == null) {
                this.inputStream = new SSInputStream();
            }
            return this.inputStream;
        }
        throw new IllegalStateException("This port is closed");
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.port_fd != 0) {
            if (this.outputStream == null) {
                this.outputStream = new SSOutputStream();
            }
            return this.outputStream;
        }
        throw new IllegalStateException("This port is closed");
    }

    public void close() {
        if (this.port_fd == 0) {
            return;
        }
        try {
            if (this.port_fd > 0) {
                this.closeNativePort(this.port_fd);
                this.port_fd = 0;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        super.close();
    }

    private native int openNativePort(String var1) throws IOException;

    private native void closeNativePort(int var1) throws IOException;

    private native int available(int var1) throws IOException;

    private native int read(int var1, byte[] var2, int var3, int var4, int var5, int var6) throws IOException;

    private native int write(int var1, byte[] var2, int var3, int var4) throws IOException;

    private native int flush(int var1);

    public void enableReceiveThreshold(int n) throws UnsupportedCommOperationException {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        if (n < 0) {
            throw new UnsupportedCommOperationException("This threshold value is not supported");
        }
        this.rcvThreshold = n;
    }

    public void disableReceiveThreshold() {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.rcvThreshold = -1;
    }

    public boolean isReceiveThresholdEnabled() {
        return this.rcvThreshold >= 0;
    }

    public int getReceiveThreshold() {
        return this.rcvThreshold;
    }

    public void enableReceiveTimeout(int n) throws UnsupportedCommOperationException {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        if (n < 0) {
            throw new UnsupportedCommOperationException("This timeout value is not supported");
        }
        this.rcvTimeout = n;
    }

    public void disableReceiveTimeout() {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.rcvTimeout = -1;
    }

    public boolean isReceiveTimeoutEnabled() {
        return this.rcvTimeout > 0;
    }

    public int getReceiveTimeout() {
        return this.rcvTimeout;
    }

    private native void nSetFramingByte(int var1, int var2);

    public void disableReceiveFraming() {
        this.framing_byte = -1;
        if (this.port_fd != 0) {
            this.nSetFramingByte(this.port_fd, this.framing_byte);
            return;
        }
        throw new IllegalStateException("This port is closed");
    }

    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        if (this.port_fd != 0) {
            this.framing_byte = n & 0xFF;
            this.nSetFramingByte(this.port_fd, this.framing_byte);
            return;
        }
        throw new IllegalStateException("This port is closed");
    }

    public boolean isReceiveFramingEnabled() {
        return this.framing_byte != -1;
    }

    public int getReceiveFramingByte() {
        return this.framing_byte;
    }

    public void setInputBufferSize(int n) {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.ibuffer_size = n;
    }

    public int getInputBufferSize() {
        return this.ibuffer_size;
    }

    public void setOutputBufferSize(int n) {
        if (this.port_fd == 0) {
            throw new IllegalStateException("This port is closed");
        }
        this.obuffer_size = n;
    }

    public int getOutputBufferSize() {
        return this.obuffer_size;
    }

    static /* synthetic */ int access$9() {
        return 1;
    }

    static /* synthetic */ int access$10() {
        return 2;
    }

    static /* synthetic */ int access$12() {
        return 512;
    }

    static /* synthetic */ int access$14() {
        return 128;
    }

    static /* synthetic */ int access$16() {
        return 32;
    }

    static /* synthetic */ int access$17() {
        return 8;
    }

    static /* synthetic */ int access$18() {
        return 4;
    }

    static /* synthetic */ int access$19() {
        return 16;
    }

    static /* synthetic */ int access$20() {
        return 32;
    }

    static /* synthetic */ int access$21() {
        return 8;
    }

    static /* synthetic */ int access$22() {
        return 4;
    }

    static /* synthetic */ int access$23() {
        return 16;
    }

    public class SSInputStream
    extends InputStream {
        private byte[] buf;
        private int pos = -1;

        public int available() throws IOException {
            if (SolarisSerial.this.port_fd != 0) {
                return SolarisSerial.this.available(SolarisSerial.this.port_fd);
            }
            throw new IOException("This port is closed");
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n2;
            int n4 = 0;
            if (byArray == null) {
                byArray = new byte[n2 + n];
            }
            if (n2 + n > byArray.length) {
                n3 = byArray.length - n;
            }
            if (SolarisSerial.this.port_fd != 0) {
                n4 = SolarisSerial.this.read(SolarisSerial.this.port_fd, byArray, n, n3, SolarisSerial.this.rcvTimeout, SolarisSerial.this.rcvThreshold);
                return n4;
            }
            throw new IOException("This port is closed");
        }

        void hexdump(byte[] byArray, int n) {
            int n2 = 0;
            System.out.println("\nDumping " + n + " bytes from input buffer:\n");
            int n3 = 0;
            if (n % 16 != 0) {
                n3 = 1;
            }
            int n4 = 0;
            while (n4 < n / 16 + n3) {
                String string = Integer.toHexString(n2);
                switch (string.length()) {
                    case 0: {
                        string = "0000" + string;
                        break;
                    }
                    case 1: {
                        string = "000" + string;
                        break;
                    }
                    case 2: {
                        string = "00" + string;
                        break;
                    }
                    case 3: {
                        string = "0" + string;
                        break;
                    }
                }
                System.out.print(String.valueOf(string) + ": ");
                int n5 = 0;
                while (n5 < 16) {
                    String string2 = "";
                    string2 = n5 >= n - n4 * 16 ? "00" : Integer.toHexString(byArray[n5 + n2]);
                    if (string2.length() < 2) {
                        string2 = "0" + string2;
                    } else if (string2.length() > 2) {
                        string2 = string2.substring(6);
                    }
                    System.out.print(String.valueOf(string2) + " ");
                    if ((n5 + 1) % 8 == 0) {
                        System.out.print(" ");
                    }
                    ++n5;
                }
                int n6 = 0;
                while (n6 < 16) {
                    if (n6 >= n - n4 * 16) {
                        System.out.print('.');
                    } else {
                        char c = (char)byArray[n6 + n2];
                        byte by = byArray[n6 + n2];
                        if (by < 32 || by > 127) {
                            c = '.';
                        }
                        System.out.print(c);
                    }
                    ++n6;
                }
                System.out.println("");
                n2 += 16;
                ++n4;
            }
            System.out.println("");
        }

        public int read() throws IOException {
            int n = 0;
            if (SolarisSerial.this.port_fd != 0) {
                n = SolarisSerial.this.read(SolarisSerial.this.port_fd, SolarisSerial.this.tmprbuf, 0, 1, SolarisSerial.this.rcvTimeout, SolarisSerial.this.rcvThreshold);
                if (n == 1) {
                    return SolarisSerial.this.tmprbuf[0] & 0xFF;
                }
                return -1;
            }
            throw new IOException("This port is closed");
        }

        public SSInputStream() {
            SolarisSerial.this = SolarisSerial.this;
        }
    }

    public class SSOutputStream
    extends OutputStream {
        private boolean open = true;

        public void close() {
            this.open = false;
        }

        public void write(int n) throws IOException {
            byte[] byArray = new byte[]{(byte)n};
            this.write(byArray, 0, 1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            int n3 = n2;
            int n4 = 0;
            if (!this.open) throw new IOException("This output stream is closed");
            if (SolarisSerial.this.port_fd == 0) throw new IOException("This port is closed");
            if (byArray == null) return;
            if (n2 + n > byArray.length) {
                n3 = byArray.length - n;
            }
            n4 = SolarisSerial.this.write(SolarisSerial.this.port_fd, byArray, n, n3);
            Object object = SolarisSerial.this.write_finished_flag_lock;
            synchronized (object) {
                SolarisSerial.this.write_finished_flag = true;
                return;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void flush() throws IOException {
            int n = -1;
            if (!this.open) throw new IOException("This output stream is closed");
            if (SolarisSerial.this.port_fd == 0) throw new IOException("This port is closed");
            n = SolarisSerial.this.flush(SolarisSerial.this.port_fd);
            if (n != -1) return;
            throw new IOException("failed to flushoutput stream");
        }

        public SSOutputStream() {
            SolarisSerial.this = SolarisSerial.this;
        }
    }

    public class SSCheckStatusThread
    extends Thread {
        private boolean lastCD;
        private boolean lastRI;
        private boolean lastCTS;
        private boolean lastDSR;
        private boolean lastOE;
        private boolean lastPE;
        private boolean lastFE;
        private boolean lastBI;
        private SolarisSerial SSport;

        SSCheckStatusThread(SolarisSerial solarisSerial2, SerialPortEventListener serialPortEventListener) {
            SolarisSerial.this = SolarisSerial.this;
            this.SSport = solarisSerial2;
        }

        public void run() {
            this.lastCD = SolarisSerial.this.isCD();
            this.lastRI = SolarisSerial.this.isRI();
            this.lastDSR = SolarisSerial.this.isDSR();
            this.lastCTS = SolarisSerial.this.isCTS();
            while (SolarisSerial.this.port_fd != 0) {
                boolean bl;
                SolarisSerial.this.nWaitForEvent(SolarisSerial.this.port_fd);
                if (SolarisSerial.this.port_fd == 0) break;
                try {
                    if (SolarisSerial.this.available(SolarisSerial.this.port_fd) > 0) {
                        this.RaiseEvent(SolarisSerial.this.notificationMask, SolarisSerial.access$9(), this.SSport, 1, false, true);
                    }
                }
                catch (IOException iOException) {
                    System.err.println(String.valueOf(iOException) + " trying to send data avail ev");
                }
                if (SolarisSerial.this.port_fd == 0) break;
                Object object = SolarisSerial.this.write_finished_flag_lock;
                synchronized (object) {
                    if (SolarisSerial.this.write_finished_flag) {
                        SolarisSerial.this.write_finished_flag = false;
                        this.RaiseEvent(SolarisSerial.this.notificationMask, SolarisSerial.access$10(), this.SSport, 2, false, true);
                    }
                }
                if (SolarisSerial.this.port_fd == 0) break;
                int n = SolarisSerial.this.nCheckBreak(SolarisSerial.this.port_fd);
                if (n > 0) {
                    while (n-- > 0) {
                        this.RaiseEvent(SolarisSerial.this.notificationMask, SolarisSerial.access$12(), this.SSport, 10, false, true);
                        if (SolarisSerial.this.port_fd == 0) break;
                    }
                }
                if (SolarisSerial.this.port_fd == 0) break;
                int n2 = SolarisSerial.this.nCheckParityErrors(SolarisSerial.this.port_fd);
                if (n2 > 0) {
                    while (n2-- > 0) {
                        this.RaiseEvent(SolarisSerial.this.notificationMask, SolarisSerial.access$14(), this.SSport, 8, false, true);
                        if (SolarisSerial.this.port_fd == 0) break;
                    }
                }
                if (SolarisSerial.this.port_fd == 0) break;
                int n3 = SolarisSerial.this.getStatusFlags(SolarisSerial.this.port_fd);
                boolean bl2 = (n3 & SolarisSerial.access$16()) > 0;
                boolean bl3 = (n3 & SolarisSerial.access$17()) > 0;
                boolean bl4 = (n3 & SolarisSerial.access$18()) > 0;
                boolean bl5 = bl = (n3 & SolarisSerial.access$19()) > 0;
                if (bl2 != this.lastCD) {
                    this.RaiseEvent(SolarisSerial.this.notificationMask, SolarisSerial.access$20(), this.SSport, 6, this.lastCD, bl2);
                }
                if (SolarisSerial.this.port_fd == 0) break;
                if (bl3 != this.lastDSR) {
                    this.RaiseEvent(SolarisSerial.this.notificationMask, SolarisSerial.access$21(), this.SSport, 4, this.lastDSR, bl3);
                }
                if (SolarisSerial.this.port_fd == 0) break;
                if (bl4 != this.lastCTS) {
                    this.RaiseEvent(SolarisSerial.this.notificationMask, SolarisSerial.access$22(), this.SSport, 3, this.lastCTS, bl4);
                }
                if (SolarisSerial.this.port_fd == 0) break;
                if (bl != this.lastRI) {
                    this.RaiseEvent(SolarisSerial.this.notificationMask, SolarisSerial.access$23(), this.SSport, 5, this.lastRI, bl);
                }
                if (SolarisSerial.this.port_fd == 0) break;
                this.lastCD = bl2;
                this.lastDSR = bl3;
                this.lastCTS = bl4;
                this.lastRI = bl;
            }
        }

        private void RaiseEvent(int n, int n2, SolarisSerial solarisSerial, int n3, boolean bl, boolean bl2) {
            if (SolarisSerial.this.listener != null && bl != bl2 && (n & n2) != 0) {
                SolarisSerial.this.listener.serialEvent(new SerialPortEvent(solarisSerial, n3, bl, bl2));
            }
        }
    }

    private class SSReaderThread
    extends Thread {
        public void run() {
            while (SolarisSerial.this.port_fd != 0) {
                SolarisSerial.this.nReaderThread(SolarisSerial.this.port_fd);
            }
        }

        SSReaderThread() {
            SolarisSerial.this = SolarisSerial.this;
        }
    }
}

